/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.FilterSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ObjectManager {
    private Map<String, StaticCall> staticObjects;
    private TIntIntHashMap firstOccurrenceIndex;
    private TIntIntHashMap lastOccurrenceIndex;
    private TIntObjectHashMap<String> objectClassName;
    private TIntObjectHashMap<SequenceObject> sequenceObjects;
    private int groupCount = 0;
    private TIntIntHashMap objectGroupID = new TIntIntHashMap();

    private ObjectManager() {
        this.firstOccurrenceIndex = new TIntIntHashMap();
        this.lastOccurrenceIndex = new TIntIntHashMap();
        this.staticObjects = new HashMap<String, StaticCall>(1024);
        this.objectClassName = new TIntObjectHashMap();
        this.sequenceObjects = new TIntObjectHashMap();
    }

    public ObjectManager(Node node, FilterSet filters) {
        this();
        this.makeObjectGroups(node);
        this.makeSequenceObjects();
        this.applyFilters(filters);
    }

    public ObjectManager(NodeList nodes, FilterSet filters) {
        this();
        CallTreeIterator nit = nodes.nodeIterator();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            this.makeObjectGroups(node);
        }
        this.makeSequenceObjects();
        this.applyFilters(filters);
    }

    private void makeObjectGroups(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.empty()) {
            Node n = (Node)stack.pop();
            this.processNode(n);
            NodeList children = n.getChildren();
            ListIterator<Node> iterator = children.listIterator(children.size());
            while (iterator.hasPrevious()) {
                stack.push(iterator.previous());
            }
        }
    }

    private void processNode(Node node) {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            Set<Integer> idSet = call.getId();
            if (idSet.size() > 1) {
                int objID;
                int groupID = 0;
                int minOccurrence = call.getCallIndex();
                int maxOccurrence = call.getCallIndex();
                for (Integer idx : idSet) {
                    objID = idx;
                    if (!this.objectGroupID.containsKey(objID)) continue;
                    assert (groupID == 0 || groupID == this.objectGroupID.get(objID)) : "If two groups overlap with each other, the groups must be merged.";
                    groupID = this.objectGroupID.get(objID);
                    if (this.firstOccurrenceIndex.containsKey(objID)) {
                        minOccurrence = Math.min(minOccurrence, this.firstOccurrenceIndex.get(objID));
                    }
                    if (!this.lastOccurrenceIndex.containsKey(objID)) continue;
                    maxOccurrence = Math.max(maxOccurrence, this.lastOccurrenceIndex.get(objID));
                }
                if (groupID == 0) {
                    ++this.groupCount;
                    groupID = this.groupCount;
                }
                for (Integer idx : idSet) {
                    objID = idx;
                    this.objectGroupID.put(objID, groupID);
                    this.firstOccurrenceIndex.put(objID, minOccurrence);
                    this.lastOccurrenceIndex.put(objID, maxOccurrence);
                }
            } else {
                int objID = idSet.iterator().next();
                if (objID == 0) {
                    String className = call.getFullClassName();
                    if (!this.staticObjects.containsKey(className)) {
                        this.staticObjects.put(className, new StaticCall(className, call.getCallIndex(), new SequenceObject(call)));
                    } else {
                        this.staticObjects.get(className).updateLastCall(call.getCallIndex());
                    }
                } else {
                    if (this.firstOccurrenceIndex.containsKey(objID) && this.firstOccurrenceIndex.get(objID) > call.getCallIndex()) {
                        this.firstOccurrenceIndex.put(objID, call.getCallIndex());
                    }
                    if (this.lastOccurrenceIndex.containsKey(objID) && this.lastOccurrenceIndex.get(objID) < call.getCallIndex()) {
                        this.lastOccurrenceIndex.put(objID, call.getCallIndex());
                    }
                }
            }
            for (Integer idx : idSet) {
                int objID = idx;
                if (objID == 0 || this.objectClassName.containsKey(objID)) continue;
                this.objectClassName.put(objID, (Object)(String.valueOf(call.getPackageName()) + " " + call.getClassName()));
            }
        }
    }

    private void makeSequenceObjects() {
        final SequenceObject[] seq = new SequenceObject[this.groupCount + 1];
        int i = 1;
        while (i < this.groupCount + 1) {
            seq[i] = new SequenceObject();
            ++i;
        }
        this.objectClassName.forEachKey(new TIntProcedure(){

            public boolean execute(int objectID) {
                if (ObjectManager.this.objectGroupID.containsKey(objectID)) {
                    int groupID = ObjectManager.this.objectGroupID.get(objectID);
                    seq[groupID].addClassName((String)ObjectManager.this.objectClassName.get(objectID));
                    seq[groupID].addId(objectID);
                    ObjectManager.this.sequenceObjects.put(objectID, (Object)seq[groupID]);
                } else {
                    SequenceObject obj = new SequenceObject();
                    obj.addClassName((String)ObjectManager.this.objectClassName.get(objectID));
                    obj.addId(objectID);
                    ObjectManager.this.sequenceObjects.put(objectID, (Object)obj);
                }
                return true;
            }
        });
    }

    private void applyFilters(FilterSet filters) {
        this.applyObjectFilters(filters);
        this.applyUnificationFilters(filters);
    }

    private void applyUnificationFilters(FilterSet filters) {
        final ArrayList<SequenceObject> seq = new ArrayList<SequenceObject>();
        this.sequenceObjects.forEachValue((TObjectProcedure)new TObjectProcedure<SequenceObject>(){

            public boolean execute(SequenceObject obj) {
                seq.add(obj);
                return true;
            }
        });
        for (StaticCall st : this.staticObjects.values()) {
            seq.add(st.obj);
        }
        List<Collection<SequenceObject>> groups = filters.applyObjectUnificationFilters(seq);
        TObjectIntHashMap seqobjToGroupID = new TObjectIntHashMap();
        int groupCount = 0;
        TIntIntHashMap groupIDMap = new TIntIntHashMap();
        for (Collection<SequenceObject> group : groups) {
            TIntArrayList groupIDs = new TIntArrayList();
            for (SequenceObject member : group) {
                int existingID = seqobjToGroupID.get((Object)member);
                if (existingID <= 0) continue;
                groupIDs.add(existingID);
            }
            if (groupIDs.size() < 2) {
                int groupID;
                if (groupIDs.size() == 0) {
                    groupID = ++groupCount;
                    groupIDMap.put(groupID, groupID);
                } else {
                    groupID = groupIDs.get(0);
                }
                for (SequenceObject member : group) {
                    seqobjToGroupID.put((Object)member, groupID);
                }
                continue;
            }
            int aGroupID = groupIDs.get(0);
            int i = 1;
            while (i < groupIDs.size()) {
                groupIDMap.put(groupIDs.get(i), aGroupID);
                ++i;
            }
            for (SequenceObject member : group) {
                seqobjToGroupID.put((Object)member, aGroupID);
            }
        }
        SequenceObject[] newObjects = new SequenceObject[groupCount + 1];
        int i = 1;
        while (i < newObjects.length) {
            newObjects[i] = new SequenceObject();
            newObjects[i].setVisibleState(2);
            ++i;
        }
        int[] keys = this.sequenceObjects.keys();
        int i2 = 0;
        while (i2 < keys.length) {
            SequenceObject obj = (SequenceObject)this.sequenceObjects.get(keys[i2]);
            int groupID = groupIDMap.get(seqobjToGroupID.get((Object)obj));
            if (groupID != 0) {
                newObjects[groupID].merge(obj);
                this.sequenceObjects.put(keys[i2], (Object)newObjects[groupID]);
            }
            ++i2;
        }
        for (StaticCall st : this.staticObjects.values()) {
            int groupID = groupIDMap.get(seqobjToGroupID.get((Object)st.obj));
            if (groupID == 0) continue;
            newObjects[groupID].merge(st.obj);
            st.obj = newObjects[groupID];
        }
    }

    private void applyObjectFilters(final FilterSet filters) {
        this.sequenceObjects.forEachValue((TObjectProcedure)new TObjectProcedure<SequenceObject>(){

            public boolean execute(SequenceObject obj) {
                filters.applyObjectFilters(obj);
                return true;
            }
        });
        for (StaticCall st : this.staticObjects.values()) {
            filters.applyObjectFilters(st.obj);
        }
    }

    public SequenceObject getObject(CallNode call) {
        Set<Integer> objectIDs = call.getId();
        if (objectIDs.size() >= 1) {
            int objID = objectIDs.iterator().next();
            if (objID == 0) {
                return this.staticObjects.get(call.getFullClassName()).obj;
            }
            return (SequenceObject)this.sequenceObjects.get(objID);
        }
        assert (false) : "Object IDs must be a non-empty set.";
        return null;
    }

    private static class StaticCall {
        private SequenceObject obj;

        public StaticCall(String fullClassName, int callIndex, SequenceObject seq) {
            this.obj = seq;
        }

        public void updateLastCall(int callIndex) {
        }
    }
}

