/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.MethodMissingLoopNode;
import amida.calltree.Node;
import amida.calltree.ObjectDifferenceLoopNode;
import amida.calltree.SimpleLoopNode;
import amida.viewer.ModelChangeListener;
import amida.viewer.SelectableItems;
import amida.viewer.SequenceDiagramModel;
import amida.viewer.SequenceSelectionModel;
import amida.viewer.ViewUpdater;
import amida.viewer.elements.Called;
import amida.viewer.elements.ISequenceElement;
import amida.viewer.elements.SelectableElement;
import amida.viewer.elements.Sequence;
import amida.viewer.elements.SequenceBlock;
import amida.viewer.elements.SequenceDiagramAdjuster;
import amida.viewer.elements.SequenceLoop;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.DominanceFilter;
import amida.viewer.filter.DominatorUnificationFilter;
import amida.viewer.filter.FilterFactory;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class SequenceDiagramDrawer
implements ModelChangeListener {
    private static final int xOverviewRate = 3;
    private static final int yOverviewRate = 2;
    private static final Insets MARGIN = new Insets(5, 5, 5, 5);
    private SequenceDiagramModel model;
    private SequenceDiagramAdjuster adjuster;
    private SequenceSelectionModel selectionModel;
    private SelectableItems selectables;
    private ViewUpdater updater;
    private static final int DOMINATOR_COLOR = 19;
    private static final int SELECTION_COLOR = 15;
    private static final int BACKGROUND_COLOR = 1;
    private static final int OBJECT_TEXT_SIDE_MARGIN = 3;
    private static final String OBJECTS_OMITTED = "... ";

    public SequenceDiagramDrawer(SequenceDiagramModel model, ViewUpdater updater) {
        this.model = model;
        this.adjuster = new SequenceDiagramAdjuster();
        this.selectionModel = new SequenceSelectionModel(model);
        this.selectables = new SelectableItems();
        if (this.model != null) {
            this.model.addModelChangeListener(this);
        }
        this.updater = updater;
        this.selectionModel.addSelectionListener(updater);
        this.adjuster.setFontSize(9.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point computeDiagramSize() {
        if (this.model == null) {
            return new Point(-1, -1);
        }
        SequenceDiagramModel sequenceDiagramModel = this.model;
        synchronized (sequenceDiagramModel) {
            int x = this.adjuster.getXPosFromObjectIndex(this.model.getMaxObjectIndex()) + this.adjuster.getMargin().right;
            int y = this.adjuster.getYPosFromSequenceIndex(this.model.getSequenceNum()) + this.adjuster.getMargin().bottom;
            return new Point(x, y);
        }
    }

    public Point computeOverviewSize() {
        if (this.model == null) {
            return new Point(-1, -1);
        }
        return new Point(3 * this.model.getMaxObjectIndex(), 2 * this.model.getSequenceNum());
    }

    public void drawTopObject(Display display, GC gc, org.eclipse.swt.graphics.Rectangle viewRange, int diagramAreaTop) {
        if (this.model == null || this.adjuster == null || gc == null || viewRange == null) {
            return;
        }
        gc.setFont(new Font((Device)display, "", (int)this.adjuster.getFontSize(), 0));
        gc.setForeground(display.getSystemColor(2));
        int startObjectIndex = this.adjuster.getObjectIndexFromCursorPos(viewRange.x) - 1;
        int endObjectIndex = this.adjuster.getObjectIndexFromCursorPos(viewRange.x + viewRange.width) + 1;
        if (startObjectIndex < 1) {
            startObjectIndex = 1;
        }
        if (endObjectIndex > this.model.getMaxObjectIndex()) {
            endObjectIndex = this.model.getMaxObjectIndex();
        }
        int fontHeight = gc.getFontMetrics().getHeight();
        int topEventIndex = diagramAreaTop / this.adjuster.getSequenceSpace() - 1;
        int objectHeight = Math.max(viewRange.height - this.adjuster.getMargin().bottom - this.adjuster.getMargin().top, this.adjuster.getObjectHeight());
        int textAreaWidth = this.adjuster.getObjectWidth() - 6;
        int textAreaHeight = objectHeight - this.adjuster.getMargin().top - this.adjuster.getMargin().bottom;
        int textY = this.adjuster.getMargin().top * 2;
        int i = startObjectIndex;
        while (i <= endObjectIndex) {
            SequenceObject object = this.model.getObject(i);
            int x = this.adjuster.getXPosFromObjectIndex(i) - viewRange.x;
            org.eclipse.swt.graphics.Rectangle clipRect = new org.eclipse.swt.graphics.Rectangle(x, textY, textAreaWidth, textAreaHeight);
            if (object.isVisible(topEventIndex)) {
                DominatorUnificationFilter f;
                DominanceFilter filter;
                if (this.selectionModel.isSelectedObject(i)) {
                    gc.setBackground(display.getSystemColor(15));
                    gc.fillRectangle(x, this.adjuster.getMargin().top, this.adjuster.getObjectWidth(), objectHeight);
                    gc.setBackground(display.getSystemColor(1));
                } else if (object.getIdList().length == 1 && (filter = this.model.getFilters().getDominanceFilter()) != null && (f = filter.getDominatorFilter(object)) != null && f.getDominator() == object.getIdList()[0]) {
                    gc.setBackground(display.getSystemColor(19));
                    gc.fillRectangle(x, this.adjuster.getMargin().top, this.adjuster.getObjectWidth(), objectHeight);
                    gc.setBackground(display.getSystemColor(1));
                }
                gc.drawRectangle(x, this.adjuster.getMargin().top, this.adjuster.getObjectWidth(), objectHeight);
                gc.setClipping(clipRect);
                String packageName = object.getNameSpace();
                int line = this.drawClassName(display, gc, String.valueOf(packageName) + ":", x + 3, textY, clipRect);
                String className = object.getClassName();
                line += this.drawClassName(display, gc, className, x + 3, textY + fontHeight * line, clipRect);
                int lines = textAreaHeight / fontHeight - line;
                this.drawObjectIdString(gc, object.getObjectCountString(), object.getObjectIDLabels(), x + 3, textY + fontHeight * line, clipRect, lines);
                gc.setClipping(null);
            }
            ++i;
        }
    }

    private int drawClassName(Display display, GC gc, String text, int x, int y, org.eclipse.swt.graphics.Rectangle textareaRect) {
        FontMetrics fm = gc.getFontMetrics();
        int textWidth = gc.textExtent((String)text).x;
        if (textWidth <= textareaRect.width) {
            gc.drawString(text, x, y, true);
            return 1;
        }
        ArrayList<Integer> cutIndex = new ArrayList<Integer>();
        int i = 1;
        while (i < text.length()) {
            if (text.charAt(i) == '.' || Character.isUpperCase(text.charAt(i)) && Character.isLowerCase(text.charAt(i - 1))) {
                cutIndex.add(i);
            }
            ++i;
        }
        cutIndex.add(new Integer(text.length()));
        int start = 0;
        int textX = x;
        int textY = y;
        int line = 1;
        int i2 = 0;
        while (i2 < cutIndex.size()) {
            int index = (Integer)cutIndex.get(i2);
            String subText = text.substring(start, index);
            int subtextWidth = gc.textExtent((String)subText).x;
            if (x != textX && textX + subtextWidth > x + textareaRect.width) {
                textX = x;
                textY += fm.getHeight();
                ++line;
            }
            gc.drawString(subText, textX, textY, true);
            textX += subtextWidth;
            start = index;
            ++i2;
        }
        return line;
    }

    private void drawObjectIdString(GC gc, String objectCountLabel, List<String> objectIDLabels, int x, int y, org.eclipse.swt.graphics.Rectangle textareaRect, int maxLines) {
        int lineHeight = gc.getFontMetrics().getHeight();
        if (objectIDLabels.size() == 1) {
            gc.drawString(objectIDLabels.get(0).toString(), x, y, true);
        } else if (maxLines == 1) {
            String objCount = OBJECTS_OMITTED + objectCountLabel;
            gc.drawString(objCount, x, y, true);
        } else if (maxLines > 1) {
            int textX = x;
            int textY = y;
            int line = 0;
            boolean drawLast = true;
            Iterator<String> it = objectIDLabels.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                if (it.hasNext()) {
                    id = String.valueOf(id) + ", ";
                }
                int w = gc.textExtent((String)id).x;
                if (x != textX && textX + w > x + textareaRect.width) {
                    textX = x;
                    textY += lineHeight;
                    if (++line == maxLines - 1) {
                        String s = OBJECTS_OMITTED + objectCountLabel;
                        gc.drawString(s, textX, textY, true);
                        drawLast = false;
                        break;
                    }
                }
                gc.drawString(id, textX, textY, true);
                textX += w;
            }
            if (drawLast) {
                assert (line < maxLines - 1);
                textX = x;
                ++line;
                gc.drawString(objectCountLabel, textX, textY += lineHeight, true);
            }
        }
    }

    public void drawDiagram(Display display, GC gc, org.eclipse.swt.graphics.Rectangle viewRange, org.eclipse.swt.graphics.Rectangle drawRange) {
        int yStartIndex;
        this.selectables = new SelectableItems();
        if (this.model == null || this.adjuster == null || viewRange == null || drawRange == null || gc == null) {
            return;
        }
        gc.setFont(new Font((Device)display, "", (int)this.adjuster.getFontSize(), 0));
        int xStartIndex = this.adjuster.getObjectIndexFromCursorPos(viewRange.x - this.adjuster.getObjectSpace());
        if (xStartIndex < 1) {
            xStartIndex = 1;
        } else if (xStartIndex > this.model.getMaxObjectIndex()) {
            xStartIndex = this.model.getMaxObjectIndex();
        }
        int xEndIndex = this.adjuster.getObjectIndexFromCursorPos(viewRange.x + viewRange.width);
        if (xEndIndex > this.model.getMaxObjectIndex()) {
            xEndIndex = this.model.getMaxObjectIndex();
        }
        if ((yStartIndex = this.adjuster.getSequenceIndexFromCursorPos(viewRange.y)) < 0) {
            yStartIndex = 0;
        } else if (yStartIndex >= this.model.getSequenceNum()) {
            yStartIndex = this.model.getSequenceNum();
        }
        int yEndIndex = this.adjuster.getSequenceIndexFromCursorPos(viewRange.y + viewRange.height);
        if (yEndIndex >= this.model.getSequenceNum()) {
            yEndIndex = this.model.getSequenceNum() - 1;
        }
        int xGap = drawRange.x - viewRange.x;
        int yGap = drawRange.y - viewRange.y;
        this.selectables.addItems(this.drawObjectLine(display, gc, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap));
        this.selectables.addItems(this.drawLoop(display, gc, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap));
        this.selectables.addItems(this.drawSequence(display, gc, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap, drawRange.width));
    }

    private List<SelectableElement> drawObjectLine(Display display, GC gc, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap) {
        LinkedList<SelectableElement> selectableObjects = new LinkedList<SelectableElement>();
        int i = startObjectIndex;
        while (i <= endObjectIndex) {
            SequenceObject object = this.model.getObject(i);
            int objectLineX = this.adjuster.getObjectLineXPos(i) + xGap;
            int sequenceStartY = this.adjuster.getYPosFromSequenceIndex(startSequenceIndex) + yGap;
            int sequenceEndY = this.adjuster.getYPosFromSequenceIndex(endSequenceIndex) + yGap;
            int sequenceConstructionY = this.adjuster.getYPosFromSequenceIndex(object.getMadeIndex()) + yGap;
            int sequenceLastUseY = this.adjuster.getYPosFromSequenceIndex(object.getLastUsedIndex()) + yGap;
            int madeIndex = object.getMadeIndex();
            int lastUsedIndex = object.getLastUsedIndex();
            gc.setForeground(display.getSystemColor(2));
            if (startSequenceIndex < madeIndex) {
                int endY = sequenceEndY;
                if (endSequenceIndex >= madeIndex) {
                    endY = sequenceConstructionY;
                }
                this.drawDottedLine(display, gc, objectLineX, sequenceStartY, objectLineX, endY);
            }
            if (startSequenceIndex < lastUsedIndex && endSequenceIndex > madeIndex) {
                int startY = sequenceStartY;
                if (startSequenceIndex < madeIndex) {
                    startY = sequenceConstructionY;
                }
                int endY = sequenceEndY;
                if (endSequenceIndex >= lastUsedIndex) {
                    endY = sequenceLastUseY;
                }
                gc.drawLine(objectLineX, startY, objectLineX, endY);
            }
            int calledWidth = this.adjuster.getCalledWidth();
            int calledStartX = objectLineX - calledWidth / 2;
            int j = object.getCalledNum() - 1;
            while (j >= 0) {
                Called called = object.getCalled(j);
                if (called.getStart() <= endSequenceIndex && called.getEnd() >= startSequenceIndex) {
                    int x = calledStartX + calledWidth * called.getLevel() / 2;
                    int y = this.adjuster.getYPosFromSequenceIndex(called.getStart()) + yGap;
                    int height = this.adjuster.getYPosFromSequenceIndex(called.getEnd()) + yGap - y;
                    this.setPenColor(display, gc, this.selectionModel.isSelectedCalled(called));
                    if (called.getCallSequence().getNode().isBehind()) {
                        gc.setBackground(display.getSystemColor(2));
                        gc.fillRectangle(x, y, calledWidth, height);
                        gc.setBackground(display.getSystemColor(1));
                    } else {
                        gc.fillRectangle(x, y, calledWidth, height);
                        gc.drawRectangle(x, y, calledWidth, height);
                    }
                    SelectableElement sElement = new SelectableElement(new Rectangle(x, y, calledWidth, height), called, 2);
                    selectableObjects.add(sElement);
                }
                --j;
            }
            ++i;
        }
        return selectableObjects;
    }

    private void setPen(Display display, GC gc, Sequence sequence) {
        if (sequence.getType() == 0) {
            this.setPenColor(display, gc, this.selectionModel.isSelectedSequence(sequence.getIndex()));
        } else {
            this.setPenColor(display, gc, this.selectionModel.isSelectedSequence(sequence.getPareSequence().getIndex()));
        }
        if (sequence.isIndirect()) {
            gc.setLineWidth(2);
            gc.setLineStyle(5);
        } else {
            gc.setLineWidth(1);
            gc.setLineStyle(1);
        }
    }

    private void resetPen(Display display, GC gc) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
    }

    private void setPenColor(Display display, GC gc, boolean isSelected) {
        if (isSelected) {
            gc.setForeground(display.getSystemColor(9));
        } else {
            gc.setForeground(display.getSystemColor(2));
        }
    }

    private List<SelectableElement> drawSequence(Display display, GC gc, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap, int windowWidth) {
        int objectWidth = this.adjuster.getObjectWidth();
        int objectSpace = this.adjuster.getObjectSpace();
        int sequenceSpace = this.adjuster.getSequenceSpace();
        int calledWidth = this.adjuster.getCalledWidth();
        int fineAdjustment = this.adjuster.getArrowPointSize();
        int lineHeight = gc.getFontMetrics().getHeight();
        LinkedList<SelectableElement> selectables = new LinkedList<SelectableElement>();
        int i = startSequenceIndex;
        while (i <= endSequenceIndex) {
            Sequence sequence = this.model.getSequence(i);
            int y = this.adjuster.getYPosFromSequenceIndex(i) + yGap;
            this.setPen(display, gc, sequence);
            if (sequence.getType() == 0) {
                String text = sequence.getCallLabel();
                int textWidth = gc.textExtent((String)text).x;
                if (sequence.getStart() != sequence.getEnd()) {
                    int labelPos;
                    int[] arrowhead;
                    int x2;
                    int x1 = this.adjuster.getObjectLineXPos(sequence.getStartIndex()) + xGap;
                    if (x1 > (x2 = this.adjuster.getObjectLineXPos(sequence.getEndIndex()) + xGap)) {
                        arrowhead = new int[]{x2 += (sequence.getEndLevel() + 1) * this.adjuster.getCalledWidth() / 2, y, x2 + fineAdjustment, y - fineAdjustment, x2 + fineAdjustment, y + fineAdjustment, x2, y};
                        labelPos = this.drawLineLabel(gc, x2, x1 += sequence.getStartLevel() * this.adjuster.getCalledWidth() / 2, y - fineAdjustment - lineHeight, text, textWidth, false, windowWidth);
                    } else {
                        arrowhead = new int[]{x2 += sequence.getEndLevel() * calledWidth / 2, y, x2 - fineAdjustment, y + fineAdjustment, x2 - fineAdjustment, y - fineAdjustment, x2, y};
                        labelPos = this.drawLineLabel(gc, x1 += sequence.getStartLevel() * calledWidth / 2, x2, y - fineAdjustment - lineHeight, text, textWidth, true, windowWidth);
                    }
                    gc.drawLine(x1, y, x2, y);
                    gc.setBackground(gc.getForeground());
                    gc.fillPolygon(arrowhead);
                    gc.setBackground(display.getSystemColor(1));
                    selectables.add(new SelectableElement(new Rectangle(x1, y - fineAdjustment, x2 - x1, fineAdjustment * 2), sequence, 1));
                    selectables.add(new SelectableElement(new Rectangle(labelPos, y - fineAdjustment - lineHeight, textWidth, lineHeight), sequence, 1));
                    if (sequence.isBranch()) {
                        int pareIndex = sequence.getPareSequence().getIndex();
                        int branchSpace = (pareIndex - i) * this.adjuster.getSequenceSpace();
                        int threeDivisionSpace = branchSpace / 3;
                        int rightSpace = (objectWidth + objectSpace) / 3;
                        gc.drawLine(x1, y, x1 + rightSpace, y + threeDivisionSpace);
                        gc.drawLine(x1 + rightSpace, y + threeDivisionSpace, x1 + rightSpace, y + threeDivisionSpace * 2);
                        gc.drawLine(x1 + rightSpace, y + threeDivisionSpace * 2, x1, y + branchSpace);
                    }
                } else {
                    int x = this.adjuster.getObjectLineXPos(sequence.getStartIndex()) + xGap;
                    gc.drawLine(x += sequence.getStartLevel() * calledWidth / 2, y - sequenceSpace / 3, x + fineAdjustment * calledWidth / 2, y - sequenceSpace / 3);
                    gc.drawLine(x + fineAdjustment * calledWidth / 2, y - sequenceSpace / 3, x + fineAdjustment * calledWidth / 2, y + fineAdjustment);
                    gc.drawLine(x + fineAdjustment * calledWidth / 2, y + fineAdjustment, x + calledWidth / 2, y + fineAdjustment);
                    gc.drawLine(x + calledWidth / 2 + fineAdjustment, y + fineAdjustment * 2, x + calledWidth / 2, y + fineAdjustment);
                    gc.drawLine(x + calledWidth / 2 + fineAdjustment, y, x + calledWidth / 2, y + fineAdjustment);
                    gc.drawString(text, x + fineAdjustment * 2, y - sequenceSpace / 3 - fineAdjustment - lineHeight, true);
                    selectables.add(new SelectableElement(new Rectangle(x, y - sequenceSpace / 3, 3 * calledWidth / 2, sequenceSpace / 3 + fineAdjustment), sequence, 1));
                    selectables.add(new SelectableElement(new Rectangle(x + fineAdjustment * 2, y - sequenceSpace / 3 - fineAdjustment - lineHeight, textWidth, lineHeight), sequence, 1));
                }
            } else if (sequence.getType() == 1 || sequence.getType() == 5) {
                if (sequence.getStart() != sequence.getEnd()) {
                    int x1 = this.adjuster.getObjectLineXPos(sequence.getStartIndex()) + xGap;
                    int x2 = this.adjuster.getObjectLineXPos(sequence.getEndIndex()) + xGap;
                    String label = sequence.getType() == 1 ? sequence.getNode().getReturnTypeName() : sequence.getNode().getExceptionName();
                    int width = gc.textExtent((String)label).x;
                    if (x1 > x2) {
                        this.drawDottedLine(display, gc, x1 += (sequence.getStartLevel() - 1) * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y);
                        gc.drawLine(x2 + fineAdjustment, y + fineAdjustment, x2, y);
                        gc.drawLine(x2 + fineAdjustment, y - fineAdjustment, x2, y);
                        this.drawLineLabel(gc, x2, x1, y - fineAdjustment - lineHeight, label, width, false, windowWidth);
                    } else {
                        this.drawDottedLine(display, gc, x1 += sequence.getStartLevel() * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y);
                        gc.drawLine(x2 - fineAdjustment, y + fineAdjustment, x2, y);
                        gc.drawLine(x2 - fineAdjustment, y - fineAdjustment, x2, y);
                        this.drawLineLabel(gc, x1, x2, y - fineAdjustment - lineHeight, label, width, true, windowWidth);
                    }
                }
            } else if (sequence.getType() == 3) {
                int x = this.adjuster.getObjectLineXPos(sequence.getStartIndex()) + xGap + sequence.getStartLevel() * calledWidth / 2;
                int interval = objectWidth + objectSpace;
                gc.setForeground(display.getSystemColor(2));
                gc.drawLine(x, y, x + interval / 4, y);
                gc.fillPolygon(new int[]{x + interval / 4, y, x + interval / 4 - fineAdjustment, y + fineAdjustment, x + interval / 4 - fineAdjustment, y - fineAdjustment, x, y});
                gc.drawRectangle(x + interval / 4, y - sequenceSpace / 10, interval / 2, (int)((double)sequenceSpace * 1.2));
                String text = sequence.getNode().getMethodName();
                int stringWidth = gc.textExtent((String)text).x;
                gc.drawString(text, x + interval / 4 + interval / 4 - stringWidth / 2, y + sequenceSpace / 2 - gc.getFontMetrics().getHeight() / 2);
            } else if (sequence.getType() == 4) {
                int interval = objectWidth + objectSpace;
                int x = this.adjuster.getObjectLineXPos(sequence.getStartIndex()) + xGap + sequence.getEndLevel() * calledWidth / 2;
                gc.setForeground(display.getSystemColor(2));
                gc.drawLine(x, y, x + interval / 4, y);
                gc.drawLine(x, y, x + fineAdjustment, y - fineAdjustment);
                gc.drawLine(x, y, x + fineAdjustment, y + fineAdjustment);
            }
            ++i;
        }
        this.resetPen(display, gc);
        return selectables;
    }

    private int drawLineLabel(GC gc, int left, int right, int y, String label, int labelWidth, boolean alignRight, int windowWidth) {
        int x;
        if (right - left < labelWidth) {
            x = left;
        } else {
            boolean canDrawRight;
            boolean canDrawLeft = left > 0;
            boolean bl = canDrawRight = right < windowWidth;
            if (alignRight) {
                if (canDrawRight) {
                    x = right - labelWidth - SequenceDiagramDrawer.MARGIN.right;
                } else {
                    x = windowWidth - labelWidth - SequenceDiagramDrawer.MARGIN.right;
                    if (x < left) {
                        x = left;
                    }
                }
            } else if (canDrawLeft) {
                x = left + SequenceDiagramDrawer.MARGIN.left;
            } else {
                x = SequenceDiagramDrawer.MARGIN.left;
                if (x > right) {
                    x = right;
                }
            }
        }
        gc.drawString(label, x, y);
        return x;
    }

    private void drawDottedLine(Display display, GC gc, int x1, int y1, int x2, int y2) {
        int style = gc.getLineStyle();
        gc.setLineStyle(2);
        gc.drawLine(x1, y1, x2, y2);
        gc.setLineStyle(style);
    }

    private List<SelectableElement> drawLoop(Display display, GC gc, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap) {
        LinkedList<SelectableElement> selectables = new LinkedList<SelectableElement>();
        int fineAdjustment = this.adjuster.getArrowPointSize();
        int fontHeight = gc.getFontMetrics().getHeight();
        int maxLoopDepth = this.model.getMaxLoopDepth();
        int objectSpace = this.adjuster.getObjectSpace();
        int i = this.model.getLoopNum() - 1;
        while (i >= 0) {
            int oIndex;
            SequenceObject object;
            SequenceLoop loop = this.model.getLoop(i);
            if (loop.getStart() <= endSequenceIndex && loop.getEnd() >= startSequenceIndex && (object = loop.getParentObject()) != null && (oIndex = object.getIndex()) >= startObjectIndex && oIndex <= endObjectIndex) {
                int x1 = this.adjuster.getXPosFromObjectIndex(oIndex) - objectSpace / 2 + xGap;
                int x2 = this.adjuster.getObjectLineXPos(oIndex) - this.adjuster.getCalledWidth() / 2 + xGap;
                x1 += loop.getDepth() * (x2 - x1) / (maxLoopDepth + 1);
                int y1 = this.adjuster.getYPosFromSequenceIndex(loop.getStart()) + yGap - fineAdjustment;
                int y2 = this.adjuster.getYPosFromSequenceIndex(loop.getEnd()) + yGap + fineAdjustment;
                LoopNode loopNode = loop.getNode();
                if (this.selectionModel.getSelectedLoops().contains(loop)) {
                    gc.setBackground(display.getSystemColor(13));
                    gc.fillRectangle(x1, y1, x2 - x1, y2 - y1);
                    gc.setBackground(display.getSystemColor(1));
                }
                if (loopNode instanceof SimpleLoopNode) {
                    gc.setForeground(display.getSystemColor(2));
                } else if (loopNode instanceof ObjectDifferenceLoopNode) {
                    gc.setForeground(display.getSystemColor(9));
                } else if (loopNode instanceof MethodMissingLoopNode) {
                    gc.setForeground(display.getSystemColor(3));
                } else {
                    gc.setForeground(display.getSystemColor(2));
                }
                gc.drawLine(x1, y1, x2, y1);
                gc.drawLine(x1, y1, x1, y2);
                gc.drawLine(x1, y2, x2, y2);
                int stringX = x1 + fineAdjustment / 2;
                int stringY = (y2 + y1 - fontHeight) / 2;
                if (!loopNode.isFold()) {
                    gc.drawString("1", stringX, stringY);
                } else if (loopNode.getLoopNums().size() > 1) {
                    gc.drawString(loopNode.getLoopNum(0) + "-" + loopNode.getLoopNum(loopNode.getLoopNums().size() - 1), stringX, stringY);
                } else {
                    gc.drawString("" + loopNode.getLoopNum(0), stringX, stringY);
                }
                SelectableElement element = new SelectableElement(new Rectangle(x1, y1, x2 - x1, y2 - y1), loop, 3);
                selectables.add(element);
            }
            --i;
        }
        return selectables;
    }

    public void drawSequenceOverview(Display display, GC gc, org.eclipse.swt.graphics.Rectangle drawView, org.eclipse.swt.graphics.Rectangle diagramView) {
        if (this.model == null) {
            return;
        }
        int xOffset = -drawView.x;
        int yOffset = -drawView.y;
        gc.setForeground(display.getSystemColor(2));
        int i = 0;
        while (i < this.model.getBlockNum()) {
            SequenceBlock block = this.model.getBlock(i);
            int start = block.getStartIndex();
            int end = block.getEndIndex();
            if (block.getSequenceList().size() != 0) {
                int xMin = Integer.MAX_VALUE;
                int xMax = Integer.MIN_VALUE;
                for (Sequence seq : block.getSequenceList().subList(0, block.getSequenceList().size() - 1)) {
                    if (seq.getType() == 2) continue;
                    xMin = Math.min(seq.getStartIndex(), xMin);
                    xMin = Math.min(seq.getEndIndex(), xMin);
                    xMax = Math.max(seq.getStartIndex(), xMax);
                    xMax = Math.max(seq.getEndIndex(), xMax);
                }
                gc.drawRectangle(xOffset + xMin * 3, yOffset + start * 2, (xMax - xMin + 1) * 3, (end - start + 1) * 2);
            }
            ++i;
        }
        int startY = drawView.y / 2;
        int endY = 1 + (drawView.y + drawView.height) / 2;
        if (endY > this.model.getSequenceNum()) {
            endY = this.model.getSequenceNum();
        }
        int i2 = startY;
        while (i2 < endY) {
            int end;
            int start;
            boolean isSelected;
            Sequence sequence = this.model.getSequence(i2);
            boolean bl = isSelected = this.selectionModel.isSelectedSequence(i2) || this.selectionModel.isSelectedSequence(sequence.getPareSequence().getIndex());
            if (sequence.getType() != 2 && (start = sequence.getStartIndex()) != (end = sequence.getEndIndex())) {
                this.setPenColor(display, gc, isSelected);
                gc.drawLine(xOffset + start * 3, yOffset + (i2 + 1) * 2, xOffset + end * 3, yOffset + (i2 + 1) * 2);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.model.getLoopNum()) {
            SequenceLoop loop = this.model.getLoop(i2);
            int start = loop.getStart();
            int end = loop.getEnd();
            SequenceObject object = loop.getParentObject();
            int objectIndex = object != null ? object.getIndex() - 1 : 0;
            LoopNode node = loop.getNode();
            if (node instanceof ObjectDifferenceLoopNode) {
                gc.setForeground(display.getSystemColor(9));
            } else if (node instanceof MethodMissingLoopNode) {
                gc.setForeground(display.getSystemColor(3));
            } else {
                gc.setForeground(display.getSystemColor(2));
            }
            gc.drawLine(xOffset + objectIndex * 3 + loop.getDepth() - 1, yOffset + start * 2, xOffset + objectIndex * 3 + loop.getDepth() - 1, yOffset + end * 2);
            ++i2;
        }
        if (this.adjuster != null) {
            gc.setForeground(display.getSystemColor(3));
            org.eclipse.swt.graphics.Rectangle overviewRange = this.translateDiagramCoordinatesToMap(diagramView);
            gc.drawRectangle(xOffset + overviewRange.x, yOffset + overviewRange.y, overviewRange.width, overviewRange.height);
        }
    }

    private org.eclipse.swt.graphics.Rectangle translateDiagramCoordinatesToMap(org.eclipse.swt.graphics.Rectangle sdcCoordinates) {
        int x = 3 * sdcCoordinates.x / (this.adjuster.getObjectSpace() + this.adjuster.getObjectWidth());
        int y = 2 * sdcCoordinates.y / this.adjuster.getSequenceSpace();
        int width = 3 * sdcCoordinates.width / (this.adjuster.getObjectSpace() + this.adjuster.getObjectWidth());
        int height = 2 * sdcCoordinates.height / this.adjuster.getSequenceSpace();
        return new org.eclipse.swt.graphics.Rectangle(x, y, width, height);
    }

    public Point getPositionFromOverview(int x, int y) {
        return new Point(x / 3 * (this.adjuster.getObjectSpace() + this.adjuster.getObjectWidth()), y / 2 * this.adjuster.getSequenceSpace());
    }

    @Override
    public void changing(SequenceDiagramModel model) {
        this.selectionModel = new SequenceSelectionModel(model);
        this.selectionModel.addSelectionListener(this.updater);
    }

    @Override
    public void changed(SequenceDiagramModel model) {
    }

    public void selectElement(int x, int y, int button) {
        ISequenceElement e = this.selectables.findElement(x, y);
        if (e != null) {
            this.selectionModel.selectElement(e);
        } else {
            this.selectionModel.clearAllSelection();
        }
    }

    public void selectSequenceByIndex(int seqIndex) {
        this.selectionModel.selectElement(this.model.getSequence(seqIndex));
    }

    public SequenceObject getSelectedObject() {
        int[] selected = this.selectionModel.getSelectedObjects();
        if (selected.length == 1) {
            return this.model.getObject(selected[0]);
        }
        return null;
    }

    public void processDoubleClick(int x, int y, int button) {
        if (button == 1) {
            ISequenceElement e = this.selectables.findElement(x, y);
            if (e instanceof SequenceLoop) {
                SequenceLoop loop = (SequenceLoop)e;
                loop.getNode().setFold(!loop.getNode().isFold());
            } else if (e instanceof Called) {
                Called called = (Called)e;
                called.getCallSequence().getNode().setBehind(!called.getCallSequence().getNode().isBehind());
                called.getCallSequence().getNode().getCallTree().fireDataChange();
            } else if (e instanceof SequenceBlock) {
                SequenceBlock block = (SequenceBlock)e;
                block.getBlockNode().setBehind(!block.getBlockNode().isBehind());
                block.getBlockNode().getCallTree().fireDataChange();
            }
        }
    }

    public void selectObject(int cursorX, int cursorY, int objectAreaHeight, int diagramY, int diagramHeight, boolean shift, boolean ctrl, boolean rightClick) {
        int index2;
        int yStart = this.adjuster.getMargin().top;
        int yEnd = Math.max(this.adjuster.getMargin().top + this.adjuster.getObjectHeight(), objectAreaHeight - (this.adjuster.getMargin().top + this.adjuster.getMargin().bottom));
        if (yStart > cursorY || cursorY > yEnd) {
            return;
        }
        int index1 = this.adjuster.getObjectIndexFromCursorPos(cursorX);
        if (index1 == (index2 = this.adjuster.getObjectIndexFromCursorPos(cursorX + this.adjuster.getObjectSpace())) && index1 > 0 && this.model.getMaxObjectIndex() >= index1) {
            SequenceObject selectedObject = this.model.getObject(index1);
            if (rightClick && this.selectionModel.isSelectedObject(new Integer(index1))) {
                return;
            }
            int visibleSequenceIndexStart = diagramY / this.adjuster.getSequenceSpace() - 1;
            if (selectedObject.isVisible(visibleSequenceIndexStart)) {
                this.selectionModel.selectObject(index1, shift, ctrl);
            } else {
                this.selectionModel.clearAllSelection();
            }
        } else if (!(shift || ctrl || rightClick)) {
            this.selectionModel.clearAllSelection();
        }
    }

    public void selectObjectByIndex(int objIndex) {
        this.selectionModel.selectObject(objIndex, false, false);
    }

    public void createObjectHideFilter() {
        this.createObjectFilter(1);
    }

    public void createObjectDeleteFilter() {
        this.createObjectFilter(2);
    }

    private void createObjectFilter(int state) {
        int[] selected = this.selectionModel.getSelectedObjects();
        int i = 0;
        while (i < selected.length) {
            this.createObjectFilter(state, this.model.getObject(selected[i]));
            ++i;
        }
        this.model.renew();
    }

    private void createObjectFilter(int state, SequenceObject object) {
        if (object.isUnified()) {
            for (SequenceObject obj : object.getUnifiedObjects()) {
                if (!obj.isStaticObject()) continue;
                this.createObjectFilter(state, obj);
            }
            List<String> labels = object.getObjectIDLabels();
            this.model.getFilters().insertHeadObjectFilter(FilterFactory.createObjectFilter(state, labels));
        } else if (object.isStaticObject()) {
            this.model.getFilters().insertHeadObjectFilter(FilterFactory.createStaticObjectFilter(state, object.getNameSpace(), object.getClassName()));
        } else {
            List<String> labels = object.getObjectIDLabels();
            this.model.getFilters().insertHeadObjectFilter(FilterFactory.createObjectFilter(state, labels));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SequenceDiagramModel extractSelectedModel() {
        Set<Integer> selectedSequence = this.selectionModel.getSelectedSequenceIndex();
        Set<Called> selectedCalled = this.selectionModel.getSelectedCalled();
        BlockNode block = null;
        if (selectedSequence.size() == 1) {
            Sequence sequence = this.model.getSequence(selectedSequence.iterator().next());
            CallNode node = sequence.getNode();
            Node parent = node.getParent();
            CallTreeIterator it = parent == null ? node.getCallTree().getTopNodeList().nodeIterator() : parent.nodeIterator();
            while (it.hasNext() && it.next() != node) {
            }
            block = new BlockNode(node.getCallTree());
            if (node instanceof CallNode) {
                block.setBlockName(node.getMethodName());
            }
            it.set(block);
            block.addChild(node);
        } else {
            if (selectedCalled.size() != 1) return null;
            Called called = selectedCalled.iterator().next();
            CallNode node = called.getCallSequence().getNode();
            if (!node.hasChildren()) return null;
            CallTreeIterator it = node.nodeIterator();
            block = new BlockNode(node.getCallTree());
            Node first = it.nextNode();
            it.set(block);
            block.addChild(first);
            if (first instanceof CallNode) {
                block.setBlockName(((CallNode)first).getMethodName());
            }
            while (it.hasNext()) {
                block.addChild(it.nextNode());
            }
        }
        SequenceDiagramModel newModel = new SequenceDiagramModel(this.model.getLog(), block.extractSubtree(), this.model.getFilters().copy());
        this.model.renew();
        return newModel;
    }

    public int getObjectPosition(int objIndex) {
        return this.adjuster.getXPosFromObjectIndex(objIndex);
    }

    public int getSequenceY(int seqIndex) {
        return this.adjuster.getYPosFromSequenceIndex(seqIndex);
    }
}

