/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.log.AmidaLog;
import amida.util.DataChangeListener;
import amida.viewer.ModelChangeListener;
import amida.viewer.ObjectManager;
import amida.viewer.elements.RecursiveCallBlock;
import amida.viewer.elements.SeparateBlock;
import amida.viewer.elements.Sequence;
import amida.viewer.elements.SequenceBlock;
import amida.viewer.elements.SequenceLoop;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.FilterSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class SequenceDiagramModel
implements DataChangeListener {
    private AmidaLog log;
    private List<ModelChangeListener> modelChangeListeners = new LinkedList<ModelChangeListener>();
    private CallTree callTree;
    private Comparator<SequenceObject> sorter;
    private List<SequenceObject> objectList;
    private List<Sequence> sequenceList;
    private List<SequenceLoop> loopList;
    private List<SequenceBlock> blockList;
    private int maxLoopDepth = 0;
    private ObjectManager objectManager = null;
    private FilterSet filters = null;
    private int sequenceCount = 0;

    public SequenceDiagramModel(AmidaLog log, CallTree tree, FilterSet filters) {
        assert (tree != null);
        this.log = log;
        this.callTree = tree;
        this.filters = filters;
        this.callTree.addDataChangeListener(this);
        this.renew();
    }

    public void dispose() {
        this.callTree.removeDataChangeListener(this);
    }

    public void setSorter(Comparator<SequenceObject> sorter) {
        this.sorter = sorter;
        this.renew();
    }

    public AmidaLog getLog() {
        return this.log;
    }

    public void renew() {
        if (this.callTree == null || this.callTree.getTopNodeList() == null) {
            return;
        }
        this.fireModelChanging();
        ModelData modelData = new ModelData();
        NodeContextStack context = new NodeContextStack();
        context.pushCallContext(null, 0, null);
        this.sequenceCount = 0;
        NodeList nodes = this.callTree.getTopNodeList();
        this.objectManager = new ObjectManager(nodes, this.filters);
        this.makeModel(nodes.iterator(), modelData, context);
        if (this.sorter != null) {
            modelData.sortObjects(this.sorter);
        }
        this.reflectNewData(modelData);
        this.fireModelChanged();
    }

    public void makeModel(Iterator<Node> nodes, ModelData modelData, NodeContextStack context) {
        Stack<Iterator<Node>> visitStack = new Stack<Iterator<Node>>();
        Stack<Node> visiting = new Stack<Node>();
        visitStack.push(nodes);
        while (!visitStack.empty()) {
            Iterator it = (Iterator)visitStack.peek();
            boolean visitNestedNodes = false;
            while (it.hasNext()) {
                Node node = (Node)it.next();
                boolean proceed = this.visitPre(node, modelData, context);
                if (!proceed) continue;
                if (node.hasChildren()) {
                    visiting.push(node);
                    visitStack.push(node.getChildren().iterator());
                    visitNestedNodes = true;
                    break;
                }
                this.visitPost(node, modelData, context);
            }
            if (visitNestedNodes) continue;
            if (!visiting.empty() && visiting.peek() != null) {
                this.visitPost((Node)visiting.pop(), modelData, context);
            }
            visitStack.pop();
        }
    }

    private boolean visitPre(Node node, ModelData modelData, NodeContextStack context) {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            return this.visitPreCall(call, modelData, context);
        }
        if (node instanceof LoopNode) {
            LoopNode loop = (LoopNode)node;
            return this.visitPreLoop(loop, modelData, context);
        }
        if (node instanceof BlockNode) {
            BlockNode block = (BlockNode)node;
            return this.visitPreBlock(block, modelData, context);
        }
        assert (false) : "Unknown Node Type";
        return false;
    }

    private void visitPost(Node node, ModelData modelData, NodeContextStack context) {
        if (node instanceof CallNode) {
            this.visitPostCall((CallNode)node, modelData, context);
        } else if (node instanceof LoopNode) {
            this.visitPostLoop((LoopNode)node, modelData, context);
        } else if (node instanceof BlockNode) {
            this.visitPostBlock((BlockNode)node, modelData, context);
        } else assert (false) : "Unknown Node Type";
    }

    private boolean visitPreCall(CallNode call, ModelData modelData, NodeContextStack context) {
        SequenceObject object = this.objectManager.getObject(call);
        if (object.isDeleted()) {
            return false;
        }
        Sequence callSequence = null;
        callSequence = call.isRecursive() && !call.hasChildren() ? new Sequence(call, context.getCaller(), object, 3, this.sequenceCount) : new Sequence(call, context.getCaller(), object, 0, this.sequenceCount);
        int filtered = this.filters.applyMethodFilters(callSequence);
        if (filtered == 3) {
            return false;
        }
        context.setCallSequence(callSequence);
        context.setFilteringResult(filtered);
        if (object.isHidden() || filtered == 2) {
            Stack<Sequence> callstack = context.getIndirectCallStack();
            callstack.push(callSequence);
            context.pushCallContext(context.getCaller(), context.getBlockDepth(), callstack);
            return true;
        }
        if (object.getIndex() <= 0) {
            object.setAppearanceIndex(modelData.tmpObjectList.size() + 1);
            modelData.tmpObjectList.add(object);
        }
        ++this.sequenceCount;
        modelData.tmpSequenceList.add(callSequence);
        if (context.getCaller() != null) {
            context.getCaller().addCallSequence(callSequence);
        }
        if (!call.isRecursive() || call.hasChildren()) {
            object.call(callSequence, modelData.tmpSequenceList.size() - 1);
        }
        if (call.isBranch()) {
            callSequence.setBranch(true);
        }
        if (context.isIndirectCall()) {
            Stack<Sequence> callstack = context.getIndirectCallStack();
            ArrayList<Sequence> clone = new ArrayList<Sequence>(callstack.size());
            clone.addAll(callstack);
            callSequence.setIndirectSequence(clone);
        }
        if (!object.containsStaticObject() && object.getMadeIndex() == 0) {
            object.make(modelData.tmpSequenceList.size() - 1);
        }
        int nextBlockDepth = context.getBlockDepth();
        if (call.isRecursive() && call.hasChildren()) {
            ++nextBlockDepth;
        }
        if (filtered == 0) {
            context.pushCallContext(object, nextBlockDepth, null);
            return true;
        }
        return false;
    }

    private void visitPostCall(CallNode call, ModelData modelData, NodeContextStack context) {
        context.popCallContext();
        SequenceObject object = this.objectManager.getObject(call);
        if (object.isHidden() || context.getFilteringResult() == 2) {
            context.getIndirectCallStack().pop();
            return;
        }
        object.used(this.sequenceCount);
        Sequence returnSequence = null;
        returnSequence = call.getExitMode() == 2 ? (!call.isRecursive() || call.hasChildren() ? new Sequence(call, object, context.getCaller(), 5, this.sequenceCount++) : new Sequence(call, object, context.getCaller(), 6, this.sequenceCount++)) : (call.getReturnTypeName().equals("void") || !call.isEnded() ? new Sequence(call, object, context.getCaller(), 2, this.sequenceCount++) : (call.isRecursive() && !call.hasChildren() ? new Sequence(call, object, context.getCaller(), 4, this.sequenceCount++) : new Sequence(call, object, context.getCaller(), 1, this.sequenceCount++)));
        modelData.tmpSequenceList.add(returnSequence);
        if (context.getCaller() != null) {
            context.getCaller().addCallSequence(returnSequence);
        }
        Sequence callSequence = context.getCallSequence();
        callSequence.setPareSequence(returnSequence);
        returnSequence.setPareSequence(callSequence);
        if (!call.isRecursive() || call.hasChildren()) {
            object.ret(returnSequence, modelData.tmpSequenceList.size() - 1);
        }
        if (call.isRecursive() && call.hasChildren()) {
            RecursiveCallBlock recursiveBlock = new RecursiveCallBlock(context.getBlockDepth(), context.getCaller());
            recursiveBlock.setStartIndex(callSequence.getIndex());
            recursiveBlock.setEndIndex(returnSequence.getIndex());
            recursiveBlock.setSequenceList(new ArrayList<Sequence>(modelData.tmpSequenceList.subList(callSequence.getIndex(), returnSequence.getIndex() + 1)));
            modelData.tmpBlockList.add(recursiveBlock);
        }
    }

    private boolean visitPreLoop(LoopNode loop, ModelData modelData, NodeContextStack context) {
        context.setLoopStart(modelData.tmpSequenceList.size());
        context.pushLoopContext(context.getCaller(), context.getBlockDepth(), context.getIndirectCallStack());
        return true;
    }

    private void visitPostLoop(LoopNode loop, ModelData modelData, NodeContextStack context) {
        int loopEnd = modelData.tmpSequenceList.size();
        context.popLoopContext();
        if (context.getLoopStart() != loopEnd) {
            Iterator stackEntry = context.getLoopStack().iterator();
            int count = 1;
            while (stackEntry.hasNext()) {
                if (context.getCaller() != stackEntry.next()) continue;
                ++count;
            }
            if (count > modelData.tmpMaxLoopDepth) {
                modelData.tmpMaxLoopDepth = count;
            }
            modelData.tmpLoopList.add(new SequenceLoop(loop, context.getLoopStart(), loopEnd - 1, context.getCaller(), count));
        }
    }

    private boolean visitPreBlock(BlockNode block, ModelData modelData, NodeContextStack context) {
        if (block.hasChildren()) {
            context.setBlockStart(this.sequenceCount);
            context.pushBlockContext(context.getCaller(), 1 + context.getBlockDepth(), context.getIndirectCallStack());
            return true;
        }
        SeparateBlock separateBlock = new SeparateBlock(block, context.getBlockDepth(), context.getCaller());
        separateBlock.setStartIndex(this.sequenceCount);
        separateBlock.setEndIndex(this.sequenceCount);
        separateBlock.setSequenceList(new ArrayList<Sequence>());
        modelData.tmpBlockList.add(separateBlock);
        Sequence one = new Sequence(null, context.getCaller(), context.getCaller(), 2, this.sequenceCount++);
        Sequence two = new Sequence(null, context.getCaller(), context.getCaller(), 2, this.sequenceCount++);
        one.setPareSequence(two);
        modelData.tmpSequenceList.add(one);
        modelData.tmpSequenceList.add(two);
        return false;
    }

    private void visitPostBlock(BlockNode block, ModelData modelData, NodeContextStack context) {
        context.popBlockContext();
        int end = this.sequenceCount - 1;
        if (end - context.getLoopStart() > 0) {
            SeparateBlock separateBlock = new SeparateBlock(block, 1 + context.getBlockDepth(), context.getCaller());
            separateBlock.setStartIndex(context.getLoopStart());
            separateBlock.setEndIndex(end);
            separateBlock.setSequenceList(new ArrayList<Sequence>(modelData.tmpSequenceList.subList(context.getLoopStart(), end)));
            modelData.tmpBlockList.add(separateBlock);
        }
    }

    public synchronized void reflectNewData(ModelData modelData) {
        this.loopList = modelData.tmpLoopList;
        this.objectList = modelData.tmpObjectList;
        this.sequenceList = modelData.tmpSequenceList;
        this.blockList = modelData.tmpBlockList;
        this.maxLoopDepth = modelData.tmpMaxLoopDepth;
    }

    public synchronized Sequence getSequence(int i) {
        return this.sequenceList.get(i);
    }

    public synchronized int getSequenceNum() {
        return this.sequenceList.size();
    }

    public synchronized List<SequenceObject> getObjectList() {
        return Collections.unmodifiableList(this.objectList);
    }

    public synchronized SequenceObject getObject(int i) {
        assert (i > 0) : "Index is 1..getObjectNum() :" + Integer.toString(i);
        return this.objectList.get(i - 1);
    }

    public synchronized int getMaxObjectIndex() {
        return this.objectList.size();
    }

    public synchronized SequenceLoop getLoop(int i) {
        return this.loopList.get(i);
    }

    public synchronized int getLoopNum() {
        return this.loopList.size();
    }

    public synchronized SequenceBlock getBlock(int i) {
        return this.blockList.get(i);
    }

    public synchronized int getBlockNum() {
        return this.blockList.size();
    }

    public synchronized int getMaxLoopDepth() {
        return this.maxLoopDepth;
    }

    @Override
    public void dataChanged() {
        this.renew();
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    private void fireModelChanging() {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.changing(this);
        }
    }

    private void fireModelChanged() {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.changed(this);
        }
    }

    public CallTree getCallTree() {
        return this.callTree;
    }

    public FilterSet getFilters() {
        return this.filters;
    }

    public String getFileName() {
        return this.log.getFileName();
    }

    private class ModelData {
        private List<SequenceObject> tmpObjectList;
        private List<Sequence> tmpSequenceList;
        private List<SequenceLoop> tmpLoopList = new ArrayList<SequenceLoop>();
        private List<SequenceBlock> tmpBlockList;
        private int tmpMaxLoopDepth = 0;

        public ModelData() {
            this.tmpObjectList = new ArrayList<SequenceObject>();
            this.tmpSequenceList = new ArrayList<Sequence>();
            this.tmpBlockList = new ArrayList<SequenceBlock>();
        }

        public void sortObjects(Comparator<SequenceObject> sorter) {
            Collections.sort(this.tmpObjectList, sorter);
            ListIterator<SequenceObject> it = this.tmpObjectList.listIterator();
            while (it.hasNext()) {
                SequenceObject obj = it.next();
                obj.setIndex(it.nextIndex());
            }
        }
    }

    private class NodeContext {
        private static final int CONTEXT_CALL = 1;
        private static final int CONTEXT_LOOP = 2;
        private static final int CONTEXT_BLOCK = 3;
        int contextType;
        SequenceObject callParent;
        int blockDepth;
        Stack<Sequence> passThorughParent;
        Sequence callSequence;
        int filtered;
        int loopStart = 0;

        public NodeContext(int type, SequenceObject caller, int blockDepth, Stack<Sequence> indirectCallstack) {
            this.contextType = type;
            this.callParent = caller;
            this.blockDepth = blockDepth;
            this.passThorughParent = indirectCallstack;
        }
    }

    private class NodeContextStack {
        Stack<NodeContext> contextStack = new Stack();
        Stack<SequenceObject> loopStack = new Stack();

        public void pushCallContext(SequenceObject caller, int blockDepth, Stack<Sequence> indirectCall) {
            this.contextStack.push(new NodeContext(1, caller, blockDepth, indirectCall));
        }

        public void pushLoopContext(SequenceObject caller, int blockDepth, Stack<Sequence> indirectCall) {
            this.loopStack.push(this.getCaller());
            this.contextStack.push(new NodeContext(2, caller, blockDepth, indirectCall));
        }

        private int getContextType() {
            return this.contextStack.peek().contextType;
        }

        public void popCallContext() {
            assert (this.getContextType() == 1);
            this.contextStack.pop();
        }

        public void popBlockContext() {
            assert (this.getContextType() == 3);
            this.contextStack.pop();
        }

        public void popLoopContext() {
            assert (this.getContextType() == 2);
            this.loopStack.pop();
            this.contextStack.pop();
        }

        public void pushBlockContext(SequenceObject caller, int blockDepth, Stack<Sequence> indirectCall) {
            this.contextStack.push(new NodeContext(3, caller, blockDepth, indirectCall));
        }

        public boolean isIndirectCall() {
            Stack<Sequence> stack = this.contextStack.peek().passThorughParent;
            return stack != null && stack.size() > 0;
        }

        public Stack<Sequence> getIndirectCallStack() {
            Stack<Sequence> stack = this.contextStack.peek().passThorughParent;
            if (stack == null) {
                this.contextStack.peek().passThorughParent = stack = new Stack();
            }
            return stack;
        }

        public SequenceObject getCaller() {
            return this.contextStack.peek().callParent;
        }

        public int getBlockDepth() {
            return this.contextStack.peek().blockDepth;
        }

        public void setLoopStart(int start) {
            this.contextStack.peek().loopStart = start;
        }

        public int getLoopStart() {
            return this.contextStack.peek().loopStart;
        }

        public void setBlockStart(int start) {
            this.contextStack.peek().loopStart = start;
        }

        public int getBlockStart() {
            return this.contextStack.peek().loopStart;
        }

        public Stack<SequenceObject> getLoopStack() {
            return this.loopStack;
        }

        public void setCallSequence(Sequence call) {
            this.contextStack.peek().callSequence = call;
        }

        public Sequence getCallSequence() {
            return this.contextStack.peek().callSequence;
        }

        public void setFilteringResult(int filtered) {
            this.contextStack.peek().filtered = filtered;
        }

        public int getFilteringResult() {
            return this.contextStack.peek().filtered;
        }
    }
}

