/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.calltree.CallTreeGroup;
import amida.calltree.DominanceTree;
import amida.log.AmidaLog;
import amida.log.LogFileName;
import amida.log.TextLogFile;
import amida.logcompactor.CompactorThread;
import amida.logcompactor.LoopCompactorThread;
import amida.logcompactor.RecursiveCallCompactorThread;
import amida.logcompactor.foldrule.MethodMissingLoopRule;
import amida.logcompactor.foldrule.NodeTreeComparator;
import amida.logcompactor.foldrule.ObjectDifferenceLoopRule;
import amida.logcompactor.foldrule.SimpleLoopRule;
import amida.util.ProgressListener;
import amida.viewer.IAmidaCommand;
import amida.viewer.ICompactionCommand;
import amida.viewer.ModelChangeListener;
import amida.viewer.OverviewCanvasMouseHandler;
import amida.viewer.SearchDialog;
import amida.viewer.SearchListener;
import amida.viewer.SequenceDiagramDrawer;
import amida.viewer.SequenceDiagramModel;
import amida.viewer.SequenceObjectSorter;
import amida.viewer.ViewUpdater;
import amida.viewer.elements.Sequence;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.DominanceFilter;
import amida.viewer.filter.DominatorUnificationFilter;
import amida.viewer.filter.FilterChangeListener;
import amida.viewer.filter.FilterDialog;
import amida.viewer.filter.FilterManager;
import amida.viewer.filter.FilterSet;
import amida.viewer.filter.ObjectFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Slider;

public class SequenceDiagramTabView {
    private static final String KEY_DIAGRAM_VIEW = "AMIDA_SEQUENCE_DIAGRAM_VIEW";
    private static final String LABEL_STATUS_OK = "Open a log file from [File]-[Open a log file].";
    private static final String[] LIBRARY_FILTER = new String[]{"java.*", "javax.*", "sun.*"};
    private Composite parent;
    private SearchDialog searchDialog;
    private CTabFolder tabFolder;
    private CTabItem defaultTab;
    private ProgressBar progress;
    private FilterManager filterManager;
    private Label statusLabel;
    private TextSearch search;
    private boolean useDominanceFilter;

    public SequenceDiagramTabView(Composite parent) {
        this.parent = parent;
        this.useDominanceFilter = false;
        parent.setLayout((Layout)new GridLayout(1, false));
        this.filterManager = new FilterManager();
        this.setupDefaultGlobalFilters();
        this.constructTabs(parent);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite statusbar = new Composite(parent, 0);
        statusbar.setLayoutData((Object)new GridData(4, 4, true, false));
        statusbar.setLayout((Layout)new GridLayout(2, false));
        this.statusLabel = new Label(statusbar, 0);
        this.statusLabel.setText(LABEL_STATUS_OK);
        this.statusLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.progress = new ProgressBar(statusbar, 0);
        this.progress.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progress.setVisible(false);
        this.search = new TextSearch();
        this.searchDialog = new SearchDialog(parent.getShell());
        this.searchDialog.setSearchListener(this.search);
        this.tabFolder.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000C) {
                    SequenceDiagramTabView.this.searchDialog.search((e.stateMask & 0x20000) == 0);
                }
            }
        });
    }

    public void setUseDominanceFilter(boolean use) {
        this.useDominanceFilter = use;
    }

    public boolean isUseDominanceFilter() {
        return this.useDominanceFilter;
    }

    private void updateAllTabs() {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem tab = this.tabFolder.getItem(i);
            SequenceDiagramModel model = ((SequenceDiagramView)tab.getData(KEY_DIAGRAM_VIEW)).getModel();
            if (model != null) {
                model.renew();
            }
            ++i;
        }
        this.tabFolder.redraw();
    }

    private void constructTabs(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 64);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceDiagramTabView.this.updateStatusLabel();
            }
        });
        this.defaultTab = this.createTab(this.tabFolder, "(Default)", null);
    }

    private CTabItem createTab(CTabFolder folder, final String caption, final SequenceDiagramModel model) {
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText(caption);
        SashForm overviewSplitter = new SashForm((Composite)folder, 256);
        tab.setControl((Control)overviewSplitter);
        SashForm objectSplitter = new SashForm((Composite)overviewSplitter, 512);
        final Composite objectComposite = new Composite((Composite)objectSplitter, 262144);
        objectComposite.setBackground(this.parent.getDisplay().getSystemColor(25));
        Composite overviewScrollCanvas = new Composite((Composite)overviewSplitter, 0);
        overviewScrollCanvas.setLayout((Layout)new GridLayout(2, false));
        final Composite overviewComposite = new Composite(overviewScrollCanvas, 262144);
        overviewComposite.setBackground(this.parent.getDisplay().getSystemColor(25));
        overviewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Slider vOverviewSlider = new Slider(overviewScrollCanvas, 512);
        vOverviewSlider.setLayoutData((Object)new GridData(4, 4, false, true));
        final Slider hOverviewSlider = new Slider(overviewScrollCanvas, 256);
        hOverviewSlider.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite diagramScrollCanvas = new Composite((Composite)objectSplitter, 0);
        diagramScrollCanvas.setLayout((Layout)new GridLayout(2, false));
        final Composite diagramComposite = new Composite(diagramScrollCanvas, 262144);
        diagramComposite.setBackground(this.parent.getDisplay().getSystemColor(25));
        diagramComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Slider vDiagramSlider = new Slider(diagramScrollCanvas, 512);
        vDiagramSlider.setLayoutData((Object)new GridData(4, 4, false, true));
        final Slider hDiagramSlider = new Slider(diagramScrollCanvas, 256);
        hDiagramSlider.setLayoutData((Object)new GridData(4, 4, true, false));
        final ViewUpdater updater = new ViewUpdater(new Composite[]{diagramComposite, objectComposite, overviewComposite});
        final SequenceDiagramDrawer drawer = new SequenceDiagramDrawer(model, updater);
        SelectionAdapter scrollUpdater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                updater.fireRedraw();
            }
        };
        hDiagramSlider.addSelectionListener((SelectionListener)scrollUpdater);
        vDiagramSlider.addSelectionListener((SelectionListener)scrollUpdater);
        hOverviewSlider.addSelectionListener((SelectionListener)scrollUpdater);
        vOverviewSlider.addSelectionListener((SelectionListener)scrollUpdater);
        diagramComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = diagramComposite.getSize().x;
                int h = diagramComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle region = new Rectangle(0, 0, w, h);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), vDiagramSlider.getSelection(), w, h);
                drawer.drawDiagram(e.display, bufferedGC, view, region);
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        objectComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = objectComposite.getSize().x;
                int h = objectComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), 0, w, h);
                drawer.drawTopObject(e.display, bufferedGC, view, vDiagramSlider.getSelection());
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        overviewComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = overviewComposite.getSize().x;
                int h = overviewComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle overviewView = new Rectangle(hOverviewSlider.getSelection(), vOverviewSlider.getSelection(), w, h);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), vDiagramSlider.getSelection(), diagramComposite.getSize().x, diagramComposite.getSize().y);
                drawer.drawSequenceOverview(e.display, bufferedGC, overviewView, view);
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        OverviewCanvasMouseHandler handler = new OverviewCanvasMouseHandler(hDiagramSlider, vDiagramSlider, overviewComposite, hOverviewSlider, vOverviewSlider, drawer, updater);
        overviewComposite.addMouseListener((MouseListener)handler);
        overviewComposite.addMouseMoveListener((MouseMoveListener)handler);
        Point size = drawer.computeOverviewSize();
        hOverviewSlider.setMaximum(size.x);
        vOverviewSlider.setMaximum(size.y);
        Point diagramSize = drawer.computeDiagramSize();
        hDiagramSlider.setMaximum(diagramSize.x);
        vDiagramSlider.setMaximum(diagramSize.y);
        tab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (model != null) {
                    SequenceDiagramTabView.this.filterManager.disposeFilter(model.getFilters());
                    SequenceDiagramTabView.this.updateStatusLabel();
                    model.dispose();
                }
            }
        });
        tab.setData(KEY_DIAGRAM_VIEW, (Object)new SequenceDiagramView(model, drawer, diagramComposite, hDiagramSlider, vDiagramSlider));
        overviewSplitter.setWeights(new int[]{9, 1});
        objectSplitter.setWeights(new int[]{1, 6});
        if (model != null) {
            Menu popup = new Menu((Decorations)this.parent.getShell(), 0);
            diagramComposite.setMenu(popup);
            MenuItem mnuExtractDiagram = new MenuItem(popup, 8);
            mnuExtractDiagram.setText("Extract a diagram");
            mnuExtractDiagram.addSelectionListener((SelectionListener)new SelectionAdapter(){

                private String makeCaption(int idx) {
                    return String.valueOf(caption) + "-" + Integer.toString(idx);
                }

                public void widgetSelected(SelectionEvent e) {
                    int idx = 1;
                    while (true) {
                        boolean found = false;
                        int i = 0;
                        while (i < SequenceDiagramTabView.this.tabFolder.getItemCount()) {
                            CTabItem t = SequenceDiagramTabView.this.tabFolder.getItem(i);
                            found = found || t.getText().equals(this.makeCaption(idx));
                            ++i;
                        }
                        if (!found) break;
                        ++idx;
                    }
                    SequenceDiagramModel newModel = drawer.extractSelectedModel();
                    if (newModel != null) {
                        SequenceDiagramTabView.this.openNewDiagram(newModel, this.makeCaption(idx));
                    }
                }
            });
            diagramComposite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    drawer.selectElement(e.x, e.y, e.button);
                }

                public void mouseDoubleClick(MouseEvent e) {
                    drawer.processDoubleClick(e.x, e.y, e.button);
                }
            });
            Menu objectPopup = new Menu((Decorations)this.parent.getShell(), 0);
            objectComposite.setMenu(objectPopup);
            MenuItem mnuObjectHide = new MenuItem(objectPopup, 8);
            MenuItem mnuObjectDelete = new MenuItem(objectPopup, 8);
            final MenuItem mnuObjectDominator = new MenuItem(objectPopup, 8);
            mnuObjectHide.setText("Hide selected objects");
            mnuObjectDelete.setText("Delete selected objects");
            mnuObjectDominator.setText("Expand internal objects");
            objectPopup.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    DominanceFilter f;
                    SequenceObject seq = drawer.getSelectedObject();
                    mnuObjectDominator.setEnabled(false);
                    if (seq != null && (f = model.getFilters().getDominanceFilter()) != null) {
                        DominatorUnificationFilter filter = f.getDominatorFilter(seq);
                        if (filter != null) {
                            mnuObjectDominator.setEnabled(true);
                            if (filter.isActive()) {
                                mnuObjectDominator.setText("Expand internal objects");
                            } else {
                                mnuObjectDominator.setText("Collapse dominated objects");
                            }
                        } else {
                            mnuObjectDominator.setEnabled(false);
                        }
                    }
                }
            });
            mnuObjectDominator.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DominatorUnificationFilter filter;
                    SequenceObject seq = drawer.getSelectedObject();
                    if (seq != null && (filter = model.getFilters().getDominanceFilter().getDominatorFilter(seq)) != null) {
                        filter.setActive(!filter.isActive());
                        model.renew();
                    }
                }
            });
            mnuObjectHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    drawer.createObjectHideFilter();
                }
            });
            mnuObjectDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    drawer.createObjectDeleteFilter();
                }
            });
            objectComposite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    drawer.selectObject(e.x + hDiagramSlider.getSelection(), e.y, objectComposite.getClientArea().height, vDiagramSlider.getSelection(), diagramComposite.getClientArea().height, (e.stateMask & 0x20000) != 0, (e.stateMask & 0x40000) != 0, e.button == 3);
                }
            });
            model.addModelChangeListener(new ModelChangeListener(){

                @Override
                public void changing(SequenceDiagramModel model) {
                }

                @Override
                public void changed(SequenceDiagramModel model) {
                    if (!SequenceDiagramTabView.this.parent.isDisposed()) {
                        SequenceDiagramTabView.this.parent.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Point diagramSize = drawer.computeDiagramSize();
                                hDiagramSlider.setMaximum(diagramSize.x);
                                vDiagramSlider.setMaximum(diagramSize.y);
                                updater.fireRedraw();
                                Point size = drawer.computeOverviewSize();
                                hOverviewSlider.setMaximum(size.x);
                                vOverviewSlider.setMaximum(size.y);
                            }
                        });
                    }
                }
            });
        }
        return tab;
    }

    private void openNewDiagram(SequenceDiagramModel model, String name) {
        this.filterManager.registerFilterSet(model.getFilters(), name);
        CTabItem newTab = this.createTab(this.tabFolder, name, model);
        this.tabFolder.setSelection(newTab);
        if (this.defaultTab != null) {
            this.defaultTab.dispose();
            this.defaultTab = null;
        }
        this.updateStatusLabel();
    }

    private SequenceDiagramView getActiveView() {
        if (this.tabFolder.isDisposed()) {
            return null;
        }
        CTabItem tab = this.tabFolder.getSelection();
        if (tab == null) {
            return null;
        }
        if (tab.isDisposed()) {
            return null;
        }
        return (SequenceDiagramView)tab.getData(KEY_DIAGRAM_VIEW);
    }

    private SequenceDiagramModel getActiveModel() {
        SequenceDiagramView view = this.getActiveView();
        if (view == null) {
            return null;
        }
        return view.getModel();
    }

    private void updateStatusLabel() {
        SequenceDiagramModel model = this.getActiveModel();
        if (model != null) {
            this.statusLabel.setText(model.getFileName());
            this.statusLabel.getParent().layout();
        } else if (!this.statusLabel.isDisposed()) {
            this.statusLabel.setText(LABEL_STATUS_OK);
            this.statusLabel.getParent().layout();
        }
    }

    public void loadFile(LogFileName file) {
        TextLogFile logfile = new TextLogFile(file);
        AmidaLog log = new AmidaLog(logfile);
        CallTreeGroup group = log.getCallTrees();
        int[] keys = group.treeKeys();
        int i = 0;
        while (i < keys.length) {
            FilterSet filters = new FilterSet();
            if (this.useDominanceFilter) {
                this.setupDominanceFilters(filters, log);
            }
            SequenceDiagramModel model = new SequenceDiagramModel(log, group.getCallTree(keys[i]), filters);
            this.openNewDiagram(model, group.getCallTree(keys[i]).getName());
            ++i;
        }
    }

    public void openSearchDialog() {
        this.searchDialog.open();
    }

    public void openFilterDialog() {
        FilterDialog.open(this.parent.getShell(), this.filterManager, new FilterChangeListener(){

            @Override
            public void changed() {
                SequenceDiagramTabView.this.updateAllTabs();
            }
        });
    }

    public ICompactionCommand getCompactionProcess(int ruleNumber) {
        return new CompactionCommand(ruleNumber);
    }

    public void sortObjects(int kind) {
        SequenceDiagramModel model = this.getActiveModel();
        if (model != null) {
            model.setSorter(SequenceObjectSorter.getSorter(kind));
        }
    }

    public IAmidaCommand getDominanceAnalysisCommand() {
        return new DominanceAnalysisCommand();
    }

    private void setupDefaultGlobalFilters() {
        int i = 0;
        while (i < LIBRARY_FILTER.length) {
            ObjectFilter f = new ObjectFilter();
            f.setPackageCondition(LIBRARY_FILTER[i]);
            f.setTypeIndex(1);
            this.filterManager.getGlobalFilterSet(0).addObjectFilter(f);
            ++i;
        }
    }

    private void setupDominanceFilters(FilterSet filters, AmidaLog log) {
        filters.setDominanceFilter(new DominanceFilter(log.getCallTrees().getDominanceTree()));
    }

    private class CompactionCommand
    implements ICompactionCommand {
        private int ruleNumber;

        public CompactionCommand(int ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public void execute() {
            CompactorThread thread;
            SequenceDiagramModel model = SequenceDiagramTabView.this.getActiveModel();
            if (model == null) {
                return;
            }
            NodeTreeComparator.compareNotEndedNode = true;
            switch (this.ruleNumber) {
                case 1: {
                    thread = new LoopCompactorThread(new SimpleLoopRule(5), model.getCallTree());
                    break;
                }
                case 2: {
                    thread = new LoopCompactorThread(new ObjectDifferenceLoopRule(5), model.getCallTree());
                    break;
                }
                case 3: {
                    thread = new LoopCompactorThread(new MethodMissingLoopRule(5), model.getCallTree());
                    break;
                }
                case 4: {
                    thread = new RecursiveCallCompactorThread(model.getCallTree());
                    break;
                }
                default: {
                    return;
                }
            }
            thread.addProgressListener(new ProgressListener(){

                @Override
                public void progress(final int value, final int max) {
                    if (!SequenceDiagramTabView.this.parent.isDisposed()) {
                        Display display = SequenceDiagramTabView.this.parent.getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!SequenceDiagramTabView.this.progress.getVisible()) {
                                    SequenceDiagramTabView.this.progress.getParent().layout();
                                    SequenceDiagramTabView.this.progress.setVisible(true);
                                }
                                SequenceDiagramTabView.this.progress.setMaximum(max);
                                SequenceDiagramTabView.this.progress.setSelection(value);
                                if (max == value) {
                                    SequenceDiagramTabView.this.progress.setVisible(false);
                                }
                            }
                        });
                    }
                }
            });
            thread.start();
        }
    }

    private class DominanceAnalysisCommand
    implements IAmidaCommand {
        private DominanceAnalysisCommand() {
        }

        @Override
        public void execute() {
            SequenceDiagramModel model = SequenceDiagramTabView.this.getActiveModel();
            if (model == null) {
                return;
            }
            if (model.getFilters().getDominanceFilter() == null) {
                DominanceFilter filter = new DominanceFilter(new DominanceTree(model.getLog().getCallTrees().getObjectGraph()));
                model.getFilters().setDominanceFilter(filter);
                model.renew();
            }
        }
    }

    private class SequenceDiagramView {
        private SequenceDiagramModel model;
        private SequenceDiagramDrawer drawer;
        private Composite diagramComposite;
        private Slider horizontal;
        private Slider vertical;

        public SequenceDiagramView(SequenceDiagramModel model, SequenceDiagramDrawer drawer, Composite diagramComposite, Slider horizontal, Slider vertical) {
            this.model = model;
            this.drawer = drawer;
            this.diagramComposite = diagramComposite;
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public SequenceDiagramModel getModel() {
            return this.model;
        }

        private void showObject(int objIndex) {
            int x = this.drawer.getObjectPosition(objIndex);
            if ((x -= this.diagramComposite.getSize().x / 2) < 0) {
                x = 0;
            }
            this.horizontal.setSelection(x);
        }

        public void selectAndShowObject(int objIndex) {
            this.showObject(objIndex);
            this.drawer.selectObjectByIndex(objIndex);
        }

        public void selectAndShowSequence(int seqIndex) {
            Sequence seq = this.model.getSequence(seqIndex);
            this.showObject(seq.getEndIndex());
            int y = this.drawer.getSequenceY(seqIndex);
            if ((y -= this.diagramComposite.getSize().y / 2) < 0) {
                y = 0;
            }
            this.vertical.setSelection(y);
            if (seq.getType() == 1 || seq.getType() == 5) {
                seqIndex = seq.getPareSequence().getIndex();
            }
            this.drawer.selectSequenceByIndex(seqIndex);
        }
    }

    private class TextSearch
    implements SearchListener {
        private int objectPos;
        private int sequencePos;
        private static final int OBJECT_POS_NOSELECT = Integer.MIN_VALUE;

        public TextSearch() {
            this.reset();
        }

        public void reset() {
            this.objectPos = Integer.MIN_VALUE;
            this.sequencePos = Integer.MIN_VALUE;
        }

        @Override
        public void searchObject(String searchString, boolean useRegex, boolean forward) {
            SequenceDiagramModel model = SequenceDiagramTabView.this.getActiveModel();
            if (model == null) {
                return;
            }
            if (forward) {
                int searchStartPos = this.objectPos < 0 ? 1 : this.objectPos + 1;
                int i = searchStartPos;
                while (i < model.getMaxObjectIndex()) {
                    SequenceObject obj = model.getObject(i);
                    if (this.matchObject(obj, searchString, useRegex)) {
                        SequenceDiagramTabView.this.getActiveView().selectAndShowObject(obj.getIndex());
                        this.objectPos = i;
                        break;
                    }
                    ++i;
                }
            } else {
                int searchStartPos = this.objectPos == Integer.MIN_VALUE || this.objectPos > model.getMaxObjectIndex() ? model.getMaxObjectIndex() - 1 : this.objectPos - 1;
                int i = searchStartPos;
                while (i >= 1) {
                    SequenceObject obj = model.getObject(i);
                    if (this.matchObject(obj, searchString, useRegex)) {
                        SequenceDiagramTabView.this.getActiveView().selectAndShowObject(obj.getIndex());
                        this.objectPos = i;
                        break;
                    }
                    --i;
                }
            }
        }

        private void searchSequence(String searchString, boolean useRegex, boolean call, boolean forward) {
            SequenceDiagramModel model = SequenceDiagramTabView.this.getActiveModel();
            if (model == null) {
                return;
            }
            if (forward) {
                int searchStartPos = this.sequencePos < 0 ? 0 : this.sequencePos + 1;
                int i = searchStartPos;
                while (i < model.getSequenceNum()) {
                    Sequence seq = model.getSequence(i);
                    if (this.matchSequence(seq, searchString, useRegex, call)) {
                        SequenceDiagramTabView.this.getActiveView().selectAndShowSequence(seq.getIndex());
                        this.sequencePos = i;
                        break;
                    }
                    ++i;
                }
            } else {
                int searchStartPos = this.sequencePos == Integer.MIN_VALUE || this.sequencePos > model.getSequenceNum() ? model.getSequenceNum() - 1 : this.sequencePos - 1;
                int i = searchStartPos;
                while (i >= 0) {
                    Sequence seq = model.getSequence(i);
                    if (this.matchSequence(seq, searchString, useRegex, call)) {
                        SequenceDiagramTabView.this.getActiveView().selectAndShowSequence(seq.getIndex());
                        this.sequencePos = i;
                        break;
                    }
                    --i;
                }
            }
        }

        @Override
        public void searchCall(String searchString, boolean useRegex, boolean forward) {
            this.searchSequence(searchString, useRegex, true, forward);
        }

        @Override
        public void searchReturn(String searchString, boolean useRegex, boolean forward) {
            this.searchSequence(searchString, useRegex, false, forward);
        }

        private boolean matchObject(SequenceObject obj, String searchString, boolean useRegex) {
            if (useRegex) {
                return obj.getNameSpace().matches(searchString) || obj.getClassName().matches(searchString);
            }
            return obj.getNameSpace().indexOf(searchString) >= 0 || obj.getClassName().indexOf(searchString) >= 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean matchSequence(Sequence seq, String searchString, boolean useRegex, boolean call) {
            String s;
            if (call) {
                if (seq.getType() != 0) return false;
                s = seq.getCallLabel();
                return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
            } else if (seq.getType() == 1) {
                s = seq.getNode().getReturnTypeName();
                return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
            } else {
                if (seq.getType() != 5) return false;
                s = seq.getNode().getExceptionName();
            }
            return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
        }
    }
}

