/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.AbstractFilter;
import amida.viewer.filter.FilterChangeListener;
import amida.viewer.filter.FilterSet;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class FilterTableEditHandler {
    private static final String[] COLUMN_HEAD = new String[]{"Filter Type", "Package Name Pattern", "Class Name Pattern", "Object IDs", "Use Regex"};
    private static final String[] USE_REGEX = new String[]{"No", "Yes"};
    private Table table;
    private TableCursor cursor;
    private FilterChangeListener changeListener;

    public FilterTableEditHandler(FilterChangeListener listener) {
        this.changeListener = listener;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public int getColumnCount() {
        return COLUMN_HEAD.length;
    }

    public String getColumnHead(int idx) {
        return COLUMN_HEAD[idx];
    }

    public void setCursor(TableCursor cursor) {
        this.cursor = cursor;
    }

    public void add() {
        TableItem item = new TableItem(this.table, 0);
        item.setText(this.getDefaultItem());
        this.changeListener.changed();
    }

    public void remove() {
        int idx = this.table.getSelectionIndex();
        if (idx != -1) {
            TableItem item = this.table.getItem(idx);
            MessageBox msg = new MessageBox(this.table.getShell(), 192);
            StringBuilder buf = new StringBuilder();
            buf.append("Are you sure to remove an item [");
            int i = 0;
            while (i < COLUMN_HEAD.length) {
                if (i != 0) {
                    buf.append(", ");
                }
                if (item.getText(i).trim().equals("")) {
                    buf.append("_");
                } else {
                    buf.append(item.getText(i));
                }
                ++i;
            }
            buf.append("] ?");
            msg.setMessage(buf.toString());
            msg.setText("Remove a filter");
            if (msg.open() == 64) {
                this.table.remove(idx);
                this.changeListener.changed();
            }
        }
    }

    public void up() {
        int idx = this.table.getSelectionIndex();
        if (idx > 0) {
            this.swapItems(idx, idx - 1);
        }
    }

    public void down() {
        int idx = this.table.getSelectionIndex();
        if (idx < this.table.getItemCount() - 1) {
            this.swapItems(idx, idx + 1);
        }
    }

    private void swapItems(int idx, int idx2) {
        this.table.setRedraw(false);
        TableItem item = this.table.getItem(idx);
        TableItem itemNext = this.table.getItem(idx2);
        int i = 0;
        while (i < this.table.getColumnCount()) {
            String text = item.getText(i);
            item.setText(i, itemNext.getText(i));
            itemNext.setText(i, text);
            ++i;
        }
        this.table.setRedraw(true);
        this.table.setSelection(idx2);
        this.cursor.setSelection(itemNext, this.cursor.getColumn());
        this.changeListener.changed();
    }

    public void edit(ControlEditor editor, TableCursor cursor) {
        final TableItem item = cursor.getRow();
        final int col = cursor.getColumn();
        if (item == null) {
            return;
        }
        if (col == 0 || col == this.getColumnCount() - 1) {
            final Combo combo = new Combo((Composite)cursor, 12);
            if (col == 0) {
                combo.setItems(this.getTypeItems());
            } else {
                combo.setItems(USE_REGEX);
            }
            combo.setText(item.getText(col));
            combo.setFocus();
            combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    FilterTableEditHandler.this.updateText(item, col, combo.getText());
                    combo.dispose();
                }
            });
            combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\r') {
                        FilterTableEditHandler.this.updateText(item, col, combo.getText());
                        combo.dispose();
                    } else if (e.keyCode == 27) {
                        combo.dispose();
                    }
                }
            });
            editor.setEditor((Control)combo);
        } else {
            final Text text = new Text((Composite)cursor, 0);
            text.setText(item.getText(col));
            text.setFocus();
            text.selectAll();
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    FilterTableEditHandler.this.updateText(item, col, text.getText());
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        FilterTableEditHandler.this.updateText(item, col, text.getText());
                        text.dispose();
                    } else if (e.keyCode == 27) {
                        text.dispose();
                    }
                }
            });
            editor.setEditor((Control)text);
        }
    }

    private void updateText(TableItem item, int col, String newText) {
        if (!item.getText(col).equals(newText)) {
            item.setText(col, newText);
            this.changeListener.changed();
        }
    }

    protected Table getTable() {
        return this.table;
    }

    protected boolean getUseRegexValue(TableItem item) {
        return item.getText(this.getColumnCount() - 1).equals(USE_REGEX[1]);
    }

    protected String getUseRegexString(boolean b) {
        if (b) {
            return USE_REGEX[1];
        }
        return USE_REGEX[0];
    }

    protected int getTypeIndex(TableItem item) {
        String[] items = this.getTypeItems();
        int i = 0;
        while (i < items.length) {
            if (item.getText(0).equals(items[i])) {
                return i;
            }
            ++i;
        }
        assert (false);
        return -1;
    }

    protected void setItemAttribute(int index, AbstractFilter f) {
        TableItem item = this.table.getItem(index);
        f.setTypeIndex(this.getTypeIndex(item));
        f.setPackageCondition(item.getText(1));
        f.setClassCondition(item.getText(2));
        f.setObjectCondition(item.getText(3));
        f.setUseRegex(this.getUseRegexValue(item));
    }

    public void setFilters(Iterable<? extends AbstractFilter> filters) {
        Table table = this.getTable();
        table.setRedraw(false);
        table.removeAll();
        for (AbstractFilter abstractFilter : filters) {
            TableItem item = new TableItem(table, 0);
            this.copyFilterAttributeToItem(item, abstractFilter);
        }
        table.setRedraw(true);
    }

    protected void copyFilterAttributeToItem(TableItem item, AbstractFilter f) {
        item.setText(0, this.getTypeItems()[f.getTypeIndex()]);
        item.setText(1, f.getPackageCondition());
        item.setText(2, f.getClassCondition());
        item.setText(3, f.getObjectCondition());
        item.setText(4, this.getUseRegexString(f.getUseRegex()));
    }

    protected abstract String[] getDefaultItem();

    protected abstract String[] getTypeItems();

    protected abstract void saveFilters(FilterSet var1);
}

