/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import java.util.ArrayList;
import java.util.Collections;

public class IDMatcher {
    private int[][] rangeList;
    private static final int START = 0;
    private static final int END = 1;

    public IDMatcher(String pattern) {
        this.parseRangeIDList(pattern);
    }

    public boolean match(int[] ids) {
        int idx = 0;
        int rangeIdx = 0;
        if (idx >= ids.length || rangeIdx >= this.rangeList.length) {
            return false;
        }
        int id = ids[idx++];
        int[] range = this.rangeList[rangeIdx++];
        while (true) {
            if (range[0] > id) {
                if (idx < ids.length) {
                    id = ids[idx++];
                    continue;
                }
                return false;
            }
            if (id <= range[1]) {
                return true;
            }
            if (rangeIdx >= this.rangeList.length) break;
            range = this.rangeList[rangeIdx++];
        }
        return false;
    }

    public boolean match(int eventID) {
        if (this.rangeList.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.rangeList.length) {
            if (this.rangeList[i][0] <= eventID && eventID <= this.rangeList[i][1]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void parseRangeIDList(String arg) {
        ArrayList<IDRange> rangeList = new ArrayList<IDRange>();
        String[] args = arg.split(",");
        int i = 0;
        while (i < args.length) {
            String s = args[i].trim();
            if (s.length() != 0) {
                int idx = s.indexOf(45);
                if (idx >= 0) {
                    String start = s.substring(0, idx).trim();
                    String end = s.substring(idx + 1).trim();
                    try {
                        int startInt = 1;
                        if (start.length() > 0) {
                            startInt = Integer.valueOf(start);
                        }
                        int endInt = Integer.MAX_VALUE;
                        if (end.length() > 0) {
                            endInt = Integer.valueOf(end);
                        }
                        rangeList.add(new IDRange(startInt, endInt));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        int objID = Integer.valueOf(s);
                        rangeList.add(new IDRange(objID, objID));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        Collections.sort(rangeList);
        int idx = 0;
        this.rangeList = new int[rangeList.size()][2];
        for (IDRange range : rangeList) {
            this.rangeList[idx][0] = range.start;
            this.rangeList[idx][1] = range.end;
            ++idx;
        }
    }

    private static class IDRange
    implements Comparable<IDRange> {
        private int start;
        private int end;

        public IDRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean match(int objectID) {
            return this.start <= objectID && objectID <= this.end;
        }

        @Override
        public int compareTo(IDRange arg0) {
            int s = this.start - arg0.start;
            if (s == 0) {
                s = this.end - arg0.end;
            }
            return s;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IDRange) {
                IDRange other = (IDRange)obj;
                return this.start == other.start && this.end == other.end;
            }
            return false;
        }
    }
}

