#!/usr/bin/perl

=pod

=head1 NAME

log2actor_new - Extract Actor ID from Amida''s log.

=head1 SYNOPSIS

    perl log2actor_new.pl [-mocp] [-t threadfile ]  amida.log

=head1 DESCRIPTION

AmidaΥե󰵽̡ˤɤ߹ߡ
B<(index, caller_id, callee_id, callstack_depth, Filepointer)>1Ԥ˶ڤɸϤؽϤ롥
եԤ˥ȥȤǿȥ٥ȿ򤽤줾Ϥ롥

# ATTENSION: 
#     object ID '0' is reserved for static method calls, and
#     object ID '-1' is reserved for root method of this execution trace.

=head1 OPTIONS

=item -t threadfile
 åʸ̥ե˽񤭽Фʥꥸʥμ¹򤽤ΤΤʤ

=item -m

᥽åñ̤ID򿶤

=item -o

֥ñ̤ID򿶤
ǥեȤǤñ̤Ǥ

=item -c

饹ñ̤ID򿶤

=item -p

ѥåñ̤ID򿶤

=cut

use strict;
use Getopt::Std;

my $in_file;                 ## ե̾
my @callstack = ();        ## 륹åǤϥ֥ID
##  ȥåפ˸߸Ƥ륪֥ȡʸƤӽФ쥯饹ˤIDʲƤӽФޤ¤֡

my $objects = {};          ## μºݤΥ֥IDȽϤIDΥޥå
##  ̵̾ϥåؤΥե
##  $$objects{֥ID} = бID
keys(%$objects) = 5000;    ## ޥåץϥå5000Ǥޤ
$$objects{"0"}=0;          ## static method calls

$callstack[0]=-1;          ## reserved for root method of this execution trace
my $line = 0;              ##index
my $linecounter = 0;

# ޥɥ饤󥪥ץ
my %options;
getopts('mocpt:', \%options);

if($options{"m"}){ delete $$objects{"0"};}
elsif($options{"o"}){}
elsif($options{"c"}){delete $$objects{"0"};}
elsif($options{"p"}){}

my $threadfile ="";
if($options{'t'}){ 
	$threadfile = $options{'t'};
	open( THREAD, ">$threadfile" ) or die "can't create threadfile : $!\n";
}

$in_file = shift(@ARGV);

# 
if (@ARGV >= 2) {
	exit(1);
}

## ե륪ץ
open(IN, "$in_file") or die "$in_file: $!";

##ϡ
my $currentFilepointer = tell(IN);
while (<IN>) {

##amida2.0 - Ƭ:ֹ
	if( /^\@/ ){
## (a) åʸ
		if( /^\@thread/ ){ 
			if($threadfile) { print THREAD "$_"; }
			next; 
		}  

		$_ =~ s/^\@\d+\s//;
		if( $_ =~ s/^(\d+)\sFrom\:\d+\s// ) {$line = $1 - 1; }  # ??
		if( $_ =~ s/^(\d+)\s// ) {$line = $1 - 1; }  # "@X NNN void jp.co.xxxx.class(XX).method(YY){" is NNNth
	}

## (b) ֥ȽλԤξ
##      { ֥ȽλɬƬΡ}  
	if (/^}/) {
		pop @callstack;   ## ̾ϥå饪֥ID򣱤POP
		$currentFilepointer = tell (IN);
## (c) ̾ԡؿƤӽФξ
	} else {
## Ͻ
		my $id;
		my $orgID;
		$linecounter++;
		$line++;                        ## index
		if($options{"m"}){
			/^[^\s]+ ([^\(]+)\(\d+\).([^\(]+)/; ## ƽФ륯饹̾$1,᥽å̾$2سǼ
			$orgID = $1 ."." . $2;                  ## 饹̾.᥽å̾
		}
		elsif($options{"c"}){
			/^[^\s]+ ([^\(]+)\(\d+\)/;    ## ƽФ륯饹̾$1سǼ
			$orgID = $1;
		}
		elsif($options{"p"}){
			/^[^\s]+ ([^\(]*)\.[^\(^.]+\(\d+\)/;    ## ƽФѥå̾$1سǼ
			if ( $1 eq "" ){$orgID = 0 }
			else {$orgID = $1;}
		}
		else{
			/^[^\s]+ [^\(]+\((\d+)\)/;      ## ƬȾѥڡʳΤΤİʾ³ơʷ
			## Ⱦѥڡθ˳̤ʤΤİʾ³ơʸƤӽФ
			## (פθ˿İʾ³ơ)פĤƤ롥ʥ֥ID
			## γ̤Ǥ줿\1سǼ
			$orgID = $1;
		}

		if (exists $$objects{"$orgID"}) {   ## ФΥ֥ȤʤIDФ
			$id = $$objects{"$orgID"};
		} else {                        ## ФΥ֥ȤʤID򿷵
			$id = scalar(keys %$objects);# + 1;
			$$objects{"$orgID"} = $id;
		}

##
		my $num = @callstack;
		print "$line $callstack[@callstack-1] $id $num $currentFilepointer\n";

		## Υ֥å֥Ȥ򥹥åإץå
		push @callstack, $id;
	}
}
## ǿ
my $amount = scalar(keys %$objects);
print "#Objects=$amount\n#MethodCalls=$linecounter\n";
close(IN);
if($threadfile){ close(THREAD); }

exit(0);
