/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import amida.calltree.Node;
import amida.log.MethodCallEntry;
import amida.log.MethodData;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class CallTreeBuilder {
    private CallTreeGroup group;
    private CallTree tree;
    private Stack<CallNode> callStack = new Stack();
    private int methodCallNum = 0;
    private Map<CallNode, MethodCallEntry> returnToMap = new HashMap<CallNode, MethodCallEntry>();
    private MethodCallEntry theLastReturnTo;

    public CallTreeBuilder(CallTreeGroup group) {
        this.group = group;
        this.tree = new CallTree();
    }

    public CallTree getTree() {
        return this.tree;
    }

    public CallNode getCurrentCallNode() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.peek();
    }

    public Stack<CallNode> getCurrentCallStack() {
        return this.callStack;
    }

    private void processCall(int callerID, int calleeID) {
        this.group.registerCall(callerID, calleeID);
    }

    private CallNode createCallNode(MethodCallEntry call) {
        MethodData method = call.getMethod();
        int id = call.getObjectId();
        int methodCallCount = call.getMethodCallCount();
        if (methodCallCount == -1) {
            methodCallCount = this.group.getNextCallIndex();
        }
        CallNode newNode = new CallNode(this.tree, method, id, methodCallCount);
        if (id == 0) {
            int calleeID = this.group.getObjectGraph().getNewStaticCallID();
            newNode.setStaticCallID(calleeID);
        }
        return newNode;
    }

    private void pushNewCaller() {
        CallNode newNode = this.createCallNode(this.theLastReturnTo);
        ListIterator<Node> it = this.tree.getTopNodeList().listIterator();
        while (it.hasNext()) {
            CallNode n = (CallNode)it.next();
            MethodCallEntry returnTo = this.returnToMap.get(n);
            if (!returnTo.getMethod().equals(this.theLastReturnTo.getMethod()) || returnTo.getObjectId() != this.theLastReturnTo.getObjectId()) continue;
            it.remove();
            newNode.addChild(n);
            this.processCall(newNode.getObjectGraphNodeID(), n.getObjectGraphNodeID());
        }
        this.tree.getTopNodeList().add(newNode);
        this.getCurrentCallStack().add(newNode);
        ++this.methodCallNum;
    }

    public CallNode methodExit(MethodCallEntry returnTo, String exception) {
        if (this.callStack.isEmpty()) {
            this.pushNewCaller();
        }
        CallNode current = this.getCurrentCallNode();
        current = this.getCurrentCallNode();
        if (current != null) {
            if (exception == null) {
                current.setExitMode(1);
            } else {
                current.setExitMode(2);
                current.setException(exception);
            }
            if (this.getCurrentCallStack().size() == 1) {
                this.returnToMap.put(current, returnTo);
            }
        }
        this.theLastReturnTo = returnTo;
        return this.getCurrentCallStack().pop();
    }

    public CallNode methodCall(MethodCallEntry call) {
        CallNode newNode = this.createCallNode(call);
        CallNode current = this.getCurrentCallNode();
        if (current != null) {
            current.addChild(newNode);
            this.processCall(current.getObjectGraphNodeID(), newNode.getObjectGraphNodeID());
        } else {
            this.tree.getTopNodeList().add(newNode);
        }
        this.getCurrentCallStack().push(newNode);
        ++this.methodCallNum;
        return newNode;
    }
}

