/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeIterator;
import amida.calltree.NodeList;
import java.util.Iterator;

public abstract class Node
implements Cloneable {
    private NodeList children;
    private NodeList emptyList;
    private CallTree tree;
    private Node parent = null;
    private boolean isBehind = false;

    public Node(CallTree tree) {
        this.tree = tree;
        this.children = new NodeList(this, tree);
        this.emptyList = null;
    }

    public CallTree getCallTree() {
        return this.tree;
    }

    private NodeList getEmptyList() {
        if (this.emptyList == null) {
            this.emptyList = new NodeList(this, this.tree);
        }
        return this.emptyList;
    }

    public void setCallTree(CallTree tree) {
        this.tree = tree;
        this.children.setCallTree(tree);
    }

    public void addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public NodeList getChildren() {
        if (!this.isBehind()) {
            return this.children;
        }
        return this.getEmptyList();
    }

    public NodeList getAllChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty() && !this.isBehind();
    }

    public void setBehind(boolean behind) {
        if (behind && !this.hasChildren()) {
            return;
        }
        this.isBehind = behind;
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
    }

    public boolean isBehind() {
        return this.isBehind;
    }

    public CallTreeIterator nodeIterator() {
        return this.getChildren().nodeIterator();
    }

    public Node cloneForNewTree(CallTree newTree) {
        Node copyNode;
        try {
            copyNode = (Node)this.clone();
            copyNode.setCallTree(newTree);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to copy call tree nodes.");
        }
        return copyNode;
    }

    public Object clone() throws CloneNotSupportedException {
        Node copy = (Node)super.clone();
        NodeList copyChildren = new NodeList(copy, this.getCallTree());
        for (Node node : this.children) {
            Node copyChild = (Node)node.clone();
            copyChild.setParent(copy);
            copyChildren.add(copyChild);
        }
        copy.children = copyChildren;
        copy.parent = null;
        return copy;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (this.hasChildren()) {
            Iterator<Node> it = this.getChildren().iterator();
            while (it.hasNext()) {
                buffer.append(it.next().toString(depth));
                if (!it.hasNext()) continue;
                buffer.append(lineSeparator);
            }
        }
        return buffer.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public abstract int getCallNodeNum();

    public abstract CallNode getCallNode(int var1);

    public abstract Node getNewInstance();
}

