/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.calltree.NodeList;

public class TopRecursiveBlockNode
extends BlockNode {
    private NodeList hiddenList;
    private NodeList representList;
    private boolean isFold = true;

    public TopRecursiveBlockNode(CallNode represent, CallNode brind) {
        super(represent.getCallTree());
        this.representList = new NodeList(this, represent.getCallTree());
        this.representList.add(represent);
        represent.setParent(this);
        this.hiddenList = new NodeList(this, represent.getCallTree());
        this.hiddenList.add(brind);
        brind.setParent(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TopRecursiveBlockNode copy = (TopRecursiveBlockNode)super.clone();
        NodeList newRepresentList = new NodeList(copy, this.getCallTree());
        newRepresentList.add(this.representList.get(0));
        copy.representList = newRepresentList;
        NodeList newHiddenList = new NodeList(copy, this.getCallTree());
        newHiddenList.add(this.hiddenList.get(0));
        copy.hiddenList = newHiddenList;
        return copy;
    }

    public CallNode getRepresentChild() {
        CallNode result = null;
        try {
            result = (CallNode)this.getRepresentChildren().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public CallNode getHiddenChild() {
        return (CallNode)this.getHiddenChildren().get(0);
    }

    public void setFold(boolean bool) {
        this.isFold = bool;
    }

    public boolean isFold() {
        return this.isFold;
    }

    @Override
    public NodeList getChildren() {
        if (this.isBehind()) {
            return super.getChildren();
        }
        if (this.isFold()) {
            return this.getRepresentChildren();
        }
        return this.getHiddenChildren();
    }

    public NodeList getRepresentChildren() {
        return this.representList;
    }

    public NodeList getHiddenChildren() {
        return this.hiddenList;
    }

    @Override
    public CallNode getCallNode(int index) {
        if (index != 0) {
            return null;
        }
        if (this.isFold()) {
            return this.getRepresentChild();
        }
        return this.getHiddenChild();
    }

    @Override
    public int getCallNodeNum() {
        return 1;
    }

    @Override
    public void addChild(Node node) {
        if (node instanceof CallNode) {
            this.setRepresentList((CallNode)node);
        }
    }

    public void setRepresentList(CallNode call) {
        this.representList.set(0, call);
    }

    @Override
    public boolean hasChildren() {
        return !this.isBehind();
    }

    @Override
    public CallTreeIterator nodeIterator() {
        if (this.isBehind()) {
            return super.nodeIterator();
        }
        if (this.isFold) {
            return this.getRepresentChildren().nodeIterator();
        }
        return this.getHiddenChildren().nodeIterator();
    }

    @Override
    public void removeAllChildren() {
    }

    @Override
    public String toString() {
        if (this.isFold) {
            return this.getRepresentChild().toString();
        }
        return this.getHiddenChild().toString();
    }

    @Override
    public Node getNewInstance() {
        try {
            CallNode rep = (CallNode)this.getRepresentChild().clone();
            CallNode hid = (CallNode)this.getHiddenChild().clone();
            return new TopRecursiveBlockNode(rep, hid);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

