/*
 * Decompiled with CFR 0.152.
 */
package amida.log;

import java.io.File;

public class LogFileName {
    public static final int PHASE_WHOLE = -1;
    private String logfile;
    private String threadDecl;
    private long phaseBegin;
    private long phaseEnd;

    public LogFileName(String logfile) {
        this(logfile, null);
    }

    public LogFileName(String logfile, String threadDecl) {
        this(logfile, threadDecl, -1L, -1L);
    }

    public LogFileName(LogFileName original, long begin, long end) {
        this(original.logfile, original.threadDecl, begin, end);
    }

    private LogFileName(String logfile, String threadDecl, long begin, long end) {
        this.logfile = logfile;
        this.threadDecl = threadDecl;
        this.phaseBegin = begin;
        this.phaseEnd = end;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public String getThreadDecl() {
        return this.threadDecl;
    }

    public File getFileObject() {
        return new File(this.logfile);
    }

    public File getThreadDeclFile() {
        if (this.threadDecl != null) {
            return new File(this.threadDecl);
        }
        return null;
    }

    public long getPhaseBegin() {
        return this.phaseBegin;
    }

    public long getPhaseEnd() {
        return this.phaseEnd;
    }

    public String toString() {
        return this.toStringInternal(",");
    }

    public String toAmidaViewerString() {
        return this.toStringInternal("*");
    }

    private String toStringInternal(String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.logfile);
        if (this.isPhaseSpecified()) {
            builder.append(separator);
            builder.append(this.phaseBegin);
            builder.append(separator);
            builder.append(this.phaseEnd);
        }
        if (this.threadDecl != null) {
            builder.append(separator);
            builder.append(this.threadDecl);
        }
        return builder.toString();
    }

    public boolean isPhaseSpecified() {
        return this.phaseBegin != -1L;
    }
}

