/*
 * Decompiled with CFR 0.152.
 */
package amida.log.java;

import amida.log.ClassData;
import amida.log.Field;
import amida.log.MethodData;
import amida.log.Type;
import amida.log.java.JavaMethod;
import amida.log.java.JavaType;
import amida.log.java.ReferenceType;
import amida.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaClassOrInterface
implements ReferenceType,
ClassData {
    private static final int UNDECIDED = 0;
    private static final int CLASS = 1;
    private static final int INTERFACE = 2;
    private int type;
    private final String fullName;
    private final String simpleJavaTypeName;
    private final String packageName;
    private final String className;
    private final Set<JavaClassOrInterface> subClasses = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> superClasses = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> subInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> superInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> implementInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> implementers = new HashSet<JavaClassOrInterface>();
    private final Map<String, Set<JavaMethod>> methodMap = new HashMap<String, Set<JavaMethod>>();
    private final Set<Field> fields = new HashSet<Field>();
    private final Set<JavaMethod> innerClasses = new HashSet<JavaMethod>();

    public JavaClassOrInterface(String fullName) {
        this.fullName = fullName;
        this.simpleJavaTypeName = "L" + fullName.replace('.', '/') + ";";
        this.type = 0;
        Pair<String, String> p = this.separateNames(fullName);
        this.packageName = p.getFirst();
        this.className = p.getSecond();
    }

    @Override
    public String getTypeName() {
        return this.fullName;
    }

    @Override
    public Collection<ClassData> getSubClasses() {
        return null;
    }

    @Override
    public boolean isSubClassOf(ClassData superClass) {
        return false;
    }

    @Override
    public Collection<ClassData> getSuperClasses() {
        return null;
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return null;
    }

    @Override
    public String getSimpleTypeName() {
        return this.getName();
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public boolean isClass() {
        return this.type == 1;
    }

    public boolean isInterface() {
        return this.type == 2;
    }

    public Collection<JavaMethod> getMethods(String name) {
        if (this.methodMap.containsKey(name)) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            return Collections.unmodifiableSet(methods);
        }
        return null;
    }

    public boolean hasMethod(String name) {
        return this.methodMap.containsKey(name);
    }

    @Override
    public Collection<Field> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    @Override
    public Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Collection<JavaMethod> getInnerClasses() {
        return Collections.unmodifiableSet(this.innerClasses);
    }

    @Override
    public String getNameSpace() {
        return this.getPackageName();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaClassOrInterface) {
            JavaClassOrInterface coi = (JavaClassOrInterface)o;
            return this == coi;
        }
        return super.equals(o);
    }

    @Override
    public String getJavaSignatureName() {
        return this.simpleJavaTypeName;
    }

    public void removeSubClass(JavaClassOrInterface coi) {
        this.subClasses.remove(coi);
        this.subInterfaces.remove(coi);
        this.implementers.remove(coi);
    }

    public void removeSuperClass(JavaClassOrInterface coi) {
        this.superClasses.remove(coi);
        this.superInterfaces.remove(coi);
        this.implementInterfaces.remove(coi);
    }

    public boolean hasSuperClasses() {
        return !this.superClasses.isEmpty();
    }

    public boolean hasSuperInterfaces() {
        return !this.superInterfaces.isEmpty();
    }

    public boolean hasImplementInterfaces() {
        return !this.implementInterfaces.isEmpty();
    }

    public String toString() {
        return this.fullName;
    }

    @Override
    public boolean hasMethod(String name, Type[] argTypes) {
        if (argTypes instanceof JavaType[]) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            for (JavaMethod method : methods) {
                Type[] types = method.getArgmentTypes();
                boolean match = true;
                int i = 0;
                while (i < types.length) {
                    if (argTypes[i] != types[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MethodData getMethod(String name, Type[] argTypes) {
        if (argTypes instanceof JavaType[]) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            for (JavaMethod method : methods) {
                Type[] types = method.getArgmentTypes();
                boolean match = true;
                int i = 0;
                while (i < types.length) {
                    if (argTypes[i] != types[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public boolean hasField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Pair<String, String> separateNames(String fullClassName) {
        String packageName = null;
        String coiName = null;
        int index = fullClassName.lastIndexOf(46);
        if (index == -1) {
            index = fullClassName.lastIndexOf(47);
        }
        if (index == -1) {
            packageName = "";
            coiName = fullClassName;
        } else {
            packageName = fullClassName.substring(0, index);
            coiName = fullClassName.substring(index + 1);
        }
        return new Pair<String, String>(packageName, coiName);
    }
}

