/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.gui.ProcessMonitorTask;
import amida.logmanager.AmidaProperty;
import amida.logmanager.CommandBuilder;
import amida.logmanager.ParameterTable;
import amida.logmanager.PhaseDetectionListener;
import amida.phase.IPhaseDetectionTask;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalPhaseDetection
extends ProcessMonitorTask
implements IPhaseDetectionTask {
    private Shell shell;
    private PhaseDetectionListener listener;
    private File targetFile;
    private Button execButton;
    private boolean success;

    private ExternalPhaseDetection(Shell shell, Process process, File targetFile, Text execLog, Button execButton) {
        super(shell.getDisplay(), execLog, process);
        this.shell = shell;
        this.targetFile = targetFile;
        this.execButton = execButton;
        this.listener = null;
        this.success = false;
    }

    public void setPhaseDetectionListener(PhaseDetectionListener listener) {
        this.listener = listener;
    }

    @Override
    protected void onReadLine(String line) {
        if (line.startsWith("finished.")) {
            this.success = true;
        }
    }

    @Override
    protected void onFinished() {
        this.checkAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ExternalPhaseDetection.this.execButton.isDisposed()) {
                    ExternalPhaseDetection.this.execButton.setText("Execute!");
                }
                if (ExternalPhaseDetection.this.listener != null) {
                    ExternalPhaseDetection.this.listener.onFinished(ExternalPhaseDetection.this.shell, ExternalPhaseDetection.this.success, ExternalPhaseDetection.this.targetFile.getAbsolutePath());
                }
            }
        });
    }

    private static void deleteDirRecursive(File dir) {
        File[] entries = dir.listFiles();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isDirectory()) {
                ExternalPhaseDetection.deleteDirRecursive(entries[i]);
            } else {
                entries[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static IPhaseDetectionTask executePhaseDetection(Shell shell, PhaseDetectionListener listener, String logfile, ParameterTable parameters, Text execLog, Button execButton) {
        File dir = new File(String.valueOf(logfile) + ".tmp");
        if (dir.exists()) {
            MessageBox box = new MessageBox(shell, 288);
            box.setText("A temporary directory already exists");
            box.setMessage("Phase detection process is using a directory '" + dir.getAbsolutePath() + "' to store intermediate data.  Are you sure to delete the contents of the directory?");
            if (box.open() == 32) {
                ExternalPhaseDetection.deleteDirRecursive(dir);
            } else {
                return null;
            }
        }
        try {
            File f = new File(logfile);
            if (f.canRead()) {
                File scriptDir = new File(AmidaProperty.getInstance().getScriptDir());
                File script = new File(scriptDir, AmidaProperty.getInstance().getPhaseDetectionScriptName());
                CommandBuilder cmd = new CommandBuilder();
                cmd.append(AmidaProperty.getInstance().getScriptCommand());
                cmd.append(script.getAbsolutePath());
                cmd.append(parameters.getParameterOption());
                cmd.append("-b");
                cmd.append(scriptDir.getAbsolutePath());
                cmd.append(f.getAbsolutePath());
                String command = cmd.toString();
                execLog.append("Execute: ");
                execLog.append(command);
                execLog.append("\n");
                execButton.setText("CANCEL");
                Process process = Runtime.getRuntime().exec(command);
                ExternalPhaseDetection task = new ExternalPhaseDetection(shell, process, f, execLog, execButton);
                if (listener != null) {
                    task.setPhaseDetectionListener(listener);
                }
                Thread thread = new Thread(task);
                thread.start();
                return task;
            }
            execLog.append("File is not readable: " + f.getAbsolutePath() + "\n");
            return null;
        }
        catch (IOException e) {
            execLog.append("Failed.");
            execButton.setText("Execute!");
            return null;
        }
    }
}

