/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import amida.phase.Event;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedList;

public class CacheUpdateFrequencyReader {
    private ObjectInputStream input;
    private LinkedList<Event> events;

    public CacheUpdateFrequencyReader(InputStream in) throws IOException {
        this.input = new ObjectInputStream(in);
        this.events = new LinkedList();
    }

    public boolean readEvent() throws IOException {
        if (this.input.available() != 0) {
            int index = this.input.readInt();
            int callstackDepth = this.input.readInt();
            long filePointer = this.input.readLong();
            int len = this.input.readInt();
            double[] freq = new double[len];
            int i = 0;
            while (i < len) {
                freq[i] = this.input.readDouble();
                ++i;
            }
            this.events.offer(new Event(index, callstackDepth, filePointer, freq));
            return true;
        }
        return false;
    }

    public Event getCurrentEvent() {
        return this.events.getLast();
    }

    public Event getEvent(int eventIndex) {
        return this.events.get(eventIndex);
    }

    public int getEventCount() {
        return this.events.size();
    }

    public void close() throws IOException {
        this.input.close();
    }

    public int findEventIndexOfMinimumStackDepth() {
        int min = this.events.get(0).getCallstackDepth();
        int index = 0;
        int i = 1;
        while (i < this.events.size()) {
            int next = this.events.get(i).getCallstackDepth();
            if (min > next) {
                min = next;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void removeOldestEvent() {
        this.events.removeFirst();
    }
}

