/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.elements;

import amida.viewer.elements.Called;
import amida.viewer.elements.ISequenceElement;
import amida.viewer.elements.NameSet;
import amida.viewer.elements.Sequence;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class SequenceObject
implements ISequenceElement {
    public static final int STATE_VISIBLE = 0;
    public static final int STATE_HIDDEN = 1;
    public static final int STATE_DELETED = 2;
    private int state = 0;
    private int index;
    private int madeIndex;
    private int lastUsedIndex;
    private int appearanceNum;
    private NameSet className;
    private TIntHashSet ids = new TIntHashSet();
    private int[] idarray = null;
    private List<Called> calledList = new ArrayList<Called>();
    private final Stack<Integer> callStack = new Stack();
    private final List<Sequence> calledSequences = new LinkedList<Sequence>();
    private final List<Sequence> callSequences = new LinkedList<Sequence>();
    private List<SequenceObject> children = null;
    private List<String> label;
    private static final Integer ZERO = new Integer(0);
    public static final String CLASS_OBJECT_LABEL = "<CLASS>";

    public SequenceObject() {
        this.className = new NameSet();
    }

    public SequenceObject(String signature, Set<Integer> ids) {
        this();
        this.addClassName(signature);
        this.addIds(ids);
    }

    public final void addClassName(String signature) {
        int idx = signature.lastIndexOf(46);
        if (idx >= 0) {
            String pkg = signature.substring(0, idx);
            String klass = signature.substring(idx + 1, signature.length());
            this.className.addName(pkg, klass);
        } else {
            this.className.addName("", signature);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void updated() {
        this.idarray = null;
        this.label = null;
    }

    public int getIndex() {
        return this.index;
    }

    public void addId(int i) {
        this.ids.add(i);
        this.updated();
    }

    public void addId(Integer i) {
        this.ids.add(i.intValue());
        this.updated();
    }

    public void addIds(int[] ids) {
        this.ids.addAll(ids);
        this.updated();
    }

    public final void addIds(Set<Integer> ids) {
        for (Integer i : ids) {
            this.ids.add(i.intValue());
        }
        this.updated();
    }

    public boolean isStaticObject() {
        return this.getIdList().length == 1 && this.getIdList()[0] == ZERO;
    }

    public boolean containsStaticObject() {
        return this.getIdList()[0] == ZERO;
    }

    public int[] getIdList() {
        if (this.idarray == null) {
            this.idarray = this.ids.toArray();
            Arrays.sort(this.idarray);
        }
        return this.idarray;
    }

    public String getClassName() {
        return this.className.getClassName();
    }

    public String getNameSpace() {
        return this.className.getNamespace();
    }

    public void call(Sequence seq, int start) {
        this.callStack.push(new Integer(start));
        this.calledSequences.add(seq);
    }

    public void ret(Sequence seq, int end) {
        Integer start = this.callStack.pop();
        this.calledList.add(new Called(this, seq.getPareSequence(), seq, start, end, this.callStack.size()));
        this.calledSequences.add(seq);
    }

    public void addCallSequence(Sequence seq) {
        this.callSequences.add(seq);
    }

    public int getCalledNum() {
        return this.calledList.size();
    }

    public Called getCalled(int index) {
        return this.calledList.get(index);
    }

    public int getLevel() {
        return this.callStack.size();
    }

    public void make(int index) {
        this.madeIndex = index;
    }

    public int getMadeIndex() {
        return this.madeIndex;
    }

    public void used(int index) {
        this.lastUsedIndex = index;
    }

    public int getLastUsedIndex() {
        return this.lastUsedIndex;
    }

    public int getAppearanceNum() {
        return this.appearanceNum;
    }

    public boolean isVisible(int index) {
        return index <= this.lastUsedIndex;
    }

    public boolean isActive(int start, int end) {
        return start <= this.madeIndex && this.madeIndex <= end || start <= this.lastUsedIndex && this.lastUsedIndex <= end || this.madeIndex < start && end < this.lastUsedIndex;
    }

    public void setAppearanceIndex(int i) {
        this.appearanceNum = i;
        this.index = i;
    }

    public void setVisibleState(int state) {
        this.state = state;
    }

    public boolean isHidden() {
        return this.state == 1;
    }

    public boolean isDeleted() {
        return this.state == 2;
    }

    public void merge(SequenceObject another) {
        if (this.children == null) {
            this.children = new ArrayList<SequenceObject>();
        }
        this.children.add(another);
        this.addIds(another.getIdList());
        this.className.merge(another.className);
        if (this.state > another.state) {
            this.state = another.state;
        }
    }

    public boolean isUnified() {
        return this.children != null && this.children.size() >= 1;
    }

    public List<SequenceObject> getUnifiedObjects() {
        return this.children;
    }

    public String getObjectCountString() {
        return "(" + Integer.toString(this.getIdList().length) + " objects)";
    }

    public List<String> getObjectIDLabels() {
        if (this.label == null) {
            this.label = new ArrayList<String>();
            int[] idlist = this.getIdList();
            if (idlist.length == 1) {
                if (idlist[0] == 0) {
                    this.label.add(CLASS_OBJECT_LABEL);
                } else {
                    this.label.add(Integer.toString(idlist[0]));
                }
            } else {
                int start;
                Arrays.sort(idlist);
                int last = start = idlist[0];
                int i = 1;
                while (i < idlist.length) {
                    if (last + 1 == idlist[i]) {
                        last = idlist[i];
                    } else {
                        this.label.add(this.createLabel(start, last));
                        start = idlist[i];
                        last = idlist[i];
                    }
                    ++i;
                }
                this.label.add(this.createLabel(start, last));
            }
        }
        return this.label;
    }

    private String createLabel(int start, int last) {
        if (start == last) {
            return Integer.toString(start);
        }
        return String.valueOf(Integer.toString(start)) + "-" + Integer.toString(last);
    }
}

