/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.elements;

import amida.viewer.elements.SequenceObject;
import java.util.HashSet;
import junit.framework.TestCase;

public class SequenceObjectTest
extends TestCase {
    public void testSequenceObject() {
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(1);
        SequenceObject obj = new SequenceObject("test.Class", ids);
        SequenceObjectTest.assertEquals((String)"Class", (String)obj.getClassName());
        SequenceObjectTest.assertEquals((String)"test", (String)obj.getNameSpace());
        SequenceObjectTest.assertEquals((int)1, (int)obj.getIdList().length);
        SequenceObjectTest.assertEquals((int)1, (int)obj.getIdList()[0]);
        SequenceObjectTest.assertFalse((boolean)obj.isUnified());
        ids.add(2);
        SequenceObject obj2 = new SequenceObject("test.long.package.Class", ids);
        SequenceObjectTest.assertEquals((String)"Class", (String)obj2.getClassName());
        SequenceObjectTest.assertEquals((String)"test.long.package", (String)obj2.getNameSpace());
        SequenceObjectTest.assertEquals((int)2, (int)obj2.getIdList().length);
        SequenceObjectTest.assertEquals((int)1, (int)obj2.getIdList()[0]);
        SequenceObjectTest.assertEquals((int)2, (int)obj2.getIdList()[1]);
        SequenceObjectTest.assertFalse((boolean)obj2.isUnified());
        ids.add(0);
        SequenceObject obj3 = new SequenceObject("test.Class", ids);
        SequenceObjectTest.assertEquals((int)3, (int)obj3.getIdList().length);
        SequenceObjectTest.assertEquals((int)0, (int)obj3.getIdList()[0]);
        SequenceObjectTest.assertEquals((int)1, (int)obj3.getIdList()[1]);
        SequenceObjectTest.assertEquals((int)2, (int)obj3.getIdList()[2]);
        SequenceObjectTest.assertTrue((boolean)obj3.containsStaticObject());
        SequenceObjectTest.assertFalse((boolean)obj3.isStaticObject());
        SequenceObjectTest.assertFalse((boolean)obj3.isUnified());
    }

    public void testAddClassName() {
        SequenceObject obj = new SequenceObject();
        obj.addClassName("test.Class");
        SequenceObjectTest.assertEquals((String)"Class", (String)obj.getClassName());
        SequenceObjectTest.assertEquals((String)"test", (String)obj.getNameSpace());
        obj.addClassName("test2.Class2");
        SequenceObjectTest.assertEquals((String)"Class/Class2", (String)obj.getClassName());
        SequenceObjectTest.assertEquals((String)"test", (String)obj.getNameSpace());
        SequenceObject longPackage = new SequenceObject();
        longPackage.addClassName("test.long.package.Class");
        SequenceObjectTest.assertEquals((String)"Class", (String)longPackage.getClassName());
        SequenceObjectTest.assertEquals((String)"test.long.package", (String)longPackage.getNameSpace());
    }

    public void testAddId() {
        SequenceObject obj = new SequenceObject();
        SequenceObjectTest.assertEquals((int)0, (int)obj.getIdList().length);
        obj.addId(1);
        SequenceObjectTest.assertEquals((int)1, (int)obj.getIdList().length);
        obj.addId(4);
        SequenceObjectTest.assertEquals((int)2, (int)obj.getIdList().length);
        obj.addId(new Integer(5));
        SequenceObjectTest.assertEquals((int)3, (int)obj.getIdList().length);
        obj.addIds(new int[]{3, 2});
        SequenceObjectTest.assertEquals((int)5, (int)obj.getIdList().length);
        int[] ids = obj.getIdList();
        int i = 1;
        while (i <= 5) {
            SequenceObjectTest.assertEquals((int)i, (int)ids[i - 1]);
            ++i;
        }
    }
}

