/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.amida_log;

import amida.agent.flexible_log.DamidaFlexiblePrinter;
import amida.agent.flexible_log.DamidaFlexibleTextPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class DamidaAmidaPrinter
extends DamidaFlexibleTextPrinter {
    protected static Map<Integer, Long> idMap = new HashMap<Integer, Long>();
    protected static Long idStamp = new Long(0L);
    public boolean newState;
    public Stack<Long> idStack;
    protected static Map<String, Long> methMap = new HashMap<String, Long>();
    protected static Long methStamp = new Long(1L);
    public String thread;

    public DamidaAmidaPrinter(boolean gzip) {
        super(gzip);
        idMap.put(null, 0L);
        this.newState = false;
        this.idStack = new Stack();
        this.thread = "@" + this.getLogThread().getId() + " ";
    }

    @Override
    public DamidaFlexiblePrinter<String> clone() {
        return new DamidaAmidaPrinter(this.gzip);
    }

    @Override
    public void writeOutputStream(String log) throws IOException {
        super.writeOutputStream(String.valueOf(this.thread) + log);
    }

    @Override
    public void doFirst() {
        try {
            super.writeOutputStream("@thread " + this.getLogThread().getId() + " = \"" + this.getLogThread().getName() + "\"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pushID() {
        Long id;
        if (!this.newState && this.idStack.size() > 0) {
            id = this.idStack.peek();
        } else {
            Long l = idStamp;
            synchronized (l) {
                Long l2 = idStamp;
                idStamp = l2 + 1L;
                id = new Long(l2);
            }
            this.newState = false;
        }
        this.idStack.add(id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID(Object o) {
        Integer hash = System.identityHashCode(o);
        Map<Integer, Long> map = idMap;
        synchronized (map) {
            Long id = idMap.get(hash);
            if (id == null) {
                Long l = idStamp;
                synchronized (l) {
                    Long l2 = idStamp;
                    idStamp = l2 + 1L;
                    id = l2;
                    idMap.put(hash, l2);
                }
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popID(Object o) {
        if (o == null || this.idStack.size() <= 0) {
            return;
        }
        Integer hash = System.identityHashCode(o);
        Map<Integer, Long> map = idMap;
        synchronized (map) {
            idMap.put(hash, this.idStack.pop());
        }
        this.newState = false;
    }

    public void newState() {
        this.newState = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFromID(String name) {
        Map<String, Long> map = methMap;
        synchronized (map) {
            Long id = methMap.get(name);
            if (id == null) {
                Long l = methStamp;
                synchronized (l) {
                    Long l2 = methStamp;
                    methStamp = l2 + 1L;
                    id = l2;
                    methMap.put(name, l2);
                }
            }
            return id;
        }
    }
}

