/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.logging_tf;

import amida.agent.logging_tf.DamidaLog;
import amida.agent.tranceformer.DamidaTranseformer;
import javassist.CannotCompileException;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.Expr;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;

public class DamidaLoggingTranseformer<T>
extends DamidaTranseformer {
    private DamidaLog<T> log;

    public DamidaLoggingTranseformer(String argv, DamidaLog<T> log) {
        String setting_file = null;
        String log_dir = null;
        if (argv != null) {
            String[] ss = argv.split(",");
            if (ss.length >= 1) {
                setting_file = ss[0];
            }
            if (ss.length >= 2) {
                log_dir = ss[1];
            }
        }
        this.log = log;
        this.log.init(setting_file, log_dir);
    }

    @Override
    protected boolean isTfClass(String name) {
        return this.log.isLgInClass(name);
    }

    @Override
    protected boolean isTfConstructor(CtConstructor c) {
        return this.log.isLgInConstructor(c);
    }

    @Override
    protected boolean isTfMethod(CtMethod c) {
        return this.log.isLgInMethod(c);
    }

    @Override
    protected String[] getConstructorInsertCode(CtConstructor c) {
        if (this.log.isLgInConstructor(c)) {
            return this.log.getLgConstructorInsertCode(c);
        }
        return null;
    }

    @Override
    protected String[] getMethodInsertCode(CtMethod c) {
        if (this.log.isLgInMethod(c)) {
            return this.log.getLgMethodInsertCode(c);
        }
        return null;
    }

    @Override
    protected ExprEditor getExprEditor() {
        return new LoggingExprEditor();
    }

    class LoggingExprEditor
    extends ExprEditor {
        private void replace(Expr c, String str) throws CannotCompileException {
            if (str != null) {
                c.replace(str);
            }
        }

        public void edit(ConstructorCall c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgConstructorCall(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgConstructorCallCode(c));
            }
        }

        public void edit(MethodCall c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgMethodCall(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgMethodCallCode(c));
            }
        }

        public void edit(FieldAccess c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgFieldAccess(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgFieldAccessCode(c));
            }
        }

        public void edit(Cast c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgCast(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgCastCode(c));
            }
        }

        public void edit(Instanceof c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgInstanceof(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgInstanceofCode(c));
            }
        }

        public void edit(Handler c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgHandler(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgHandlerCode(c));
            }
        }

        public void edit(NewArray c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgNewArray(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgNewArrayCode(c));
            }
        }

        public void edit(NewExpr c) throws CannotCompileException {
            if (DamidaLoggingTranseformer.this.log.isLgNewExpr(c)) {
                this.replace((Expr)c, DamidaLoggingTranseformer.this.log.getLgNewExprCode(c));
            }
        }
    }
}

