/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.flexible_log;

import amida.agent.flexible_log.DamidaFlexiblePrinter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javassist.NotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DamidaFlexibleBinaryPrinter
extends DamidaFlexiblePrinter<byte[]> {
    protected BufferedOutputStream out;

    public void setBufferedOutputStream(BufferedOutputStream out) {
        this.out = out;
    }

    public BufferedOutputStream getBufferedOutputStream() {
        return this.out;
    }

    public DamidaFlexibleBinaryPrinter(boolean gzip) {
        super(gzip);
    }

    @Override
    public DamidaFlexiblePrinter<byte[]> clone() {
        return new DamidaFlexibleBinaryPrinter(this.gzip);
    }

    public String getExp() {
        if (this.gzip) {
            return "dam.zip";
        }
        return "dam";
    }

    @Override
    public boolean isOpenOutputStream() {
        return this.out != null;
    }

    @Override
    public void copyOutputStream(DamidaFlexiblePrinter<byte[]> from) {
        this.out = ((DamidaFlexibleBinaryPrinter)from).out;
    }

    @Override
    public void openOutputStream(String log_dir, String log_name) throws NotFoundException, IOException {
        FileOutputStream os = null;
        os = log_name == null ? new FileOutputStream(String.valueOf(log_dir) + "/" + this.getLogThread().getId() + "_" + this.getLogThread().getName() + "." + this.getExp()) : new FileOutputStream(String.valueOf(log_dir) + "/" + log_name + "." + this.getExp());
        this.out = this.gzip ? new BufferedOutputStream(new GZIPOutputStream(os)) : new BufferedOutputStream(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutputStream() throws IOException {
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOutputStream() throws IOException {
        if (this.out != null) {
            BufferedOutputStream bufferedOutputStream = this.out;
            synchronized (bufferedOutputStream) {
                this.out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutputStream(byte[] log) throws IOException {
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.out.write(log);
        }
    }

    @Override
    public void parse(Node n) {
        super.parse(n);
    }

    @Override
    public Node create(Document doc) {
        Element n = (Element)super.create(doc);
        n.setAttribute("type", this.gzip ? "zip" : "txt");
        return n;
    }
}

