/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.flexible_log;

import amida.agent.flexible_log.DamidaFlexiblePrinter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import javassist.NotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DamidaFlexibleTextPrinter
extends DamidaFlexiblePrinter<String> {
    protected BufferedWriter out;

    public void setBufferdWriter(BufferedWriter out) {
        this.out = out;
    }

    public BufferedWriter getBufferdWriter() {
        return this.out;
    }

    public DamidaFlexibleTextPrinter(boolean gzip) {
        super(gzip);
    }

    @Override
    public DamidaFlexiblePrinter<String> clone() {
        return new DamidaFlexibleTextPrinter(this.gzip);
    }

    public String getExp() {
        if (this.gzip) {
            return "log.zip";
        }
        return "log";
    }

    @Override
    public boolean isOpenOutputStream() {
        return this.out != null;
    }

    @Override
    public void copyOutputStream(DamidaFlexiblePrinter<String> from) {
        this.out = ((DamidaFlexibleTextPrinter)from).out;
    }

    @Override
    public void openOutputStream(String log_dir, String log_name) throws NotFoundException, IOException {
        FileOutputStream os = null;
        os = log_name == null ? new FileOutputStream(String.valueOf(log_dir) + "/" + this.getLogThread().getId() + "_" + this.getLogThread().getName() + "." + this.getExp()) : new FileOutputStream(String.valueOf(log_dir) + "/" + log_name + "." + this.getExp());
        this.out = this.gzip ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(os))) : new BufferedWriter(new OutputStreamWriter(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutputStream() throws IOException {
        BufferedWriter bufferedWriter = this.out;
        synchronized (bufferedWriter) {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOutputStream() throws IOException {
        if (this.out != null) {
            BufferedWriter bufferedWriter = this.out;
            synchronized (bufferedWriter) {
                this.out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutputStream(String log) throws IOException {
        BufferedWriter bufferedWriter = this.out;
        synchronized (bufferedWriter) {
            this.out.write(log);
            this.out.newLine();
        }
    }

    @Override
    public void parse(Node n) {
        super.parse(n);
    }

    @Override
    public Node create(Document doc) {
        Element n = (Element)super.create(doc);
        n.setAttribute("type", this.gzip ? "zip" : "txt");
        return n;
    }
}

