/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.tranceformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.expr.ExprEditor;

public abstract class DamidaTranseformer
implements ClassFileTransformer {
    protected abstract boolean isTfClass(String var1);

    protected abstract boolean isTfConstructor(CtConstructor var1);

    protected abstract boolean isTfMethod(CtMethod var1);

    protected abstract String[] getConstructorInsertCode(CtConstructor var1);

    protected abstract String[] getMethodInsertCode(CtMethod var1);

    protected abstract ExprEditor getExprEditor();

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        CtClass cls;
        String class_name;
        block9: {
            class_name = className.replaceAll("/|\\$", ".");
            if (!this.isTfClass(class_name)) {
                System.out.println("C : " + class_name + " is Canceld.");
                return null;
            }
            ClassPool pool = ClassPool.getDefault();
            cls = pool.makeClass((InputStream)new ByteArrayInputStream(classfileBuffer));
            if (!cls.isInterface()) break block9;
            return null;
        }
        try {
            CtMethod[] meths = cls.getDeclaredMethods();
            int i = 0;
            while (i < meths.length) {
                if (this.isTfMethod(meths[i])) {
                    this.tfMethod(meths[i]);
                }
                ++i;
            }
            CtConstructor[] conss = cls.getDeclaredConstructors();
            int i2 = 0;
            while (i2 < conss.length) {
                if (this.isTfConstructor(conss[i2])) {
                    this.tfConstructor(conss[i2]);
                }
                ++i2;
            }
            System.out.println("T : " + class_name + " is Transeformed.");
            return cls.toBytecode();
        }
        catch (CannotCompileException e) {
            System.err.println("! : " + className + " can't be compiled.");
        }
        catch (IOException e) {
            System.err.println("! : " + className + " can't be compiled.");
        }
        return null;
    }

    protected void tfConstructor(CtConstructor cons) {
        if (Modifier.isAbstract((int)cons.getModifiers())) {
            return;
        }
        try {
            cons.instrument(this.getExprEditor());
            String[] codes = this.getConstructorInsertCode(cons);
            if (codes != null) {
                cons.insertBefore(codes[0]);
                cons.insertBeforeBody(codes[1]);
                cons.insertAfter(codes[2]);
            }
        }
        catch (CannotCompileException e) {
            System.err.println("! : " + cons.getLongName() + " can't be compiled.");
            System.err.println("  : " + e.getReason());
        }
        catch (Exception e) {
            System.err.println("? : " + cons.getLongName() + " can't be compiled.");
            e.printStackTrace();
        }
    }

    protected void tfMethod(CtMethod meth) {
        if (Modifier.isAbstract((int)meth.getModifiers())) {
            return;
        }
        try {
            meth.instrument(this.getExprEditor());
            String[] codes = this.getMethodInsertCode(meth);
            if (codes != null) {
                meth.insertBefore(codes[0]);
                meth.insertAfter(codes[1]);
            }
        }
        catch (CannotCompileException e) {
            System.err.println("! : " + meth.getLongName() + " can't be compiled.");
            System.err.println("  : " + e.getReason());
        }
        catch (Exception e) {
            System.err.println("? : " + meth.getLongName() + " can't be compiled.");
            e.printStackTrace();
        }
    }
}

