/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteIntIterator;
import gnu.trove.TByteIntProcedure;
import gnu.trove.TByteProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;

public class TByteIntHashMap
extends TByteHash
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected transient int[] _values;

    public TByteIntHashMap() {
    }

    public TByteIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteIntHashMap(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteIntHashMap(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteIntHashMap(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TByteIntHashMap m = (TByteIntHashMap)super.clone();
        m._values = (int[])this._values.clone();
        return m;
    }

    public TByteIntIterator iterator() {
        return new TByteIntIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    public int put(byte key, int value) {
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        byte[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public int get(byte key) {
        int index = this.index(key);
        return index < 0 ? 0 : this._values[index];
    }

    public void clear() {
        super.clear();
        byte[] keys = this._set;
        int[] vals = this._values;
        byte[] states = this._states;
        Arrays.fill(this._set, 0, this._set.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, 0);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
    }

    public int remove(byte key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteIntHashMap)) {
            return false;
        }
        TByteIntHashMap that = (TByteIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public byte[] keys() {
        byte[] keys = new byte[this.size()];
        byte[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public byte[] keys(byte[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (byte[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        byte[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == 0 || k[i] == 2) continue;
            a[j++] = k[i];
        }
        return a;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(byte key) {
        return this.contains(key);
    }

    public boolean forEachKey(TByteProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TByteIntProcedure procedure) {
        byte[] states = this._states;
        byte[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TByteIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        byte[] keys = this._set;
        int[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(byte key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(byte key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    public int adjustOrPutValue(byte key, int adjust_amount, int put_amount) {
        boolean isNewMapping;
        int newValue;
        int index = this.insertionIndex(key);
        if (index < 0) {
            int n = index = -index - 1;
            int n2 = this._values[n] + adjust_amount;
            this._values[n] = n2;
            newValue = n2;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return newValue;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte key = in.readByte();
            int val = in.readInt();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TByteIntProcedure {
        private final TByteIntHashMap _otherMap;

        EqProcedure(TByteIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(byte key, int value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TByteIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key, int value) {
            this.h += TByteIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

