/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTreeGroup;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.calltree.TopRecursiveBlockNode;
import amida.logloader.MethodCallEntry;
import amida.staticdata.ClassData;
import amida.staticdata.MethodData;
import amida.utility.DataChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class CallTree {
    private NodeList topNodeList = new NodeList(null, this);
    private List<DataChangeListener> dataChangeListeners = new LinkedList<DataChangeListener>();
    private final CallTreeGroup group;
    private String name = "";
    private Stack<CallNode> callStack = new Stack();
    private int methodCallNum = 0;
    int tmp = 0;
    private Map<CallNode, MethodCallEntry> returnToMap = new HashMap<CallNode, MethodCallEntry>();
    private MethodCallEntry theLastReturnTo;

    protected CallTree(CallTreeGroup groupe) {
        this.group = groupe;
    }

    public CallNode methodCall(MethodData method, int id) {
        CallNode newNode = new CallNode(this, method, id, this.getGroup().getNextCallIndex());
        CallNode current = this.getCurrentCallNode();
        if (current != null) {
            current.addChild(newNode);
        } else {
            this.getTopNodeList().add(newNode);
        }
        this.getCurrentCallStack().push(newNode);
        ++this.tmp;
        ++this.methodCallNum;
        return newNode;
    }

    public CallNode methodCall(MethodData method, int id, int methodCallCount) {
        CallNode newNode = new CallNode(this, method, id, methodCallCount);
        CallNode current = this.getCurrentCallNode();
        if (current != null) {
            current.addChild(newNode);
        } else {
            this.getTopNodeList().add(newNode);
        }
        this.getCurrentCallStack().push(newNode);
        ++this.tmp;
        ++this.methodCallNum;
        return newNode;
    }

    public void pushNewCaller() {
        CallNode newNode = new CallNode(this, this.theLastReturnTo.getMethod(), this.theLastReturnTo.getObjectId(), this.theLastReturnTo.getMethodCallCount());
        ListIterator<Node> it = this.getTopNodeList().listIterator();
        while (it.hasNext()) {
            CallNode n = (CallNode)it.next();
            MethodCallEntry returnTo = this.returnToMap.get(n);
            if (!returnTo.getMethod().equals(this.theLastReturnTo.getMethod()) || returnTo.getObjectId() != this.theLastReturnTo.getObjectId()) continue;
            it.remove();
            newNode.addChild(n);
        }
        this.getTopNodeList().add(newNode);
        this.getCurrentCallStack().push(newNode);
        ++this.tmp;
        ++this.methodCallNum;
    }

    public CallNode methodExit(MethodCallEntry returnTo) {
        CallNode current;
        if (this.callStack.isEmpty()) {
            this.pushNewCaller();
        }
        if ((current = this.getCurrentCallNode()) != null) {
            current.setExitMode(1);
            if (this.getCurrentCallStack().size() == 1) {
                this.returnToMap.put(current, returnTo);
            }
        }
        --this.tmp;
        this.theLastReturnTo = returnTo;
        return this.getCurrentCallStack().pop();
    }

    public CallNode methodExitWithException(MethodCallEntry returnTo, ClassData exception) {
        CallNode current;
        if (this.callStack.isEmpty()) {
            this.pushNewCaller();
        }
        if ((current = this.getCurrentCallNode()) != null) {
            current.setException(exception);
            current.setExitMode(2);
            if (this.getCurrentCallStack().size() == 1) {
                this.returnToMap.put(current, returnTo);
            }
        }
        --this.tmp;
        this.theLastReturnTo = returnTo;
        return this.getCurrentCallStack().pop();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    public void fireDataChange() {
        for (DataChangeListener listener : this.dataChangeListeners) {
            listener.dataChanged();
        }
    }

    public NodeList getTopNodeList() {
        return this.topNodeList;
    }

    public int getMethodCallNum() {
        return this.methodCallNum;
    }

    public CallNode getCurrentCallNode() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.peek();
    }

    public void clearCompressedInformations() {
        NodeList topNodeList = this.getTopNodeList();
        this.clearCompressedInformations_i(topNodeList);
        this.fireDataChange();
    }

    public void clearCompressedInfromations(NodeList nodes) {
        this.clearCompressedInformations_i(nodes);
        this.fireDataChange();
    }

    private void clearCompressedInformations_i(NodeList nodes) {
        CallTreeIterator it = nodes.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node instanceof TopRecursiveBlockNode) {
                CallNode resetNode = ((TopRecursiveBlockNode)node).getHiddenChild();
                it.set(resetNode);
                this.clearCompressedInformations_i(resetNode.getChildren());
                continue;
            }
            if (node instanceof LoopNode) {
                NodeList resetList = ((LoopNode)node).getHiddenChildren();
                CallTreeIterator it2 = resetList.nodeIterator();
                if (it2.hasNext()) {
                    Node first = it2.next();
                    it.set(first);
                }
                while (it2.hasNext()) {
                    it.add(it2.next());
                }
                this.clearCompressedInformations_i(resetList);
                continue;
            }
            this.clearCompressedInformations_i(node.getChildren());
        }
    }

    public Stack<CallNode> getCurrentCallStack() {
        return this.callStack;
    }

    public CallTreeGroup getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

