/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CallTreeManager {
    public static boolean dontTreateClinits = true;
    public static boolean substituteId = true;
    private static CallTreeManager singleton = new CallTreeManager();
    private HashMap<Object, CallTreeGroup> groupMap = new HashMap();
    private List<CallTreeGroup> groupeList = new ArrayList<CallTreeGroup>();
    private List<CallTree> callTreeList = new ArrayList<CallTree>();
    private Map<Integer, CallTree> callTreeMap = new HashMap<Integer, CallTree>();

    private CallTreeManager() {
    }

    public static CallTreeManager getInstance() {
        return singleton;
    }

    public synchronized CallTreeGroup makeCallTreeGroup() {
        CallTreeGroup groupe = new CallTreeGroup();
        this.groupeList.add(groupe);
        return groupe;
    }

    public synchronized CallTreeGroup makeCallTreeGroup(Object key) {
        CallTreeGroup group = new CallTreeGroup();
        this.groupeList.add(group);
        this.groupMap.put(key, group);
        return group;
    }

    public synchronized CallTree makeCallTree() {
        CallTree tree = this.makeCallTreeGroup().makeCallTree();
        this.callTreeList.add(tree);
        return tree;
    }

    public synchronized CallTree makeCallTree(Integer key) {
        CallTree tree = this.makeCallTree();
        this.callTreeMap.put(key, tree);
        return tree;
    }

    public synchronized CallTree makeCallTree(CallTreeGroup groupe) {
        CallTree tree = groupe.makeCallTree();
        this.callTreeList.add(tree);
        return tree;
    }

    public synchronized CallTree makeCallTree(CallTreeGroup groupe, Integer key) {
        CallTree tree = groupe.makeCallTree(key);
        this.callTreeList.add(tree);
        this.callTreeMap.put(key, tree);
        return tree;
    }

    public CallTreeGroup getCallTreeGroupe(int index) {
        return this.groupeList.get(index);
    }

    public CallTreeGroup getCallTreeGroupe(Object key) {
        return this.groupMap.get(key);
    }

    public CallTree getCallTree(CallTreeGroup groupe, int index) {
        return groupe.getCallTree(index);
    }

    public CallTree getCallTree(CallTreeGroup groupe, Object key) {
        return groupe.getCallTree(key);
    }

    public CallTree getCallTree(int index) {
        return this.callTreeList.get(index);
    }

    public CallTree getCallTree(Object key) {
        return this.callTreeMap.get(key);
    }

    public synchronized void removeCallTree(CallTreeGroup groupe, int index) {
        CallTree tree = groupe.getCallTree(index);
        this.removeCallTree(tree);
    }

    public synchronized void removeCallTree(CallTreeGroup groupe, Object key) {
        CallTree tree = groupe.getCallTree(key);
        this.removeCallTree(tree);
    }

    public synchronized void removeCallTree(CallTree tree) {
        if (tree == null) {
            return;
        }
        tree.getGroup().removeCallTree(tree);
        this.callTreeList.remove(tree);
        Iterator<Map.Entry<Integer, CallTree>> it = this.callTreeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, CallTree> entry = it.next();
            if (entry.getValue() != tree) continue;
            it.remove();
        }
    }

    public synchronized void removeCallTree(int index) {
        this.removeCallTree(this.callTreeList.get(index));
    }

    public synchronized void removeCallTree(Object key) {
        this.removeCallTree(this.callTreeMap.get(key));
    }

    public synchronized void removeCallTreeGroupe(int index) {
        CallTreeGroup groupe = this.groupeList.remove(index);
        int i = 0;
        while (i < groupe.getCallTreeNum()) {
            this.removeCallTree(groupe.getCallTree(i));
            ++i;
        }
        this.removeAllEntry(this.groupMap, groupe);
    }

    public synchronized void removeCallTreeGroupe(Object key) {
        CallTreeGroup groupe = this.groupMap.remove(key);
        int i = 0;
        while (i < groupe.getCallTreeNum()) {
            this.removeCallTree(groupe.getCallTree(i));
            ++i;
        }
        this.removeAllEntry(this.groupMap, groupe);
    }

    private synchronized void removeAllEntry(Map<Object, CallTreeGroup> map, CallTreeGroup o) {
        Iterator<Map.Entry<Object, CallTreeGroup>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, CallTreeGroup> entry = it.next();
            if (entry.getValue() != o) continue;
            it.remove();
        }
    }

    public synchronized void deleteAllGroupe() {
        this.groupeList.clear();
        this.groupMap.clear();
        this.callTreeList.clear();
        this.callTreeMap.clear();
    }

    public synchronized void removeAllCallTree() {
        this.deleteAllGroupe();
    }

    public synchronized int getCallTreeNum() {
        return this.callTreeList.size();
    }
}

