/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.filter;

import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.filter.IMethodFilter;
import amida.utility.StringPatternComparator;
import java.util.Set;
import java.util.TreeSet;

public class MethodFilter
implements IMethodFilter {
    private int type = 1;
    private String methodName;
    private String callerPackage;
    private String callerClass;
    private Set<Integer> callerId = new TreeSet<Integer>();
    private boolean callerContainsOtherId = false;
    private String calleePackage = null;
    private String calleeClass = null;
    private Set<Integer> calleeId = new TreeSet<Integer>();
    private boolean calleeContainsOtherId = false;
    private boolean samePackage = false;
    private boolean sameClass = false;
    private boolean sameId = false;

    public MethodFilter(int type, String methodName, String callerPackage, String callerClass, Set<Integer> callerId, boolean collerContainsOtherId, String calleePackage, String calleeClass, Set<Integer> calleeId, boolean colleeContainsOtherId, boolean samePackage, boolean sameClass, boolean sameId) {
        if (type == 0) {
            this.type = 1;
        } else if (type == 1) {
            this.type = 2;
        }
        this.methodName = methodName;
        this.callerPackage = callerPackage;
        this.callerClass = callerClass;
        this.callerId.addAll(callerId);
        this.callerContainsOtherId = collerContainsOtherId;
        this.calleePackage = calleePackage;
        this.calleeClass = calleeClass;
        if (calleeId != null) {
            this.calleeId.addAll(calleeId);
        }
        this.calleeContainsOtherId = colleeContainsOtherId;
        this.samePackage = samePackage;
        this.sameClass = sameClass;
        this.sameId = sameId;
    }

    @Override
    public int filter(Sequence sequence) {
        SequenceObject caller = sequence.getStart();
        SequenceObject callee = sequence.getEnd();
        if (this.methodName != null && !StringPatternComparator.compareStringPattern(this.methodName, sequence.getNode().getMethodName())) {
            return 0;
        }
        if (caller != null) {
            if (this.callerPackage != null && !StringPatternComparator.compareStringPattern(this.callerPackage, caller.getNameSpace())) {
                return 0;
            }
            if (this.callerClass != null && !StringPatternComparator.compareStringPattern(this.callerClass, caller.getClassName())) {
                return 0;
            }
            if (this.callerContainsOtherId ? this.callerId != null && !this.callerId.isEmpty() && !caller.getIds().containsAll(this.callerId) : this.callerId == null || this.callerId.isEmpty() || !caller.getIds().equals(this.callerId)) {
                return 0;
            }
            if (this.samePackage ? !caller.getNameSpace().equals(callee.getNameSpace()) : this.calleePackage != null && !StringPatternComparator.compareStringPattern(this.calleePackage, callee.getNameSpace())) {
                return 0;
            }
            if (this.sameClass ? !caller.getClassName().equals(callee.getClassName()) : this.calleeClass != null && !StringPatternComparator.compareStringPattern(this.calleeClass, callee.getClassName())) {
                return 0;
            }
            if (this.sameId ? !caller.getIds().equals(callee.getIds()) : (this.calleeContainsOtherId ? this.calleeId != null && !this.calleeId.isEmpty() && !callee.getIds().containsAll(this.calleeId) : this.calleeId == null || this.calleeId.isEmpty() || !callee.getIds().equals(this.calleeId))) {
                return 0;
            }
        } else {
            if (this.callerPackage != null && !this.callerPackage.equals("*")) {
                return 0;
            }
            if (this.callerClass != null && !this.callerClass.equals("*")) {
                return 0;
            }
            if (!this.callerContainsOtherId) {
                return 0;
            }
            if (this.callerId != null && !this.callerId.isEmpty()) {
                return 0;
            }
            if (this.samePackage || this.sameClass || this.sameId) {
                return 0;
            }
            if (this.calleePackage != null && !StringPatternComparator.compareStringPattern(this.calleePackage, callee.getNameSpace())) {
                return 0;
            }
            if (this.calleeClass != null && !StringPatternComparator.compareStringPattern(this.calleeClass, callee.getClassName())) {
                return 0;
            }
            if (this.calleeContainsOtherId ? this.calleeId != null && !this.calleeId.isEmpty() && !callee.getIds().containsAll(this.calleeId) : this.calleeId == null || this.calleeId.isEmpty() || !callee.getIds().equals(this.calleeId)) {
                return 0;
            }
        }
        return this.type;
    }
}

