/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.gui;

import amida.diagram.sequencediagram.gui.SequenceDiagramPanel;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.gui.MainFrame;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = 297609548457089355L;
    private final JFrame frame;
    private final JTextField keyField;
    private final JRadioButton downButton;
    private final JRadioButton upButton;
    private final JRadioButton methodButton;
    private final JRadioButton objectButton;

    public SearchDialog() {
        super((Frame)MainFrame.getInstance(), "Search");
        this.setResizable(false);
        this.frame = MainFrame.getInstance();
        this.setSize(new Dimension(400, 200));
        this.setDefaultCloseOperation(1);
        Container cp = this.getContentPane();
        JPanel keyPanel = new JPanel();
        keyPanel.setBorder(BorderFactory.createTitledBorder("Find"));
        this.keyField = new JTextField(20);
        keyPanel.add(this.keyField);
        JPanel targetPanel = new JPanel();
        targetPanel.setBorder(BorderFactory.createTitledBorder("Target"));
        targetPanel.setLayout(new FlowLayout(0));
        this.methodButton = new JRadioButton("Method", true);
        this.objectButton = new JRadioButton("Object");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.methodButton);
        group2.add(this.objectButton);
        targetPanel.add(this.methodButton);
        targetPanel.add(this.objectButton);
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        directionPanel.setLayout(new FlowLayout(0));
        this.downButton = new JRadioButton("down", true);
        this.upButton = new JRadioButton("up");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.downButton);
        group1.add(this.upButton);
        directionPanel.add(this.downButton);
        directionPanel.add(this.upButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton serchButton = new JButton("Search");
        final JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(serchButton);
        buttonPanel.add(cancelButton);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        cons.anchor = 18;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        gb.setConstraints(keyPanel, cons);
        cp.add(keyPanel);
        gb.setConstraints(targetPanel, cons);
        cp.add(targetPanel);
        gb.setConstraints(directionPanel, cons);
        cp.add(directionPanel);
        gb.setConstraints(buttonPanel, cons);
        cp.add(buttonPanel);
        this.pack();
        InputMap input = new InputMap();
        input.put(KeyStroke.getKeyStroke(10, 0), "enter");
        ActionMap action = new ActionMap();
        action.put("enter", new AbstractAction(){
            private static final long serialVersionUID = -7697445754912627125L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!cancelButton.isFocusOwner()) {
                    SearchDialog.this.search();
                } else {
                    SearchDialog.this.setVisible(false);
                }
            }
        });
        keyPanel.setInputMap(1, input);
        keyPanel.setActionMap(action);
        serchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.search();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.setVisible(false);
                MainFrame.getInstance().requestFocusInWindow();
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.frame);
        }
        super.setVisible(b);
    }

    public void search() {
        if (!this.keyField.getText().equals("")) {
            SequenceDiagramPanel diagram = SequenceDiagramTabbedPane.getInstance().getSelectedDiagram();
            if (diagram == null) {
                return;
            }
            int target = this.methodButton.isSelected() ? 0 : 1;
            int direction = this.downButton.isSelected() ? 0 : 1;
            diagram.search(this.keyField.getText(), target, direction);
        }
        this.setVisible(false);
    }
}

