/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.gui;

import amida.calltree.LoopNode;
import amida.calltree.MethodMissingLoopNode;
import amida.calltree.ObjectDifferenceLoopNode;
import amida.diagram.sequencediagram.Called;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceBlock;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.gui.DiagramsCanvasAdjuster;
import amida.utility.DataChangeListener;
import amida.utility.SelectionChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SequenceMapCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    private static final long serialVersionUID = 2730153111530597575L;
    protected static final Insets MARGIN = new Insets(5, 5, 5, 5);
    private static final SequenceMapCanvas singleton = new SequenceMapCanvas();
    private int autoScrollDistance = 10;
    private JScrollPane scrollPane;
    private DiagramsCanvasAdjuster adjuster;
    private SequenceDiagramModel model;
    private int xRate = 3;
    private int yRate = 2;

    private SequenceMapCanvas() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                int length;
                int x = event.getX();
                int y = event.getY();
                if (SequenceMapCanvas.this.scrollPane == null) {
                    return;
                }
                Rectangle rect = SequenceMapCanvas.this.scrollPane.getViewport().getViewRect();
                if (rect.x + SequenceMapCanvas.this.autoScrollDistance > x) {
                    length = x - (rect.x + SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().getValue() + length);
                } else if (rect.x + rect.width - SequenceMapCanvas.this.autoScrollDistance < x) {
                    length = x - (rect.x + rect.width - SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getHorizontalScrollBar().getValue() + length);
                }
                if (rect.y + SequenceMapCanvas.this.autoScrollDistance > y) {
                    length = y - (rect.y + SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().getValue() + length);
                } else if (rect.y + rect.height - SequenceMapCanvas.this.autoScrollDistance < y) {
                    length = y - (rect.y + rect.height - SequenceMapCanvas.this.autoScrollDistance);
                    SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().setValue(SequenceMapCanvas.this.scrollPane.getVerticalScrollBar().getValue() + length);
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
    }

    public static SequenceMapCanvas getInstance() {
        return singleton;
    }

    public void setScrollPane(JScrollPane scroll) {
        this.scrollPane = scroll;
    }

    public SequenceMapCanvas(SequenceDiagramModel model) {
        this.setBackground(Color.white);
        this.setModel(model);
    }

    public void setSequenceDiagramsAdjuster(DiagramsCanvasAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    public SequenceDiagramModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    public void setModel(SequenceDiagramModel model) {
        SequenceDiagramModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeDataChangeListener(this);
        }
        this.model = model;
        if (model != null) {
            model.addDataChangeListener(this);
            model.getSelectionModel().addSelectionListener(this);
        }
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        SequenceDiagramModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceDiagramModel sequenceDiagramModel = model;
        synchronized (sequenceDiagramModel) {
            int i = 0;
            while (i < model.getBlockNum()) {
                SequenceBlock block = model.getBlock(i);
                int start = block.getStartIndex();
                int end = block.getEndIndex();
                int xMin = 0;
                int xMax = 0;
                Iterator<Sequence> it2 = block.getSequenceList().iterator();
                if (it2.hasNext()) {
                    Sequence sequence = it2.next();
                    xMin = sequence.getStartIndex();
                    xMax = sequence.getEndIndex();
                    while (it2.hasNext()) {
                        sequence = it2.next();
                        if (sequence.getType() == 2 || !it2.hasNext()) continue;
                        int tmp = sequence.getEndIndex();
                        if (sequence.getType() == 3) {
                            tmp = sequence.getStartIndex() + 1;
                        }
                        if (tmp < xMin) {
                            xMin = tmp;
                        }
                        if (tmp <= xMax) continue;
                        xMax = tmp;
                    }
                    g.drawRect(SequenceMapCanvas.MARGIN.left + xMin * this.xRate, SequenceMapCanvas.MARGIN.top + start * this.yRate, (xMax - xMin) * this.xRate, (end - start + 1) * this.yRate);
                }
                ++i;
            }
            int startX = 0;
            int endX = model.getObjectNum();
            int startY = 0;
            int endY = model.getSequenceNum();
            if (this.scrollPane != null) {
                Rectangle myViewRange = this.scrollPane.getViewport().getViewRect();
                startX = (int)(myViewRange.getX() - (double)SequenceMapCanvas.MARGIN.left) / this.xRate;
                endX = 1 + (int)(myViewRange.getX() + myViewRange.getWidth() - (double)SequenceMapCanvas.MARGIN.left) / this.xRate;
                startY = (int)(myViewRange.getY() - (double)SequenceMapCanvas.MARGIN.top) / this.yRate;
                endY = 1 + (int)(myViewRange.getY() + myViewRange.getHeight() - (double)SequenceMapCanvas.MARGIN.top) / this.yRate;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > model.getObjectNum()) {
                    endX = model.getObjectNum();
                }
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > model.getSequenceNum()) {
                    endY = model.getSequenceNum();
                }
            }
            int i2 = startY;
            while (i2 < endY) {
                int end;
                int start;
                boolean isSelected;
                Sequence sequence = model.getSequence(i2);
                boolean bl = isSelected = this.sequenceIsSelected(i2) || this.sequenceIsSelected(sequence.getPareSequence().getIndex());
                if (sequence.getType() != 2 && (start = sequence.getStartIndex()) != (end = sequence.getEndIndex())) {
                    Color backupColor = g.getColor();
                    if (isSelected) {
                        g.setColor(Color.BLUE);
                    }
                    g.drawLine(SequenceMapCanvas.MARGIN.left + start * this.xRate, SequenceMapCanvas.MARGIN.top + (i2 + 1) * this.yRate, SequenceMapCanvas.MARGIN.left + end * this.xRate, SequenceMapCanvas.MARGIN.top + (i2 + 1) * this.yRate);
                    g.setColor(backupColor);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < model.getLoopNum()) {
                SequenceLoop loop = model.getLoop(i2);
                int start = loop.getStart();
                int end = loop.getEnd();
                SequenceObject object = loop.getParentObject();
                int objectIndex = object != null ? object.getIndex() : 0;
                LoopNode node = loop.getNode();
                if (node instanceof ObjectDifferenceLoopNode) {
                    g.setColor(Color.BLUE);
                } else if (node instanceof MethodMissingLoopNode) {
                    g.setColor(Color.RED);
                }
                g.drawLine(SequenceMapCanvas.MARGIN.left + objectIndex * this.xRate + loop.getDepth() - 1, SequenceMapCanvas.MARGIN.top + start * this.yRate, SequenceMapCanvas.MARGIN.left + objectIndex * this.xRate + loop.getDepth() - 1, SequenceMapCanvas.MARGIN.top + end * this.yRate);
                ++i2;
            }
            if (this.adjuster != null) {
                Color backupColor = g.getColor();
                g.setColor(Color.RED);
                Rectangle viewRange = this.adjuster.translateDiagramCoordinatesToMap(this.adjuster.getDiagramCanvasViewRange());
                g.drawRect(SequenceMapCanvas.MARGIN.left + viewRange.x, SequenceMapCanvas.MARGIN.top + viewRange.y, viewRange.width, viewRange.height);
                Rectangle myViewRange = this.scrollPane.getViewport().getViewRect();
                if (myViewRange.getX() > (double)(SequenceMapCanvas.MARGIN.left + viewRange.x) || myViewRange.getX() + myViewRange.getWidth() < (double)(SequenceMapCanvas.MARGIN.left + viewRange.x + viewRange.width) || myViewRange.getY() > (double)(SequenceMapCanvas.MARGIN.top + viewRange.y) || myViewRange.getY() + myViewRange.getHeight() < (double)(SequenceMapCanvas.MARGIN.top + viewRange.y + viewRange.height)) {
                    g.setColor(backupColor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceDiagramModel model = this.getModel();
        if (model != null) {
            SequenceDiagramModel sequenceDiagramModel = model;
            synchronized (sequenceDiagramModel) {
                Dimension size = new Dimension(this.xRate * model.getObjectNum() + SequenceMapCanvas.MARGIN.left + SequenceMapCanvas.MARGIN.right, this.yRate * model.getSequenceNum() + SequenceMapCanvas.MARGIN.top + SequenceMapCanvas.MARGIN.bottom);
                this.setPreferredSize(size);
            }
        } else {
            this.setPreferredSize(new Dimension(1, 1));
        }
        this.revalidate();
        this.repaint();
    }

    public int getXRate() {
        return this.xRate;
    }

    public void setXRate(int x) {
        this.xRate = x;
    }

    public int getYRate() {
        return this.yRate;
    }

    public void setYRate(int y) {
        this.yRate = y;
    }

    @Override
    public void dataChanged() {
        this.resize();
        this.revalidate();
    }

    @Override
    public void selectionChanged() {
        this.repaint();
    }

    public DiagramsCanvasAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void autoScroll() {
        if (this.scrollPane == null || this.adjuster == null) {
            return;
        }
        Rectangle viewRange = this.adjuster.translateDiagramCoordinatesToMap(this.adjuster.getDiagramCanvasViewRange());
        int centerX = (int)(viewRange.getX() + viewRange.getWidth() / 2.0);
        int centerY = (int)(viewRange.getY() + viewRange.getHeight() / 2.0);
        Rectangle viewPortRectangle = this.scrollPane.getViewport().getViewRect();
        if (!viewPortRectangle.contains(centerX, centerY)) {
            int viewWidth = (int)viewPortRectangle.getWidth();
            int viewHeight = (int)viewPortRectangle.getHeight();
            this.scrollPane.getHorizontalScrollBar().setValue(centerX - viewWidth / 2);
            this.scrollPane.getVerticalScrollBar().setValue(centerY - viewHeight / 2);
        }
    }

    private boolean sequenceIsSelected(int index) {
        Set<Integer> selectedIndexes = this.getModel().getSelectionModel().getSelectedSequenceIndex();
        for (int selectedIndex : selectedIndexes) {
            int pareIndex = this.getModel().getSequence(selectedIndex).getPareSequence().getIndex();
            if (index < selectedIndex || index > pareIndex) continue;
            return true;
        }
        Set<Called> calles = this.getModel().getSelectionModel().getSelectedCalled();
        for (Called called : calles) {
            if (called.getStart() > index || called.getEnd() < index) continue;
            return true;
        }
        Set<Integer> objects = this.getModel().getSelectionModel().getSelectedObjectIndex();
        Iterator<Integer> it = objects.iterator();
        while (it.hasNext()) {
            SequenceObject object = this.getModel().getObject(it.next());
            Sequence sequence = this.getModel().getSequence(index);
            if (sequence.getStart() != object && sequence.getEnd() != object) continue;
            return true;
        }
        Set<SequenceLoop> loops = this.getModel().getSelectionModel().getSelectedLoops();
        for (SequenceLoop loop : loops) {
            if (loop.getStart() > index || loop.getEnd() < index) continue;
            return true;
        }
        return false;
    }
}

