/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.gui;

import amida.diagram.sequencediagram.SequenceDiagramDrawer;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.filter.gui.FilterDialog;
import amida.diagram.sequencediagram.filter.gui.ObjectFilter;
import amida.diagram.sequencediagram.gui.DiagramsCanvasAdjuster;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.utility.DataChangeListener;
import amida.utility.SelectionChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SequenceObjectCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    private static final long serialVersionUID = 7423351331601208648L;
    public static final int DEFAULT_HEIGHT = 50;
    private final JPopupMenu popup;
    private DiagramsCanvasAdjuster adjuster;
    private SequenceDiagramModel model;

    public SequenceObjectCanvas() {
        this.setBackground(Color.white);
        this.popup = new JPopupMenu();
        JMenuItem filterMenuItem = new JMenuItem("Filter as...");
        this.popup.add(filterMenuItem);
        filterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<Integer> selectedIndex = SequenceObjectCanvas.this.model.getSelectionModel().getSelectedObjectIndex();
                if (selectedIndex.size() != 1) {
                    return;
                }
                SequenceObject object = SequenceObjectCanvas.this.model.getObject(selectedIndex.iterator().next());
                ObjectFilter filter = new ObjectFilter(SequenceDiagramTabbedPane.getInstance().getTitleAt(SequenceDiagramTabbedPane.getInstance().getSelectedIndex()), 0, object.getNameSpace(), object.getClassName(), object.getIds().toString());
                FilterDialog dialog = FilterDialog.getInstance();
                dialog.setObjectFilterToSetDailog(filter);
                dialog.setSelectedTab(0);
                dialog.setVisibleOfSetDialog(0, true);
                dialog.apply();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SequenceObjectCanvas.this.adjuster == null) {
                    return;
                }
                SequenceDiagramModel model = SequenceObjectCanvas.this.getModel();
                int y = e.getY() - ((SequenceObjectCanvas)SequenceObjectCanvas.this).adjuster.getMargin().top;
                if (y >= 0 && y <= SequenceObjectCanvas.this.adjuster.getObjectHeight()) {
                    int index2;
                    Rectangle viewRange = SequenceObjectCanvas.this.adjuster.getDiagramCanvasViewRange();
                    if (viewRange == null) {
                        return;
                    }
                    int objectsSpace = SequenceObjectCanvas.this.adjuster.getObjectSpace();
                    int yStart = (int)viewRange.getY() / SequenceObjectCanvas.this.adjuster.getSequenceSpace() - 1;
                    int index1 = ((int)viewRange.getX() + e.getX() - ((SequenceObjectCanvas)SequenceObjectCanvas.this).adjuster.getMargin().left) / (SequenceObjectCanvas.this.adjuster.getObjectWidth() + objectsSpace);
                    if (index1 == (index2 = ((int)viewRange.getX() + objectsSpace + e.getX() - ((SequenceObjectCanvas)SequenceObjectCanvas.this).adjuster.getMargin().left) / (SequenceObjectCanvas.this.adjuster.getObjectWidth() + objectsSpace)) && index1 > 0 && model.getObjectNum() >= index1) {
                        SequenceObject selectedObject = model.getObject(index1 - 1);
                        if (selectedObject.isVisible(yStart)) {
                            model.getSelectionModel().clearAllSelection();
                            model.getSelectionModel().setSelectedObject(index1 - 1);
                            if (e.getButton() == 3) {
                                SequenceObjectCanvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    } else {
                        model.getSelectionModel().clearAllSelection();
                    }
                } else {
                    model.getSelectionModel().clearAllSelection();
                }
            }
        });
    }

    public void setSequenceDiagramsAdjuster(DiagramsCanvasAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        SequenceDiagramModel model = this.getModel();
        if (model != null) {
            SequenceDiagramModel sequenceDiagramModel = model;
            synchronized (sequenceDiagramModel) {
                SequenceDiagramDrawer.drawTopObject(model, this.adjuster, g, this.adjuster.getDiagramCanvasViewRange());
            }
        }
    }

    public SequenceDiagramModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    protected void setModel(SequenceDiagramModel model) {
        this.model = model;
        model.addDataChangeListener(this);
        model.getSelectionModel().addSelectionListener(this);
        this.resize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceDiagramModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceDiagramModel sequenceDiagramModel = model;
        synchronized (sequenceDiagramModel) {
            if (this.adjuster == null) {
                return;
            }
            int x = this.adjuster.getDiagramCanvasViewRange().width;
            int y = 50;
            Dimension newSize = new Dimension(x, y);
            this.setPreferredSize(newSize);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void dataChanged() {
        this.resize();
    }

    @Override
    public void selectionChanged() {
        this.repaint();
    }
}

