/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.printer;

import amida.diagram.sequencediagram.SequenceDiagramAdjuster;
import amida.diagram.sequencediagram.SequenceDiagramDrawer;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.gui.SequenceDiagramPanel;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.diagram.sequencediagram.printer.PrintLayoutAdjuster;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class SequenceDiagramPrinter
implements Printable {
    private static final double DEFAULT_RATE = 1.0;
    private final SequenceDiagramModel model;
    private final SequenceDiagramAdjuster adjuster;
    private final int pageNumber;
    private final int horizontalPageNumber;

    private SequenceDiagramPrinter(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, int horizontalPage, int pageNumber) {
        this.model = model;
        this.adjuster = adjuster;
        this.horizontalPageNumber = horizontalPage;
        this.pageNumber = pageNumber;
    }

    public int getNumberOfPages() {
        return this.pageNumber;
    }

    @Override
    public int print(Graphics g, PageFormat format, int page) throws PrinterException {
        if (page < 0 || page >= this.pageNumber) {
            return 1;
        }
        int raw = page / this.horizontalPageNumber;
        int column = page % this.horizontalPageNumber;
        if (raw == 0) {
            Rectangle objectViewRange = new Rectangle((int)((double)column * format.getImageableWidth()), 0, (int)format.getImageableWidth(), (int)format.getImageableHeight());
            Graphics imagableGraphics = g.create((int)format.getImageableX(), (int)format.getImageableY(), (int)format.getImageableWidth(), (int)format.getImageableHeight());
            SequenceDiagramDrawer.drawTopObject(this.model, this.adjuster, imagableGraphics, objectViewRange);
            Rectangle diagramViewRange = new Rectangle((int)((double)column * format.getImageableWidth()), (int)((double)raw * format.getImageableHeight()), (int)format.getImageableWidth(), (int)format.getImageableHeight() - this.adjuster.getObjectHeight());
            Rectangle diagramDrawRange = new Rectangle((int)format.getImageableX(), (int)format.getImageableY() + this.adjuster.getObjectHeight(), (int)format.getImageableWidth(), (int)format.getImageableHeight() - this.adjuster.getObjectHeight());
            SequenceDiagramDrawer.drawDiagram(this.model, this.adjuster, g, diagramViewRange, diagramDrawRange);
        } else {
            Rectangle diagramViewRange = new Rectangle((int)((double)column * format.getImageableWidth()), (int)((double)raw * format.getImageableHeight() - (double)this.adjuster.getObjectHeight()), (int)format.getImageableWidth(), (int)format.getImageableHeight());
            Rectangle diagramDrawRange = new Rectangle((int)format.getImageableX(), (int)format.getImageableY(), (int)format.getImageableWidth(), (int)format.getImageableHeight());
            SequenceDiagramDrawer.drawDiagram(this.model, this.adjuster, g, diagramViewRange, diagramDrawRange);
        }
        return 0;
    }

    public static void printCurrentDiagram() {
        SequenceDiagramPrinter.printCurrentDiagram(1.0);
    }

    public static void printCurrentDiagram(double rate) {
        SequenceDiagramPanel diagram = SequenceDiagramTabbedPane.getInstance().getSelectedDiagram();
        if (diagram == null) {
            return;
        }
        SequenceDiagramModel model = diagram.getModel();
        if (model == null) {
            return;
        }
        SequenceDiagramPrinter.printDiagram(model, rate);
    }

    public static void printDiagram(SequenceDiagramModel model) {
        SequenceDiagramPrinter.printDiagram(model, 1.0);
    }

    public static void printDiagram(SequenceDiagramModel model, double rate) {
        PageFormat defaultPage;
        PrintLayoutAdjuster adjuster = new PrintLayoutAdjuster(rate);
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(defaultPage = job.defaultPage());
        if (format == defaultPage) {
            return;
        }
        Insets margin = adjuster.getMargin();
        int maxX = margin.left + margin.right + model.getObjectNum() * (adjuster.getObjectSpace() + adjuster.getObjectWidth());
        int maxY = margin.top + margin.bottom + adjuster.getObjectHeight() + model.getSequenceNum() * adjuster.getSequenceSpace();
        int horizontalPage = (int)((double)maxX / format.getImageableWidth());
        if ((double)maxX % format.getImageableWidth() != 0.0) {
            ++horizontalPage;
        }
        int verticalPage = (int)((double)maxY / format.getImageableHeight());
        if ((double)maxY % format.getImageableHeight() != 0.0) {
            ++verticalPage;
        }
        int pageNum = horizontalPage * verticalPage;
        SequenceDiagramPrinter printer = new SequenceDiagramPrinter(model, adjuster, horizontalPage, pageNum);
        job.setPrintable(printer, format);
        Book book = new Book();
        book.append(printer, format, pageNum);
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }
}

