/*
 * Decompiled with CFR 0.152.
 */
package amida.gui;

import amida.LanguageType;
import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.filter.gui.FilterDialog;
import amida.diagram.sequencediagram.gui.InformationTabbedPane;
import amida.diagram.sequencediagram.gui.SearchDialog;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.diagram.sequencediagram.gui.SequenceMapCanvas;
import amida.diagram.sequencediagram.printer.SequenceDiagramPrinter;
import amida.gui.VersionDialog;
import amida.logcompactor.LoopCompactorThread;
import amida.logcompactor.RecursiveCallCompactorThread;
import amida.logcompactor.foldrule.MethodMissingLoopRule;
import amida.logcompactor.foldrule.ObjectDifferenceLoopRule;
import amida.logcompactor.foldrule.SimpleLoopRule;
import amida.logcompactor.gui.LogTextAreaFrame;
import amida.logloader.BinaryLogFile;
import amida.logloader.DefaultBinaryLogParser;
import amida.logloader.DefaultLogParser;
import amida.logloader.LogLoader;
import amida.logloader.TextLogFile;
import amida.node.comparator.NodeTreeComparator;
import amida.utility.LineTextFieldPanel;
import amida.utility.MyFileFilter;
import amida.utility.ProgressDialog;
import amida.utility.ProgressListener;
import amida.utility.StringMaker;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -6385601153621180051L;
    private final ProgressDialog progressDialog;
    private final SearchDialog searchDialog = new SearchDialog();
    private final VersionDialog versionDialog = new VersionDialog();
    private final LogTextAreaFrame logWindow = new LogTextAreaFrame();
    private final InformationTabbedPane informationTab = InformationTabbedPane.getInstance();
    private final SequenceDiagramTabbedPane diagramTab = SequenceDiagramTabbedPane.getInstance();
    private final SequenceMapCanvas mapCanvas = SequenceMapCanvas.getInstance();
    private final JFileChooser fileChooser = new JFileChooser(".");
    private final CompressedLogLoadDialog compressedLogLoadDailog = new CompressedLogLoadDialog();
    private double diagramWidthRate = 0.9;
    private double diagramHeigthRate = 0.85;
    private static final MainFrame singleton = new MainFrame();

    private MainFrame() {
        super("Amida");
        InputMap input = new InputMap();
        input.put(KeyStroke.getKeyStroke(70, 2), "search");
        ActionMap action = new ActionMap();
        action.put("search", new AbstractAction(){
            private static final long serialVersionUID = 2965028718207834883L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainFrame.this.searchDialog.setVisible(true);
            }
        });
        this.progressDialog = new ProgressDialog(this);
        this.fileChooser.setFileFilter(new MyFileFilter(new String[]{"log"}));
        this.fileChooser.setFileSelectionMode(2);
        JSplitPane informationSplit = new JSplitPane();
        informationSplit.setOrientation(0);
        informationSplit.setDividerSize(2);
        informationSplit.setResizeWeight(0.9);
        informationSplit.setLeftComponent(this.diagramTab);
        informationSplit.setRightComponent(this.informationTab);
        JScrollPane mapScroll = new JScrollPane(this.mapCanvas);
        this.mapCanvas.setScrollPane(mapScroll);
        JSplitPane mapSplit = new JSplitPane();
        mapSplit.setResizeWeight(0.8);
        mapSplit.setDividerSize(2);
        mapSplit.setLeftComponent(informationSplit);
        mapSplit.setRightComponent(mapScroll);
        mapSplit.setInputMap(1, input);
        mapSplit.setActionMap(action);
        Dimension screenSize = this.getToolkit().getScreenSize();
        screenSize.setSize(screenSize.getWidth() - 15.0, screenSize.getHeight() - 90.0);
        this.diagramTab.setPreferredSize(new Dimension((int)(screenSize.getWidth() * this.diagramWidthRate), (int)(screenSize.getHeight() * this.diagramHeigthRate)));
        this.informationTab.setPreferredSize(new Dimension((int)(screenSize.getWidth() * this.diagramWidthRate), (int)(screenSize.getHeight() * (1.0 - this.diagramHeigthRate))));
        this.mapCanvas.setPreferredSize(new Dimension((int)(screenSize.getWidth() * (1.0 - this.diagramWidthRate)), (int)screenSize.getHeight()));
        informationSplit.resetToPreferredSizes();
        mapSplit.resetToPreferredSizes();
        Container cp = this.getContentPane();
        cp.add(mapSplit);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem saveMenuItem = new JMenuItem("Save log");
        JMenuItem loadMenuItem = new JMenuItem("Load");
        JMenuItem loadCompressedMenuItem = new JMenuItem("Load compressed log");
        JMenuItem printMenuItem = new JMenuItem("Print");
        fileMenu.add(saveMenuItem);
        fileMenu.add(loadMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(printMenuItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenu sortMenu = new JMenu("Sort");
        editMenu.add(sortMenu);
        JMenuItem sortAppearIndex = new JMenuItem("appearance index");
        sortMenu.add(sortAppearIndex);
        JMenuItem sortClassName = new JMenuItem("class name");
        sortMenu.add(sortClassName);
        JMenuItem sortId = new JMenuItem("object id");
        sortMenu.add(sortId);
        menuBar.add(editMenu);
        JMenu conpactionMenu = new JMenu("Compression");
        JMenuItem foldMenuItem = new JMenuItem("Simple loop");
        conpactionMenu.add(foldMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem anotherObjectMenuItem = new JMenuItem("Object difference loop");
        conpactionMenu.add(anotherObjectMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem includeLoopMenuItem = new JMenuItem("Method missing loop");
        conpactionMenu.add(includeLoopMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem recursiveMenuItem = new JMenuItem("Recursive call");
        conpactionMenu.add(recursiveMenuItem);
        editMenu.add(conpactionMenu);
        JMenuItem searchMenuItem = new JMenuItem("Search");
        editMenu.add(searchMenuItem);
        JMenuItem filterMenuItem = new JMenuItem("Filter");
        editMenu.add(filterMenuItem);
        JMenu windowMenu = new JMenu("Window");
        JMenuItem logWindowItem = new JMenuItem("Show a Textual View");
        windowMenu.add(logWindowItem);
        menuBar.add(windowMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem versionMenuItem = new JMenuItem("Version");
        helpMenu.add(versionMenuItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainFrame.this.saveLog();
            }
        });
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.fileChooser.showOpenDialog(MainFrame.this) == 0) {
                    File selectedFile = new File(MainFrame.this.fileChooser.getCurrentDirectory(), MainFrame.this.fileChooser.getSelectedFile().getName());
                    if (selectedFile.isDirectory()) {
                        File[] files = selectedFile.listFiles();
                        LinkedList<File> logFiles = new LinkedList<File>();
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            String extension = file.getName().substring(file.getName().length() - 4);
                            if (extension.equals("log")) {
                                logFiles.add(file);
                            } else {
                                extension.equals("dat");
                            }
                            ++i;
                        }
                    } else {
                        MainFrame.this.loadFile(selectedFile, -1, -1, null);
                    }
                }
            }
        });
        loadCompressedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.compressedLogLoadDailog.setVisible(true);
            }
        });
        printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceDiagramPrinter.printCurrentDiagram(0.2);
            }
        });
        foldMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceDiagramModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new SimpleLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(){

                    @Override
                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.this.progressDialog.setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }
        });
        anotherObjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceDiagramModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new ObjectDifferenceLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(){

                    @Override
                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.this.progressDialog.setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }
        });
        includeLoopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceDiagramModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new MethodMissingLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(){

                    @Override
                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.this.progressDialog.setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }
        });
        recursiveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceDiagramModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                RecursiveCallCompactorThread thread = new RecursiveCallCompactorThread(model.getCallTree());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(){

                    @Override
                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.this.progressDialog.setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }
        });
        logWindowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.logWindow.setVisible(true);
            }
        });
        searchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainFrame.this.searchDialog.setVisible(true);
            }
        });
        filterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.getInstance().setVisible(true);
            }
        });
        versionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainFrame.this.versionDialog.setVisible(true);
            }
        });
    }

    public static MainFrame getInstance() {
        return singleton;
    }

    public void setInprocess(boolean b) {
        if (b) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MainFrame.this.diagramTab.removeAll();
                }
            });
        } else {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
    }

    public void graphvizTest(NodeList list, Collection<String> c) {
        CallTreeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!(node instanceof CallNode) || ((CallNode)node).getCallParent() == null) {
                this.graphvizTest(node.getChildren(), c);
                continue;
            }
            CallNode call = (CallNode)node;
            CallNode parent = call.getCallParent();
            StringBuffer buffer = new StringBuffer();
            buffer.append("\"" + parent.getFullClassName() + "\\n[" + StringMaker.IntSetToString(parent.getId()) + "]" + "\"");
            buffer.append(" -> ");
            buffer.append("\"" + call.getFullClassName() + "\\n[" + StringMaker.IntSetToString(call.getId()) + "]" + "\"");
            c.add(buffer.toString().intern());
            this.graphvizTest(node.getChildren(), c);
        }
    }

    public ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    private void saveLog() {
        if (this.fileChooser.showSaveDialog(this) == 0) {
            File selectedFile = new File(this.fileChooser.getCurrentDirectory(), this.fileChooser.getSelectedFile().getName());
            try {
                BufferedWriter br = new BufferedWriter(new FileWriter(selectedFile));
                CallTree tree = SequenceDiagramTabbedPane.getInstance().getSelectedDiagram().getModel().getCallTree();
                this.saveLog(br, tree.getTopNodeList().nodeIterator());
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveLog(BufferedWriter br, CallTreeIterator it) throws IOException {
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node instanceof CallNode) {
                CallNode call = (CallNode)node;
                StringBuffer buffer = new StringBuffer();
                Set<Integer> ids = call.getId();
                Iterator<Integer> it2 = ids.iterator();
                while (it2.hasNext()) {
                    buffer.append(it2.next() + ",");
                }
                String idString = buffer.substring(0, buffer.length() - 1);
                buffer = new StringBuffer();
                String[] types = call.getArgmentTypeNames();
                int i = 0;
                while (i < types.length) {
                    buffer.append(String.valueOf(types[i]) + ",");
                    ++i;
                }
                String arguments = "";
                if (types.length > 0) {
                    arguments = buffer.substring(0, buffer.length() - 1);
                }
                br.write(String.valueOf(call.getReturnTypeName()) + " " + call.getPackageName() + "." + call.getClassName() + "(" + idString + ")." + call.getMethodName() + "(" + arguments + "){");
                br.newLine();
            }
            if (it.hasChildren()) {
                this.saveLog(br, it.nextIterator());
            }
            if (!(node instanceof CallNode)) continue;
            br.write("}");
            br.newLine();
        }
    }

    public void loadFile(File selectedFile, int pbegin, int pend, File externalThreadFile) {
        boolean isBinary = false;
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(selectedFile));
            byte[] bytes = new byte[16];
            int result = stream.read(bytes, 0, 16);
            stream.close();
            if (result != 16) {
                return;
            }
            if (bytes[0] == 1 && bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 0) {
                isBinary = true;
            }
        }
        catch (IOException stream) {
            // empty catch block
        }
        if (isBinary) {
            File indexFile = new File(this.fileChooser.getCurrentDirectory(), "Index.dat");
            if (indexFile == null) {
                return;
            }
            DefaultBinaryLogParser parser = new DefaultBinaryLogParser(indexFile, LanguageType.JAVA);
            BinaryLogFile binaryLogFile = new BinaryLogFile(selectedFile, LanguageType.JAVA, parser.getPrefferedUnitSize(), parser, false);
            CallTreeGroup group = LogLoader.load(binaryLogFile);
            int num = group.getCallTreeNum();
            if (num == 1 && group.getCallTree(0).getName().equals("")) {
                SequenceDiagramModel model = new SequenceDiagramModel(group.getCallTree(0));
                this.diagramTab.addNewDiagram(model, selectedFile.getName());
            } else {
                int i = 0;
                while (i < num) {
                    SequenceDiagramModel model = new SequenceDiagramModel(group.getCallTree(i));
                    this.diagramTab.addNewDiagram(model, group.getCallTree(i).getName());
                    ++i;
                }
            }
        } else {
            DefaultLogParser parser = new DefaultLogParser(LanguageType.JAVA);
            TextLogFile textLogFile = new TextLogFile(selectedFile, LanguageType.JAVA, "\n", parser, false, pbegin, pend, externalThreadFile);
            CallTreeGroup group = LogLoader.load(textLogFile);
            int num = group.getCallTreeNum();
            if (num == 1 && group.getCallTree(0).getName().equals("")) {
                SequenceDiagramModel model = new SequenceDiagramModel(group.getCallTree(0));
                this.diagramTab.addNewDiagram(model, selectedFile.getName());
            } else {
                int i = 0;
                while (i < num) {
                    SequenceDiagramModel model = new SequenceDiagramModel(group.getCallTree(i));
                    this.diagramTab.addNewDiagram(model, group.getCallTree(i).getName());
                    ++i;
                }
            }
        }
    }

    private class CompressedLogLoadDialog
    extends JDialog {
        private static final long serialVersionUID = 3473280794464838317L;
        private final JFileChooser fileChooser;
        private final LineTextFieldPanel indexField;
        private final LineTextFieldPanel logField;
        private final JFrame frame;
        private File indexFile;
        private File logFile;

        private CompressedLogLoadDialog() {
            super((Frame)MainFrame.getInstance(), true);
            this.fileChooser = new JFileChooser(".");
            this.indexField = new LineTextFieldPanel("");
            this.logField = new LineTextFieldPanel("");
            this.indexFile = null;
            this.logFile = null;
            this.frame = MainFrame.getInstance();
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(0));
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            JButton setIndexButton = new JButton("...");
            JButton setLogButton = new JButton("...");
            this.indexField.add(setIndexButton);
            this.logField.add(setLogButton);
            this.indexField.setBorder(BorderFactory.createTitledBorder("Set index file."));
            this.logField.setBorder(BorderFactory.createTitledBorder("Set log file."));
            Container cp = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            cp.setLayout(gb);
            cons.anchor = 18;
            cons.gridx = 0;
            cons.weightx = 1.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.indexField, cons);
            cp.add(this.indexField);
            gb.setConstraints(this.logField, cons);
            cp.add(this.logField);
            cons.weighty = 1.0;
            gb.setConstraints(buttonPanel, cons);
            cp.add(buttonPanel);
            this.pack();
            setIndexButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CompressedLogLoadDialog.this.fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        CompressedLogLoadDialog.this.indexFile = new File(CompressedLogLoadDialog.this.fileChooser.getCurrentDirectory(), CompressedLogLoadDialog.this.fileChooser.getSelectedFile().getName());
                        CompressedLogLoadDialog.this.indexField.setText(CompressedLogLoadDialog.this.indexFile.getAbsolutePath());
                    }
                }
            });
            setLogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CompressedLogLoadDialog.this.fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        CompressedLogLoadDialog.this.logFile = new File(CompressedLogLoadDialog.this.fileChooser.getCurrentDirectory(), CompressedLogLoadDialog.this.fileChooser.getSelectedFile().getName());
                        CompressedLogLoadDialog.this.logField.setText(CompressedLogLoadDialog.this.logFile.getAbsolutePath());
                    }
                }
            });
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String text;
                    if (CompressedLogLoadDialog.this.logFile == null) {
                        text = CompressedLogLoadDialog.this.logField.getText();
                        if (text.length() > 0) {
                            CompressedLogLoadDialog.this.logFile = new File(text);
                        } else {
                            JOptionPane.showMessageDialog(MainFrame.this, "File can not open.", "Error.", 0);
                            return;
                        }
                    }
                    if (CompressedLogLoadDialog.this.indexFile == null) {
                        text = CompressedLogLoadDialog.this.indexField.getText();
                        if (text.length() > 0) {
                            CompressedLogLoadDialog.this.indexFile = new File(text);
                        } else {
                            JOptionPane.showMessageDialog(MainFrame.this, "File can not open.", "Error.", 0);
                            return;
                        }
                    }
                    DefaultBinaryLogParser parser = new DefaultBinaryLogParser(CompressedLogLoadDialog.this.indexFile, LanguageType.JAVA);
                    BinaryLogFile binaryLogFile = new BinaryLogFile(CompressedLogLoadDialog.this.logFile, LanguageType.JAVA, parser.getPrefferedUnitSize(), parser, false);
                    CallTreeGroup group = LogLoader.load(binaryLogFile);
                    int num = group.getCallTreeNum();
                    int i = 0;
                    while (i < num) {
                        SequenceDiagramModel model = new SequenceDiagramModel(group.getCallTree(i));
                        MainFrame.this.diagramTab.addNewDiagram(model, group.getCallTree(i).getName());
                        ++i;
                    }
                    CompressedLogLoadDialog.this.setVisible(false);
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompressedLogLoadDialog.this.setVisible(false);
                }
            });
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.setLocationRelativeTo(this.frame);
            }
            super.setVisible(b);
        }
    }
}

