/*
 * Decompiled with CFR 0.152.
 */
package amida.gui;

import amida.gui.TableModel;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class MouseHandler
implements Listener {
    private Table table;
    private TableModel model;

    public MouseHandler(Table table, TableModel model) {
        this.table = table;
        this.model = model;
    }

    protected TableModel getModel() {
        return this.model;
    }

    protected Table getTable() {
        return this.table;
    }

    protected abstract void triggerEvent(Event var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected abstract void triggerNoHit(Event var1);

    public void handleEvent(Event event) {
        int columnLeft = 0;
        int i = 0;
        while (i < this.table.getColumnCount() - 1) {
            columnLeft += this.table.getColumn(i).getWidth();
            ++i;
        }
        int leftOffset = this.table.getHorizontalBar().getSelection();
        int columnWidth = this.table.getColumn(this.table.getColumnCount() - 1).getWidth();
        int clientMaxY = this.table.getClientArea().height;
        boolean hit = false;
        int row = this.table.getTopIndex();
        while (row < this.table.getItemCount()) {
            TableItem item = this.table.getItem(row);
            int y = item.getBounds().y;
            int ymax = y + item.getBounds().height;
            if (columnLeft <= event.x + leftOffset && event.x + leftOffset < columnLeft + columnWidth && y <= event.y && event.y < ymax) {
                int idx = Integer.parseInt(item.getText(this.table.getColumnCount() - 1));
                this.triggerEvent(event, idx, columnLeft - leftOffset, item.getBounds().y, columnWidth, item.getBounds().height, event.x, event.y);
                hit = true;
            }
            if (y > clientMaxY) break;
            ++row;
        }
        if (!hit) {
            this.triggerNoHit(event);
        }
    }
}

