/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.foldrule;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.logcompactor.foldrule.LoopFoldRule;
import amida.logcompactor.foldrule.RemakeRule;
import amida.node.comparator.NodeTreeComparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class SameCallTreeLoopRule
extends LoopFoldRule {
    int depth;

    public SameCallTreeLoopRule(NodeTreeComparator comp, int depth) {
        super(comp);
        this.depth = depth;
    }

    @Override
    public abstract LoopNode makeNewLoop(CallTree var1);

    @Override
    public boolean checkLoop(List<Node> representList, List<Node> compareList) {
        if (this.getComparator().compareList(representList, compareList) == 0) {
            if (LoopFoldRule.makeRepresent) {
                this.remakeRepresentList(representList, compareList, this.depth);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Node> makeRepresentList(List<Node> firstList, List<Node> compareList) {
        if (this.getComparator().compareList(firstList, compareList) == 0) {
            LinkedList<Node> representList = new LinkedList<Node>();
            ListIterator<Node> it = firstList.listIterator();
            while (it.hasNext()) {
                Node node = it.next();
                try {
                    Node copy = (Node)node.clone();
                    representList.add(copy);
                }
                catch (CloneNotSupportedException e) {
                    System.err.println("can not invoke clone method");
                }
            }
            return representList;
        }
        return null;
    }

    private void remakeRepresentList(List<Node> representList, List<Node> compareList, int depth) {
        if (depth == 0) {
            return;
        }
        ListIterator<Node> it1 = representList.listIterator();
        ListIterator<Node> it2 = compareList.listIterator();
        while (it1.hasNext() && it2.hasNext()) {
            int callNodeNum2;
            Node node1 = it1.next();
            Node node2 = it2.next();
            int callNodeNum1 = node1.getCallNodeNum();
            if (callNodeNum1 == (callNodeNum2 = node2.getCallNodeNum())) {
                List<Node> subList;
                RemakeRule.remake(node1, node2);
                boolean node1IsCallNode = node1 instanceof CallNode;
                boolean node2IsCallNode = node2 instanceof CallNode;
                if (node1IsCallNode && node2IsCallNode) {
                    this.remakeRepresentList(node1.getChildren(), node2.getChildren(), depth - 1);
                    continue;
                }
                if (node2IsCallNode) {
                    int index = it2.nextIndex();
                    subList = compareList.subList(index - 1, index);
                    this.remakeRepresentList(node1.getChildren(), subList, depth);
                    continue;
                }
                if (node1IsCallNode) {
                    int index = it1.nextIndex();
                    subList = representList.subList(index - 1, index);
                    this.remakeRepresentList(subList, node2.getChildren(), depth);
                    continue;
                }
                this.remakeRepresentList(node1.getChildren(), node2.getChildren(), depth);
                continue;
            }
            if (callNodeNum1 > callNodeNum2) {
                RemakeRule.remake(node1, node2);
                int start = it2.nextIndex() - 1;
                int length = 1;
                while (it2.hasNext() && callNodeNum1 > callNodeNum2) {
                    node2 = it2.next();
                    callNodeNum2 += node2.getCallNodeNum();
                    ++length;
                }
                List<Node> subList = compareList.subList(start, start + length);
                if (callNodeNum1 == callNodeNum2) {
                    this.remakeRepresentList(node1.getChildren(), subList, depth);
                    continue;
                }
                throw new RuntimeException();
            }
            Node newNode = node2.getNewInstance();
            Node parent = node1.getParent();
            it1.remove();
            newNode.addChild(node1);
            while (it1.hasNext() && callNodeNum1 < callNodeNum2) {
                node1 = it1.next();
                it1.remove();
                newNode.addChild(node1);
                callNodeNum1 += node1.getCallNodeNum();
            }
            if (callNodeNum1 == callNodeNum2) {
                it1.add(newNode);
                if (parent != null) {
                    newNode.setParent(parent);
                }
                this.remakeRepresentList(newNode.getChildren(), node2.getChildren(), depth);
                continue;
            }
            CallTreeIterator it3 = newNode.nodeIterator();
            while (it3.hasNext()) {
                Node node = (Node)it3.next();
                it3.remove();
                it1.add(node);
                node.setParent(parent);
            }
            throw new RuntimeException();
        }
        if (!it1.hasNext() && !it2.hasNext()) {
            return;
        }
        throw new RuntimeException();
    }
}

