/*
 * Decompiled with CFR 0.152.
 */
package amida.logdecoder;

import amida.logdecoder.Dictionary;
import amida.logdecoder.DictionaryLoader;
import amida.logdecoder.MethodSignature;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class LogDecoder {
    private static final int ERR_OK = -1;
    private static final int ERR_USAGE = 0;
    private static final int ERR_NEGATIVE_START_LINE = 1;
    private static final int ERR_NEGATIVE_COUNT = 2;
    private static final char LF = '\n';
    private static final int INT_SIZE = 4;
    private static String[] ErrorMessages = new String[]{"USAGE: java LogDecoder dict-file compressed-log-file start-line [line-count]", "Line is counted from 1.", "Count must be larger than 0."};
    public static final int LINE_BUF_LENGTH = 4;
    public static final int OFFSET_METHOD_ID = 0;
    public static final int OFFSET_OBJECT_ID = 1;
    public static final int OFFSET_STACK_DEPTH = 2;
    public static final int OFFSET_THREAD_ID = 3;
    public static final int METHOD_ID_RETURN = 0;
    private static final String METHOD_RETURN_STRING = "}";
    private File logFile;
    private DataInputStream input;
    private Dictionary dictionary;
    private int startLine;
    private int nextLine;
    private int lastLine;
    private int count;
    private int[] encodedLine = new int[4];
    private MethodSignature method_sig;

    private LogDecoder(String[] args) {
        int parseResult = this.parseParameters(args);
        if (parseResult != -1) {
            System.err.println(ErrorMessages[parseResult]);
            return;
        }
        try {
            this.setStartLine(this.startLine);
            while (this.hasNext() && this.count > 0) {
                this.decode();
                System.out.print(this.toLogString());
                System.out.print('\n');
                --this.count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LogDecoder(File logFile, Dictionary dictionary) {
        this.logFile = logFile;
        this.dictionary = dictionary;
        this.lastLine = LogDecoder.getLogFileLength(logFile);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public int getLogFileLength() {
        return this.lastLine;
    }

    public static int getLogFileLength(File logFile) {
        return (int)(logFile.length() / 4L / 4L);
    }

    public void setStartLine(int startLine) throws IOException {
        this.startLine = startLine;
        this.nextLine = startLine;
        this.lastLine = this.getLogFileLength();
        this.input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFile)));
        long n = (startLine - 1) * 4 * 4;
        long skipped = this.input.skip(n);
        if (skipped != n) {
            this.nextLine = 0;
            throw new IOException();
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    public boolean hasNext() {
        return this.nextLine <= this.lastLine;
    }

    public void decode() {
        try {
            int i = 0;
            while (i < 4) {
                this.encodedLine[i] = this.swapEndian(this.input.readInt());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.method_sig = this.encodedLine[0] == 0 ? null : this.dictionary.decode(this.encodedLine[0]);
        ++this.nextLine;
    }

    public MethodSignature getMethodSig() {
        return this.method_sig;
    }

    public int getObjectID() {
        return this.encodedLine[1];
    }

    public int getStackDepth() {
        return this.encodedLine[2];
    }

    public int getThreadID() {
        return this.encodedLine[3];
    }

    public String toLogString() {
        if (this.method_sig == null) {
            return METHOD_RETURN_STRING;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getThreadID()) + " ");
        buf.append(String.valueOf(this.method_sig.getReturnType()) + " ");
        buf.append(String.valueOf(this.method_sig.getPackageName()) + ".");
        buf.append(String.valueOf(this.method_sig.getClassName()) + "(");
        buf.append(String.valueOf(this.getObjectID()) + ").");
        buf.append(String.valueOf(this.method_sig.getMethodName()) + "(");
        int i = 0;
        String[] args = this.method_sig.getArgs();
        while (i < args.length) {
            buf.append(String.valueOf(args[i]) + ",");
            ++i;
        }
        if (i > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append("){");
        return buf.toString();
    }

    private int swapEndian(int v) {
        return v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00 | v >>> 24;
    }

    public static void main(String[] args) {
        new LogDecoder(args);
    }

    private int parseParameters(String[] args) {
        block7: {
            block6: {
                if (args.length < 3) {
                    return 0;
                }
                this.dictionary = DictionaryLoader.loadDictionary(args[0]);
                this.logFile = new File(args[1]);
                try {
                    this.startLine = Integer.valueOf(args[2]);
                    if (this.startLine > 0) break block6;
                    return 1;
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }
            if (args.length != 4) break block7;
            this.count = Integer.valueOf(args[3]);
            if (this.count <= 0) {
                return 2;
            }
        }
        this.count = Integer.MAX_VALUE;
        return -1;
    }
}

