/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

public class AmidaLogEvent {
    private boolean callEvent;
    private String threadID;
    private String callerID;
    private String objectID;
    private String packageName;
    private String className;
    private String methodName;
    private String returnType;
    private String parameters;

    public AmidaLogEvent(String line) {
        if (line.startsWith("@thread")) {
            this.callEvent = false;
        } else if (line.indexOf("}") >= 0) {
            this.callEvent = false;
        } else {
            int idx;
            this.callEvent = true;
            String[] tokens = line.split(" ");
            if (tokens[idx = 0].startsWith("@")) {
                this.threadID = tokens[idx].substring(1);
            }
            int n = ++idx;
            this.objectID = tokens[n];
            this.callerID = tokens[++idx].startsWith("From:") ? tokens[idx].substring("From:".length()) : null;
            int n2 = ++idx;
            this.returnType = tokens[n2];
            String signature = tokens[++idx];
            int i = signature.indexOf("(");
            this.className = signature.substring(0, i);
            int period = this.className.lastIndexOf(46);
            if (period >= 0) {
                this.packageName = this.className.substring(0, period + 1);
                this.className = this.className.substring(period + 1);
            } else {
                this.packageName = "";
            }
            signature = signature.substring(i + 1);
            i = signature.indexOf(")");
            this.objectID = signature.substring(0, i);
            signature = signature.substring(i + 1);
            i = signature.indexOf("(");
            this.methodName = signature.substring(1, i);
            signature = signature.substring(i + 1);
            i = signature.indexOf(")");
            this.parameters = signature.substring(i);
        }
    }

    public boolean isCallEvent() {
        return this.callEvent;
    }

    public String getFullClassName() {
        return String.valueOf(this.packageName) + this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCallerID() {
        return this.callerID;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getParameters() {
        return this.parameters;
    }
}

