/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.logmanager.AmidaLogEvent;
import amida.logmanager.AmidaProperty;
import amida.logmanager.FileRangeReader;
import amida.logmanager.LogFileName;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PhaseSummaryWindow {
    private static Shell currentShell;
    private static int eventsInWindow;

    static {
        eventsInWindow = -1;
    }

    public static void closeCurrentWindow() {
        if (currentShell != null) {
            currentShell.dispose();
            currentShell = null;
        }
    }

    public static Shell open(Shell parent, String title, LogFileName phaselog, Point pos) {
        currentShell = new Shell(parent, 116);
        currentShell.setText(title);
        currentShell.setLayout((Layout)new FillLayout());
        currentShell.setLocation(pos);
        if (eventsInWindow == -1) {
            eventsInWindow = AmidaProperty.getInstance().getPhaseMethodCountForSummaryWindow();
        }
        Text text = new Text((Composite)currentShell, 2882);
        text.setText(PhaseSummaryWindow.loadHeadEvents(phaselog, eventsInWindow));
        Point size = currentShell.computeSize(-1, -1);
        if (size.y > text.getLineHeight() * 12) {
            size.y = text.getLineHeight() * 12;
        }
        currentShell.setSize(size);
        currentShell.setVisible(true);
        return currentShell;
    }

    public static String loadHeadEvents(LogFileName f, int numEvents) {
        try {
            ArrayList<String> items = new ArrayList<String>(numEvents);
            Reader r = new BufferedReader(new FileReader(f.getLogfile()));
            if (f.isPhaseSpecified()) {
                r = new FileRangeReader(r, f.getPhaseBegin(), f.getPhaseEnd());
            }
            LineNumberReader reader = new LineNumberReader(r);
            String l = reader.readLine();
            while (l != null && items.size() < numEvents) {
                String sig;
                AmidaLogEvent event = new AmidaLogEvent(l);
                if (event.isCallEvent() && !items.contains(sig = String.valueOf(event.getClassName()) + "#" + event.getMethodName())) {
                    items.add(sig);
                }
                l = reader.readLine();
            }
            reader.close();
            StringBuilder builder = new StringBuilder();
            for (String s : items) {
                builder.append(s);
                builder.append("\n");
            }
            return builder.toString();
        }
        catch (IOException e) {
            return "";
        }
    }
}

