/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.gui.ContentPainter;
import amida.gui.TableModel;
import amida.gui.TableModelListener;
import amida.logmanager.LogFileName;
import amida.logmanager.Logger;
import amida.logmanager.PhaseDetectionResult;
import amida.logmanager.PhaseDetectionResultList;
import amida.logmanager.PhaseDetectionResultParser;
import amida.logmanager.PhaseScale;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class PhaseTableModel
implements TableModel,
PhaseDetectionResultList {
    private static final String[] cols = new String[]{"cache", "window", "th", "m", "Phases"};
    private List<PhaseDetectionResult> result = new ArrayList<PhaseDetectionResult>();
    private TableModelListener listener;
    private PhaseScale phaseScale = new PhaseScale(0, new int[0]);
    private PhaseScale.PHASE_SCALE_OPTION scaleOption = PhaseScale.PHASE_SCALE_OPTION.NORMAL;
    private static final String FILE_COMMENT_LINE = "#";
    private static final String FILE_HEADER_BEGIN = "<amida>";
    private static final String FILE_HEADER_END = "</amida>";
    private static final String FILE_LOGFILE = "logfile";
    private static final String FILE_THREADFILE = "threadfile";

    @Override
    public int getColumnType(int col) {
        if (col == 2) {
            return 1;
        }
        if (col == 4) {
            return 2;
        }
        return 0;
    }

    @Override
    public void addListener(TableModelListener listener) {
        this.listener = listener;
    }

    @Override
    public int getColumnCount() {
        return cols.length;
    }

    @Override
    public String getColumnName(int col) {
        return cols[col];
    }

    @Override
    public int getRowCount() {
        return this.result.size();
    }

    @Override
    public String getCell(int col, int row) {
        PhaseDetectionResult item = this.result.get(row);
        switch (col) {
            case 0: {
                return Integer.toString(item.getPhaseParams().getCacheSize());
            }
            case 1: {
                return Integer.toString(item.getPhaseParams().getWindowSize());
            }
            case 2: {
                return Double.toString(item.getPhaseParams().getFrequencyThreshold());
            }
            case 3: {
                return Integer.toString(item.getPhaseParams().getHeadSearchDistance());
            }
        }
        return String.valueOf(row);
    }

    @Override
    public ContentPainter getContent(int row) {
        return this.result.get(row);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(File f) {
        ArrayList<PhaseDetectionResult> list = new ArrayList<PhaseDetectionResult>();
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(f));
            Logger.getInstance().println("Read: " + f.getAbsolutePath());
            try {
                String line = reader.readLine();
                File logFile = null;
                File threadFile = null;
                PARSE_STATE state = PARSE_STATE.BEFORE_HEADER;
                while (line != null) {
                    if (!line.startsWith(FILE_COMMENT_LINE)) {
                        if (state == PARSE_STATE.BEFORE_HEADER) {
                            if (!line.equalsIgnoreCase(FILE_HEADER_BEGIN)) throw new InvalidFileFormatException();
                            state = PARSE_STATE.HEADER;
                        } else if (state == PARSE_STATE.HEADER) {
                            if (line.equalsIgnoreCase(FILE_HEADER_END)) {
                                state = PARSE_STATE.BODY;
                            } else {
                                String[] key_value = line.split("=");
                                if (key_value.length != 2) throw new InvalidFileFormatException();
                                if (key_value[0].equals(FILE_LOGFILE)) {
                                    logFile = this.getFile(f, key_value[1]);
                                } else if (key_value[0].equals(FILE_THREADFILE)) {
                                    threadFile = this.getFile(f, key_value[1]);
                                }
                            }
                        } else {
                            assert (state == PARSE_STATE.BODY);
                            PhaseDetectionResult item = PhaseDetectionResultParser.parseLine(this, line, new LogFileName(logFile.getAbsolutePath(), threadFile.getAbsolutePath()));
                            if (item != null) {
                                list.add(item);
                            } else {
                                Logger.getInstance().println("Error in line " + reader.getLineNumber());
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (InvalidFileFormatException e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Invalid format in line ");
                msg.append(reader.getLineNumber());
                Logger.getInstance().println(msg.toString());
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            Logger.getInstance().println("File Not Found: " + f.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.result = list;
        this.updatePhaseScale();
        this.listener.update();
    }

    private File getFile(File amidafile, String filename) {
        File f = new File(filename);
        if (f.getAbsolutePath().equals(filename)) {
            return f;
        }
        return new File(amidafile.getParent(), filename);
    }

    private void updatePhaseScale() {
        int size = this.computeMaxTraceSize();
        int[] phaseTransition = this.computePhaseTransitionPoints();
        this.phaseScale = new PhaseScale(size, phaseTransition);
    }

    private int computeMaxTraceSize() {
        int max = 0;
        for (PhaseDetectionResult item : this.result) {
            max = Math.max(max, item.getLength());
        }
        return max;
    }

    private int[] computePhaseTransitionPoints() {
        int i;
        TreeSet<Integer> transitionPoints = new TreeSet<Integer>();
        for (PhaseDetectionResult item : this.result) {
            i = 0;
            while (i < item.getPhaseCount()) {
                transitionPoints.add(item.getPhaseHead(i));
                ++i;
            }
            transitionPoints.add(item.getLength());
        }
        Object[] array = transitionPoints.toArray();
        int[] ret = new int[transitionPoints.size()];
        i = 0;
        while (i < ret.length) {
            ret[i] = (Integer)array[i];
            ++i;
        }
        return ret;
    }

    public void setPhaseScaleOption(PhaseScale.PHASE_SCALE_OPTION option) {
        if (this.scaleOption != option) {
            this.scaleOption = option;
            this.listener.update();
        }
    }

    @Override
    public double getScaledPosition(int phaseTimestamp) {
        return this.phaseScale.getScale(phaseTimestamp, this.scaleOption);
    }

    public int getPhaseFilePos(int phaseTimestamp) {
        return -1;
    }

    @Override
    public void onMouseLeave() {
        this.listener.hideHint();
    }

    private static class InvalidFileFormatException
    extends IOException {
        private static final long serialVersionUID = -56248561105430782L;
    }

    private static enum PARSE_STATE {
        BEFORE_HEADER,
        HEADER,
        BODY;

    }
}

