/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.diagram.sequencediagram.gui.InformationTabbedPane;
import amida.gui.MainFrame;
import amida.logloader.LogFile;
import amida.profiler.ProfileThread;
import amida.profiler.Profiler;
import amida.profiler.ProfilerPrompt;
import amida.profiler.gui.LogChooser;
import amida.profiler.gui.LogChooserModel;
import amida.profiler.gui.Method;
import amida.profiler.gui.MethodTableModel;
import amida.utility.CheckTextFieldPanel;
import amida.utility.LineTextFieldPanel;
import amida.utility.MyFileFilter;
import amida.utility.ThreadEndListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProfileDialog
extends JDialog {
    private static final long serialVersionUID = -4257955863929441622L;
    private static final int SMALL_TEXT_FIELD_SIZE = 40;
    private static final String GET_FILTERED_METHOD = "GetFilteredMethod";
    private static final String LOG_FILE_DIRECTORY = "LogfileDirectory";
    private static final String PACKAGE_FILTER = "PackageFilter";
    private static final String CLASS_FILTER = "ClassFilter";
    private static final String METHOD_FILTER = "MethodFilter";
    private static final String START_METHOD = "StartMethod";
    private static final String COMPRESS_LOGFILE = "CompressLogfile";
    private static final String RECORD_THREAD_ID = "RecordThreadID";
    private static final String SEPARATE_LOGFILE = "SeparateLogfilePerThread";
    private static final String DEFAULT_INDEX_FILENAME = "MethodIndex.dat";
    private static final ProfileDialog singleton = new ProfileDialog();
    private final JTabbedPane tab = new JTabbedPane();
    private final JTextField commandField;
    private final List<String> vmArgs = new LinkedList<String>();
    private String mainFile = "";
    private final List<String> args = new LinkedList<String>();
    private String options = "";
    private final List<String> classPathes = new LinkedList<String>();
    private final JFrame owner;
    private final LogChooser logChooser;
    private final TargetPanel targetPanel = new TargetPanel();
    private final ProfilerPanel profilerPanel = new ProfilerPanel();
    private final VmOptionPanel vmOptionPanel = new VmOptionPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private boolean logCompressed = false;
    private String indexFileName = null;

    private ProfileDialog() {
        super(MainFrame.getInstance(), "Setting profiler option", true);
        this.owner = MainFrame.getInstance();
        this.logChooser = InformationTabbedPane.getInstance().getLogChooser();
        this.tab.setPreferredSize(new Dimension(700, 300));
        this.setDefaultCloseOperation(1);
        Container cp = this.getContentPane();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        this.tab.add((Component)this.targetPanel, "target program");
        this.tab.add((Component)this.profilerPanel, "profiler");
        this.tab.add((Component)this.vmOptionPanel, "vm option");
        this.tab.add((Component)this.filterPanel, "filter");
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new GridLayout(1, 1));
        commandPanel.setBorder(BorderFactory.createTitledBorder("Execute command"));
        this.commandField = new JTextField("java -Djava.compiler=NONE -Xdebug -agentpath:", 40);
        this.commandField.setEditable(false);
        this.commandField.setBackground(Color.white);
        commandPanel.add(this.commandField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton profileButton = new JButton("Profile");
        buttonPanel.add(profileButton);
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(cancelButton);
        cons.fill = 1;
        cons.gridwidth = 1;
        cons.gridheight = 3;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        gb.setConstraints(this.tab, cons);
        cp.add(this.tab);
        cons.gridheight = 1;
        cons.weighty = 0.0;
        cons.gridy = 3;
        gb.setConstraints(commandPanel, cons);
        cp.add(commandPanel);
        cons.gridy = 4;
        gb.setConstraints(buttonPanel, cons);
        cp.add(buttonPanel);
        profileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProfileDialog.this.profile();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProfileDialog.this.setVisible(false);
            }
        });
        this.updateCommand();
        this.pack();
    }

    public static ProfileDialog getInstance() {
        return singleton;
    }

    private void setMainFile(String fileName) {
        this.mainFile = fileName;
    }

    public String getCommand() {
        int index;
        String extension;
        StringBuffer buffer = new StringBuffer("java -Djava.compiler=NONE -Xdebug -agentpath:");
        buffer.append(this.profilerPanel.getProfiler());
        buffer.append(" ");
        buffer.append(this.options);
        buffer.append(" ");
        Iterator<String> it = this.vmArgs.iterator();
        while (it.hasNext()) {
            buffer.append(String.valueOf(it.next()) + " ");
        }
        it = this.classPathes.iterator();
        String mainPackagePath = "";
        int mainPackagePathLength = 0;
        if (it.hasNext()) {
            buffer.append("-classpath ");
            while (it.hasNext()) {
                String classPath = it.next();
                if (this.mainFile.startsWith(classPath)) {
                    String packagePath = this.mainFile.substring(classPath.length());
                    packagePath = packagePath.replace('\\', '.');
                    if (mainPackagePathLength == 0 || packagePath.length() < mainPackagePathLength) {
                        mainPackagePath = packagePath;
                        mainPackagePathLength = packagePath.length();
                    }
                }
                buffer.append(classPath);
                if (it.hasNext()) {
                    buffer.append(";");
                    continue;
                }
                buffer.append(" ");
            }
        }
        if ((extension = mainPackagePath.substring((index = mainPackagePath.lastIndexOf(".")) + 1)).equals("class")) {
            buffer.append(String.valueOf(mainPackagePath.substring(0, index)) + " ");
        } else {
            buffer.append(String.valueOf(this.mainFile) + " ");
        }
        if (this.mainFile != null && !this.mainFile.equals("")) {
            it = this.args.iterator();
            while (it.hasNext()) {
                buffer.append(String.valueOf(it.next()) + " ");
            }
        }
        return buffer.toString().trim();
    }

    private void profile() {
        File profiler = new File(this.profilerPanel.getProfiler().trim());
        if (!profiler.exists()) {
            JOptionPane.showMessageDialog(this, "profiler.dll not found.", "Profile Error", 0);
            return;
        }
        File current = new File(Profiler.DEFAULT_CURRENT);
        String temp = this.profilerPanel.getLogDirectory().trim();
        File logDirectory = !temp.equals("") ? new File(temp) : new File(Profiler.DEFAULT_CURRENT);
        ArrayList<String> init = new ArrayList<String>();
        init.add(new String("LogfileDirectory=" + logDirectory.getAbsolutePath()));
        this.logCompressed = this.profilerPanel.isCompress();
        if (this.logCompressed) {
            String text = this.profilerPanel.getMethodIndexFileName();
            if (text.length() > 0) {
                init.add("CompressLogfile=" + this.profilerPanel.getMethodIndexFileName());
                this.indexFileName = text;
            } else {
                init.add("CompressLogfile=1");
                this.indexFileName = DEFAULT_INDEX_FILENAME;
            }
        } else {
            init.add("CompressLogfile=0");
        }
        if (this.filterPanel.recordFilteredMethods()) {
            init.add(new String("GetFilteredMethod=1"));
        } else {
            init.add(new String("GetFilteredMethod=0"));
        }
        if (this.profilerPanel.recordThreadId()) {
            init.add("RecordThreadID=1");
        } else {
            init.add("RecordThreadID=0");
        }
        if (this.profilerPanel.separateLogfile()) {
            init.add("SeparateLogfilePerThread=1");
        } else {
            init.add("SeparateLogfilePerThread=0");
        }
        Method startMethod = this.filterPanel.getStartMethod();
        if (startMethod != null) {
            init.add(new String("StartMethod=" + startMethod.toString()));
        }
        List<Method> filteredMethods = this.filterPanel.getFilteredMethods();
        for (Method filteredMethod : filteredMethods) {
            if (filteredMethod.getMethodName().equals("*")) {
                if (filteredMethod.getClassName().equals("*")) {
                    init.add("PackageFilter=" + filteredMethod.getPackageName());
                    continue;
                }
                init.add("ClassFilter=" + filteredMethod.getPackageName() + "." + filteredMethod.getClassName());
                continue;
            }
            init.add("MethodFilter=" + filteredMethod.toString());
        }
        InformationTabbedPane.getInstance().setSelectedIndex(InformationTabbedPane.getInstance().getPromptPriterIndex());
        ProfilerPrompt promptManager = new ProfilerPrompt(InformationTabbedPane.getInstance().getPromptPrinter());
        ProfileThread thread = new ProfileThread(profiler, logDirectory, this.getCommand(), init, this.logCompressed, this.profilerPanel.recordThreadId(), current, promptManager);
        thread.addEndListener(new ThreadEndListener(){

            @Override
            public void threadEnd(Thread thread) {
                ProfileDialog.this.profileEnd(((ProfileThread)thread).getLogfiles());
            }
        });
        thread.start();
        this.setVisible(false);
    }

    private void profileEnd(List<LogFile> logFiles) {
        if (this.logChooser != null && logFiles != null) {
            LogChooserModel model = (LogChooserModel)this.logChooser.getModel();
            model.clear();
            model.setLogList(logFiles);
            Dimension size = new Dimension(this.logChooser.getRowHeight() * (logFiles.size() + 1), this.logChooser.getWidth());
            this.logChooser.setPreferredScrollableViewportSize(size);
            InformationTabbedPane.getInstance().setSelectedIndex(InformationTabbedPane.getInstance().getLogChooserIndex());
        }
    }

    public LogChooser getLogChooser() {
        return this.logChooser;
    }

    public boolean isLogCompressed() {
        return this.logCompressed;
    }

    public String getIndexFileName() {
        return this.indexFileName;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.owner);
        }
        super.setVisible(b);
    }

    private void updateCommand() {
        this.commandField.setText(this.getCommand());
        this.commandField.repaint();
    }

    private class FilterPanel
    extends JPanel {
        private static final long serialVersionUID = -8503768460928566389L;
        private final FilteredMethodPanel filteredMethodPanel;
        private final StartMethodPanel startMethodPanel;

        private FilterPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            this.startMethodPanel = new StartMethodPanel();
            this.startMethodPanel.setBorder(BorderFactory.createTitledBorder("Loging start method."));
            this.filteredMethodPanel = new FilteredMethodPanel();
            this.filteredMethodPanel.setBorder(BorderFactory.createTitledBorder("Filter method"));
            cons.fill = 2;
            cons.anchor = 18;
            cons.weightx = 1.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.startMethodPanel, cons);
            this.add(this.startMethodPanel);
            cons.fill = 1;
            cons.weighty = 1.0;
            cons.gridx = 0;
            gb.setConstraints(this.filteredMethodPanel, cons);
            this.add(this.filteredMethodPanel);
        }

        public boolean recordFilteredMethods() {
            return this.filteredMethodPanel.isFilter();
        }

        public List<Method> getFilteredMethods() {
            return this.filteredMethodPanel.getFilteredMethods();
        }

        public Method getStartMethod() {
            return this.startMethodPanel.getStartMethod();
        }
    }

    private class FilteredMethodPanel
    extends JPanel
    implements MethodEntryListener {
        private static final long serialVersionUID = -1473730684319366766L;
        private final int ADD_MODE = 0;
        private final int EDIT_MODE = 1;
        private final JCheckBox libraryCheck;
        private final JCheckBox filterCheck;
        private final JTable filteredMethodTable;
        private final JButton addButton;
        private final JButton deleteButton;
        private final JButton editButton;
        private final MethodEntryDialog methodEntry;
        private int entryMode;

        private FilteredMethodPanel() {
            this.methodEntry = new MethodEntryDialog(this);
            this.entryMode = 0;
            ArrayList<Method> defaultFilteredMethods = new ArrayList<Method>();
            defaultFilteredMethods.add(new Method("java*", "*", "*"));
            defaultFilteredMethods.add(new Method("javax*", "*", "*"));
            defaultFilteredMethods.add(new Method("sun*", "*", "*"));
            defaultFilteredMethods.add(new Method("org*", "*", "*"));
            defaultFilteredMethods.add(new Method("com*", "*", "*"));
            this.filteredMethodTable = new JTable(new MethodTableModel(defaultFilteredMethods));
            JScrollPane tableScroll = new JScrollPane(this.filteredMethodTable);
            this.addButton = new JButton("Add");
            this.deleteButton = new JButton("Del");
            this.editButton = new JButton("Edit");
            this.filterCheck = new JCheckBox("Filter method calls.", true);
            this.libraryCheck = new JCheckBox("Record only called by a non filtered method.", false);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 0;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 1.0;
            gb.setConstraints(this.filterCheck, cons);
            this.add(this.filterCheck);
            cons.gridy = 1;
            gb.setConstraints(this.libraryCheck, cons);
            this.add(this.libraryCheck);
            cons.fill = 1;
            cons.gridy = 2;
            cons.gridwidth = 3;
            cons.gridheight = 3;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            gb.setConstraints(tableScroll, cons);
            this.add(tableScroll);
            cons.fill = 0;
            cons.gridx = 3;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            gb.setConstraints(this.addButton, cons);
            this.add(this.addButton);
            cons.gridy = 3;
            gb.setConstraints(this.editButton, cons);
            this.add(this.editButton);
            cons.gridy = 4;
            gb.setConstraints(this.deleteButton, cons);
            this.add(this.deleteButton);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FilteredMethodPanel.this.entryMode = 0;
                    FilteredMethodPanel.this.methodEntry.clear();
                    FilteredMethodPanel.this.methodEntry.setVisible(true);
                }
            });
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilteredMethodPanel.this.entryMode = 1;
                    int index = FilteredMethodPanel.this.filteredMethodTable.getSelectedRow();
                    FilteredMethodPanel.this.methodEntry.setMethod(((MethodTableModel)FilteredMethodPanel.this.filteredMethodTable.getModel()).getMethod(index));
                    FilteredMethodPanel.this.methodEntry.setVisible(true);
                }
            });
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int index = FilteredMethodPanel.this.filteredMethodTable.getSelectedRow();
                    ((MethodTableModel)FilteredMethodPanel.this.filteredMethodTable.getModel()).delete(index);
                }
            });
            this.filterCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = FilteredMethodPanel.this.filterCheck.isSelected();
                    FilteredMethodPanel.this.libraryCheck.setEnabled(selected);
                    FilteredMethodPanel.this.addButton.setEnabled(selected);
                    FilteredMethodPanel.this.deleteButton.setEnabled(selected);
                    FilteredMethodPanel.this.editButton.setEnabled(selected);
                    FilteredMethodPanel.this.filteredMethodTable.setEnabled(selected);
                    if (selected) {
                        FilteredMethodPanel.this.filteredMethodTable.setBackground(Color.WHITE);
                    } else {
                        FilteredMethodPanel.this.filteredMethodTable.getSelectionModel().clearSelection();
                        FilteredMethodPanel.this.filteredMethodTable.setBackground(Color.LIGHT_GRAY);
                    }
                }
            });
        }

        public boolean isFilter() {
            return this.libraryCheck.isSelected();
        }

        public List<Method> getFilteredMethods() {
            return ((MethodTableModel)this.filteredMethodTable.getModel()).getMethods();
        }

        @Override
        public void entry(Method method) {
            if (this.entryMode == 0) {
                ((MethodTableModel)this.filteredMethodTable.getModel()).add(method);
            } else if (this.entryMode == 1) {
                ((MethodTableModel)this.filteredMethodTable.getModel()).set(this.filteredMethodTable.getSelectedRow(), method);
            }
        }
    }

    private class MethodEntryDialog
    extends JDialog {
        private static final long serialVersionUID = 8339236216881801386L;
        private final CheckTextFieldPanel packageCheck;
        private final CheckTextFieldPanel classCheck;
        private final CheckTextFieldPanel methodCheck;
        private final MethodEntryListener listener;

        private MethodEntryDialog(MethodEntryListener listener) {
            super(ProfileDialog.this, "Set Target Method", true);
            this.packageCheck = new CheckTextFieldPanel("Specify target package", "*");
            this.classCheck = new CheckTextFieldPanel("Specify target class", "*");
            this.methodCheck = new CheckTextFieldPanel("Specify target emthod", "*");
            this.listener = listener;
            this.packageCheck.setBorder(BorderFactory.createTitledBorder("Package"));
            this.classCheck.setBorder(BorderFactory.createTitledBorder("Class"));
            this.methodCheck.setBorder(BorderFactory.createTitledBorder("Method"));
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 2;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.weightx = 1.0;
            gb.setConstraints(this.packageCheck, cons);
            this.add(this.packageCheck);
            gb.setConstraints(this.classCheck, cons);
            this.add(this.classCheck);
            gb.setConstraints(this.methodCheck, cons);
            this.add(this.methodCheck);
            cons.weighty = 1.0;
            cons.gridwidth = 1;
            cons.fill = 0;
            cons.anchor = 10;
            gb.setConstraints(okButton, cons);
            this.add(okButton);
            cons.gridx = 1;
            gb.setConstraints(cancelButton, cons);
            this.add(cancelButton);
            this.pack();
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MethodEntryDialog.this.setVisible(false);
                    MethodEntryDialog.this.listener.entry(new Method(MethodEntryDialog.this.packageCheck.getText().trim(), MethodEntryDialog.this.classCheck.getText().trim(), MethodEntryDialog.this.methodCheck.getText().trim()));
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MethodEntryDialog.this.setVisible(false);
                }
            });
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.setLocationRelativeTo(ProfileDialog.this.owner);
            }
            super.setVisible(b);
        }

        public void clear() {
            this.getPackageCheck().clear();
            this.getClassCheck().clear();
            this.getMethodCheck().clear();
        }

        public void setMethod(Method method) {
            this.clear();
            if (!method.getPackageName().equals("*")) {
                this.getPackageCheck().check();
                this.getPackageCheck().selected();
            }
            if (!method.getClassName().equals("*")) {
                this.getClassCheck().check();
                this.getClassCheck().selected();
            }
            if (!method.getMethodName().equals("*")) {
                this.getMethodCheck().check();
                this.getMethodCheck().selected();
            }
            this.getPackageCheck().setText(method.getPackageName());
            this.getClassCheck().setText(method.getClassName());
            this.getMethodCheck().setText(method.getMethodName());
        }

        public CheckTextFieldPanel getClassCheck() {
            return this.classCheck;
        }

        public CheckTextFieldPanel getMethodCheck() {
            return this.methodCheck;
        }

        public CheckTextFieldPanel getPackageCheck() {
            return this.packageCheck;
        }
    }

    private static interface MethodEntryListener {
        public void entry(Method var1);
    }

    private class ProfilerPanel
    extends JPanel {
        private static final long serialVersionUID = -3023582510951337677L;
        private final JTextField profilerField;
        private final JTextField logDirectoryField;
        private final JCheckBox compressCheck = new JCheckBox("Compress logfile");
        private final JCheckBox recordThreadId = new JCheckBox("Record thread information", true);
        private final JCheckBox separateFilePerThread = new JCheckBox("Separate diagrams per thread", true);

        private void setDLLPathToField(File f) {
            this.profilerField.setText(f.getAbsolutePath());
            this.profilerField.repaint();
            ProfileDialog.this.updateCommand();
        }

        private ProfilerPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            LineTextFieldPanel profilerPathPanel = new LineTextFieldPanel("");
            profilerPathPanel.setBorder(BorderFactory.createTitledBorder("Profiler path"));
            this.profilerField = profilerPathPanel.getTextField();
            File profiler = new File("amidaprof.dll");
            if (profiler.exists()) {
                this.setDLLPathToField(profiler);
            }
            JButton profilerButton = new JButton("...");
            profilerPathPanel.add(profilerButton);
            LineTextFieldPanel logDirectoryPanel = new LineTextFieldPanel(Profiler.DEFAULT_LOG_DIRECTORY);
            logDirectoryPanel.setBorder(BorderFactory.createTitledBorder("Log file Directory"));
            this.logDirectoryField = logDirectoryPanel.getTextField();
            JButton logDirectoryButton = new JButton("...");
            logDirectoryPanel.add(logDirectoryButton);
            cons.fill = 2;
            cons.anchor = 18;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(profilerPathPanel, cons);
            this.add(profilerPathPanel);
            gb.setConstraints(logDirectoryPanel, cons);
            this.add(logDirectoryPanel);
            cons.weighty = 1.0;
            gb.setConstraints(this.compressCheck, cons);
            this.add(this.compressCheck);
            profilerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"dll"}));
                    if (fileChooser.showOpenDialog(ProfileDialog.this) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        ProfilerPanel.this.setDLLPathToField(file);
                    }
                }
            });
            logDirectoryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[0]));
                    fileChooser.setFileSelectionMode(1);
                    if (fileChooser.showOpenDialog(ProfileDialog.this) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String fileName = file.getAbsolutePath();
                        ProfilerPanel.this.logDirectoryField.setText(String.valueOf(fileName) + "\\");
                        ProfilerPanel.this.logDirectoryField.repaint();
                    }
                }
            });
        }

        public String getLogDirectory() {
            return this.logDirectoryField.getText();
        }

        public String getProfiler() {
            return this.profilerField.getText();
        }

        public boolean isCompress() {
            return this.compressCheck.isSelected();
        }

        public boolean recordThreadId() {
            return this.recordThreadId.isSelected();
        }

        public boolean separateLogfile() {
            return this.separateFilePerThread.isSelected();
        }

        public String getMethodIndexFileName() {
            return this.compressCheck.getText();
        }
    }

    private class StartMethodPanel
    extends JPanel
    implements MethodEntryListener {
        private static final long serialVersionUID = -2298975761745442553L;
        private final JTable startMethodTable;
        private final JCheckBox startMethodCheck;
        private final JButton setButton;
        private final MethodEntryDialog methodEntry;

        private StartMethodPanel() {
            this.methodEntry = new MethodEntryDialog(this);
            this.startMethodCheck = new JCheckBox("Set loging start method.");
            MethodTableModel model = new MethodTableModel();
            model.addMethod(new Method("*", "*", "*"));
            this.startMethodTable = new JTable(model);
            JScrollPane tableScroll = new JScrollPane(this.startMethodTable);
            tableScroll.setVerticalScrollBarPolicy(21);
            tableScroll.setHorizontalScrollBarPolicy(31);
            this.startMethodTable.setRowSelectionAllowed(false);
            this.startMethodTable.setCellSelectionEnabled(false);
            this.setButton = new JButton("Set");
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.anchor = 18;
            cons.gridx = 0;
            cons.gridwidth = 3;
            cons.weightx = 1.0;
            gb.setConstraints(this.startMethodCheck, cons);
            this.add(this.startMethodCheck);
            cons.fill = 1;
            cons.weighty = 1.0;
            gb.setConstraints(tableScroll, cons);
            this.add(tableScroll);
            cons.fill = 0;
            cons.weightx = 0.0;
            cons.gridwidth = 1;
            cons.gridx = 3;
            cons.gridy = 1;
            gb.setConstraints(this.setButton, cons);
            this.add(this.setButton);
            tableScroll.setMaximumSize(new Dimension(100, 33));
            tableScroll.setMinimumSize(new Dimension(100, 33));
            this.startMethodTable.setBackground(Color.LIGHT_GRAY);
            this.setButton.setEnabled(false);
            this.setButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StartMethodPanel.this.methodEntry.setVisible(true);
                }
            });
            this.startMethodCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = StartMethodPanel.this.startMethodCheck.isSelected();
                    StartMethodPanel.this.setButton.setEnabled(selected);
                    if (selected) {
                        StartMethodPanel.this.startMethodTable.setBackground(Color.WHITE);
                    } else {
                        StartMethodPanel.this.startMethodTable.setBackground(Color.LIGHT_GRAY);
                    }
                }
            });
        }

        @Override
        public void entry(Method method) {
            MethodTableModel model = (MethodTableModel)this.startMethodTable.getModel();
            if (model.size() == 0) {
                model.add(method);
            } else if (model.size() == 1) {
                model.delete(0);
                model.add(method);
            }
        }

        public Method getStartMethod() {
            if (!this.startMethodCheck.isSelected()) {
                return null;
            }
            MethodTableModel model = (MethodTableModel)this.startMethodTable.getModel();
            if (model.size() != 1) {
                return null;
            }
            Method method = ((MethodTableModel)this.startMethodTable.getModel()).getMethods().get(0);
            if (method.getPackageName().equals("") && method.getClassName().equals("") && method.getMethodName().equals("")) {
                return null;
            }
            return method;
        }
    }

    private class TargetPanel
    extends JPanel {
        private static final long serialVersionUID = 4950905933759356540L;
        private final JTextField mainFileField;
        private final JTextField argsField;

        private TargetPanel() {
            LineTextFieldPanel mainFilePanel = new LineTextFieldPanel("");
            mainFilePanel.setBorder(BorderFactory.createTitledBorder("Main"));
            this.mainFileField = mainFilePanel.getTextField();
            JButton mainReferenceButton = new JButton("...");
            mainFilePanel.add(mainReferenceButton);
            LineTextFieldPanel argsPanel = new LineTextFieldPanel("");
            argsPanel.setBorder(BorderFactory.createTitledBorder("args"));
            this.argsField = argsPanel.getTextField();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            cons.fill = 2;
            cons.anchor = 11;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(mainFilePanel, cons);
            this.add(mainFilePanel);
            cons.weighty = 1.0;
            gb.setConstraints(argsPanel, cons);
            this.add(argsPanel);
            mainReferenceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"class", "jar"}));
                    if (fileChooser.showOpenDialog(ProfileDialog.this) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String fileName = file.getAbsolutePath();
                        TargetPanel.this.mainFileField.setText(fileName);
                        ProfileDialog.this.setMainFile(fileName);
                        int index = fileName.lastIndexOf(46);
                        String extension = fileName.substring(index + 1, fileName.length());
                        if (extension.equals("jar")) {
                            Iterator it = ProfileDialog.this.vmArgs.iterator();
                            boolean isInclude = false;
                            while (it.hasNext()) {
                                String vmOption = (String)it.next();
                                if (!vmOption.equals("-jar")) continue;
                                isInclude = true;
                            }
                            if (!isInclude) {
                                ProfileDialog.this.vmArgs.add("-jar");
                            }
                        } else {
                            Iterator it = ProfileDialog.this.vmArgs.iterator();
                            while (it.hasNext()) {
                                String vmOption = (String)it.next();
                                if (!vmOption.equals("-jar")) continue;
                                it.remove();
                            }
                        }
                        ProfileDialog.this.updateCommand();
                    }
                }
            });
            this.mainFileField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    String text = TargetPanel.this.mainFileField.getText();
                    File mainFile = new File(text);
                    if (mainFile.exists()) {
                        String absolutePath = mainFile.getAbsolutePath();
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        ProfileDialog.this.setMainFile(absolutePath);
                    } else {
                        ProfileDialog.this.setMainFile(text);
                    }
                    ProfileDialog.this.updateCommand();
                }
            });
            this.argsField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.this.args.clear();
                    String text = TargetPanel.this.argsField.getText();
                    StringTokenizer st = new StringTokenizer(text, " \t");
                    while (st.hasMoreTokens()) {
                        String arg = st.nextToken();
                        arg = arg.trim();
                        ProfileDialog.this.args.add(String.valueOf(arg) + " ");
                    }
                    ProfileDialog.this.updateCommand();
                }
            });
        }
    }

    private class VmOptionPanel
    extends JPanel {
        private static final long serialVersionUID = -5547397994842166997L;
        private final JTextField classpathField;
        private final JTextField optionField;

        private VmOptionPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(gb);
            LineTextFieldPanel classpathPanel = new LineTextFieldPanel("");
            classpathPanel.setBorder(BorderFactory.createTitledBorder("classpath"));
            this.classpathField = classpathPanel.getTextField();
            String classPath = System.getProperty("java.class.path");
            StringBuffer buffer = new StringBuffer();
            StringTokenizer st = new StringTokenizer(classPath, ";");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                File pathFile = new File(path);
                String absolutePath = pathFile.getAbsolutePath();
                if (absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                    absolutePath = String.valueOf(absolutePath) + "\\";
                }
                buffer.append(absolutePath);
                ProfileDialog.this.classPathes.add(absolutePath);
                if (!st.hasMoreTokens()) continue;
                buffer.append(";");
            }
            this.classpathField.setText(buffer.toString());
            JButton classpathButton = new JButton("add...");
            classpathPanel.add(classpathButton);
            LineTextFieldPanel optionPanel = new LineTextFieldPanel("");
            optionPanel.setBorder(BorderFactory.createTitledBorder("vm options"));
            this.optionField = optionPanel.getTextField();
            cons.fill = 2;
            cons.anchor = 11;
            cons.gridx = 0;
            cons.weightx = 1.0;
            gb.setConstraints(classpathPanel, cons);
            this.add(classpathPanel);
            cons.weighty = 1.0;
            gb.setConstraints(optionPanel, cons);
            this.add(optionPanel);
            classpathButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JFileChooser fileChooser = new JFileChooser(".");
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new MyFileFilter(new String[]{"jar", "zip"}));
                    if (fileChooser.showOpenDialog(ProfileDialog.this) == 0) {
                        File file = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                        String absolutePath = file.getAbsolutePath();
                        if (absolutePath.lastIndexOf(".") == -1 && absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                            absolutePath = String.valueOf(absolutePath) + "\\";
                        }
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        if (!ProfileDialog.this.classPathes.contains(absolutePath)) {
                            ProfileDialog.this.classPathes.add(absolutePath);
                            VmOptionPanel.this.classpathField.setText(String.valueOf(VmOptionPanel.this.classpathField.getText()) + ";" + absolutePath);
                        }
                        ProfileDialog.this.updateCommand();
                    }
                }
            });
            this.classpathField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.this.classPathes.clear();
                    String text = VmOptionPanel.this.classpathField.getText();
                    StringTokenizer st = new StringTokenizer(text, ";,");
                    while (st.hasMoreTokens()) {
                        String path = st.nextToken();
                        File pathFile = new File(path = path.trim());
                        if (!pathFile.exists()) continue;
                        String absolutePath = pathFile.getAbsolutePath();
                        int point = absolutePath.lastIndexOf(".");
                        if (point == -1 && absolutePath.charAt(absolutePath.length() - 1) != '\\') {
                            absolutePath = String.valueOf(absolutePath) + "\\";
                        }
                        if (absolutePath.charAt(1) == ':') {
                            absolutePath = String.valueOf(Character.toUpperCase(absolutePath.charAt(0))) + absolutePath.substring(1);
                        }
                        if (ProfileDialog.this.classPathes.contains(absolutePath)) continue;
                        ProfileDialog.this.classPathes.add(absolutePath);
                    }
                    ProfileDialog.this.updateCommand();
                }
            });
            this.optionField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed(e);
                }

                private void changed(DocumentEvent event) {
                    ProfileDialog.this.options = VmOptionPanel.this.optionField.getText();
                    ProfileDialog.this.updateCommand();
                }
            });
        }
    }
}

