/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java;

import amida.staticdata.AccessModifier;
import amida.staticdata.Type;
import amida.staticdata.java.JavaStaticAnalyzeModule;
import amida.staticdata.java.JavaStaticDataAccessor;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaClassOrInterface;
import amida.staticdata.java.data.JavaField;
import amida.staticdata.java.data.JavaMethod;
import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.JavaTypeManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BcelModule
implements JavaStaticAnalyzeModule {
    private final Map<JavaClassOrInterface, JavaClass> classMap = new HashMap<JavaClassOrInterface, JavaClass>();
    private final Map<JavaMethod, Method> methodMap = new HashMap<JavaMethod, Method>();
    private final Map<JavaField, Field> fieldMap = new HashMap<JavaField, Field>();

    private JavaClass getBcelClass(JavaClassOrInterface cl) {
        if (this.classMap.containsKey(cl)) {
            return this.classMap.get(cl);
        }
        try {
            JavaClass bcelClass = Repository.lookupClass((String)cl.getFullName());
            this.classMap.put(cl, bcelClass);
            return bcelClass;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method getBcelMethod(JavaMethod method) {
        if (this.methodMap.containsKey(method)) {
            return this.methodMap.get(method);
        }
        JavaClassOrInterface coi = (JavaClassOrInterface)method.getBelongClass();
        JavaClass bcelClass = this.getBcelClass(coi);
        if (bcelClass != null) {
            Method[] bcelMethods;
            Method[] methodArray = bcelMethods = bcelClass.getMethods();
            int n = bcelMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method bcelMethod = methodArray[n2];
                if (bcelMethod.getSignature().equals(method.getSignature())) {
                    this.methodMap.put(method, bcelMethod);
                    return bcelMethod;
                }
                ++n2;
            }
        }
        return null;
    }

    private Field getBcelField(JavaField field) {
        if (this.fieldMap.containsKey(field)) {
            return this.fieldMap.get(field);
        }
        JavaClassOrInterface coi = (JavaClassOrInterface)field.getBelongClass();
        JavaClass bcelClass = this.getBcelClass(coi);
        if (bcelClass != null) {
            Field[] bcelFields;
            Field[] fieldArray = bcelFields = bcelClass.getFields();
            int n = bcelFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field bcelField = fieldArray[n2];
                if (field.getName().equals(bcelField.getName())) {
                    this.fieldMap.put(field, bcelField);
                    return bcelField;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getSuperClassName(JavaClassOrInterface cl) {
        JavaClass bcelClass = this.getBcelClass(cl);
        if (bcelClass == null) {
            return null;
        }
        return bcelClass.getSuperclassName();
    }

    @Override
    public JavaClassOrInterface getSuperClass(JavaClassOrInterface cl) {
        if (cl.getFullName().equals("java.lang.Object")) {
            return null;
        }
        String superClassName = this.getSuperClassName(cl);
        if (superClassName != null) {
            return JavaStaticDataAccessor.getInstance().makeClass(superClassName);
        }
        return null;
    }

    @Override
    public boolean isAnalyableClassOrInterface(JavaClassOrInterface cl) {
        return this.getBcelClass(cl) != null;
    }

    @Override
    public String[] getImplementInterfaceNames(JavaClassOrInterface cl) {
        JavaClass bcelClass = this.getBcelClass(cl);
        if (bcelClass == null) {
            return null;
        }
        return bcelClass.getInterfaceNames();
    }

    @Override
    public JavaClassOrInterface[] getImplementInterfaces(JavaClassOrInterface cl) {
        String[] interfaceNames = this.getImplementInterfaceNames(cl);
        if (interfaceNames == null) {
            return null;
        }
        JavaClassOrInterface[] interfaces = new JavaClassOrInterface[interfaceNames.length];
        int i = 0;
        while (i < interfaceNames.length) {
            interfaces[i] = JavaStaticDataAccessor.getInstance().makeInterface(interfaceNames[i]);
            ++i;
        }
        return interfaces;
    }

    @Override
    public JavaMethod[] getMethods(JavaClassOrInterface cl) {
        JavaClass bcelClass = this.getBcelClass(cl);
        if (bcelClass == null) {
            return null;
        }
        Method[] bcelMethods = bcelClass.getMethods();
        JavaMethod[] javaMethods = new JavaMethod[bcelMethods.length];
        int i = 0;
        while (i < javaMethods.length) {
            JavaMethod javaMethod;
            Method bcelMethod = bcelMethods[i];
            JavaType returnType = JavaTypeManager.getTypeFromJavaNativeFormat(bcelMethod.getReturnType().getSignature());
            org.apache.bcel.generic.Type[] bcelArguments = bcelMethod.getArgumentTypes();
            Type[] parameters = new JavaType[bcelArguments.length];
            int j = 0;
            while (j < parameters.length) {
                parameters[j] = JavaTypeManager.getTypeFromJavaNativeFormat(bcelArguments[j].getSignature());
                ++j;
            }
            javaMethods[i] = javaMethod = JavaStaticDataAccessor.getInstance().makeMethod(cl, bcelMethod.getName(), returnType, parameters, bcelMethod.isStatic(), (AccessModifier)this.makeAccessModifier((AccessFlags)bcelMethod));
            this.methodMap.put(javaMethods[i], bcelMethod);
            ++i;
        }
        return javaMethods;
    }

    @Override
    public JavaField[] getFields(JavaClassOrInterface cl) {
        JavaClass bcelClass = this.getBcelClass(cl);
        if (bcelClass == null) {
            return null;
        }
        Field[] bcelFields = bcelClass.getFields();
        JavaField[] fields = new JavaField[bcelFields.length];
        int i = 0;
        while (i < bcelFields.length) {
            Field field = bcelFields[i];
            String fieldName = field.getName();
            boolean isStatic = field.isStatic();
            JavaType type = JavaTypeManager.getTypeFromJavaNativeFormat(field.getType().getSignature());
            fields[i] = JavaField.getField(cl, fieldName);
            if (fields[i] == null) {
                fields[i] = JavaField.makeField(cl, fieldName, type, this.makeAccessModifier((AccessFlags)field), isStatic);
            }
            ++i;
        }
        return fields;
    }

    @Override
    public JavaAccessModifier getAccessModifier(JavaMethod method) {
        Method bcelMethod = this.getBcelMethod(method);
        return this.makeAccessModifier((AccessFlags)bcelMethod);
    }

    @Override
    public JavaAccessModifier getAccessModifier(JavaField field) {
        Field bcelField = this.getBcelField(field);
        return this.makeAccessModifier((AccessFlags)bcelField);
    }

    private JavaAccessModifier makeAccessModifier(AccessFlags flag) {
        if (flag != null) {
            if (flag.isPublic()) {
                return JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.PUBLIC);
            }
            if (flag.isProtected()) {
                return JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.PROTECTED);
            }
            if (flag.isPrivate()) {
                return JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.PRIVATE);
            }
            return JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.PACKAGE);
        }
        return JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED);
    }

    @Override
    public boolean isAbstruct(JavaMethod method) {
        Method bcelMethod = this.getBcelMethod(method);
        if (bcelMethod != null) {
            return bcelMethod.isAbstract();
        }
        return false;
    }

    @Override
    public boolean isStatic(JavaMethod method) {
        Method bcelMethod = this.getBcelMethod(method);
        if (bcelMethod != null) {
            return bcelMethod.isStatic();
        }
        return false;
    }

    @Override
    public boolean isStatic(JavaField field) {
        Field bcelField = this.getBcelField(field);
        if (bcelField != null) {
            return bcelField.isStatic();
        }
        return false;
    }
}

