/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java;

import amida.staticdata.AccessModifier;
import amida.staticdata.ClassData;
import amida.staticdata.Field;
import amida.staticdata.IllegalStaticDataConditionException;
import amida.staticdata.MethodData;
import amida.staticdata.StaticDataAccessor;
import amida.staticdata.Type;
import amida.staticdata.java.JavaStaticDataBuilder;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaClassOrInterface;
import amida.staticdata.java.data.JavaField;
import amida.staticdata.java.data.JavaMethod;
import amida.staticdata.java.data.JavaPackage;
import amida.staticdata.java.data.JavaType;
import amida.utility.Pair;

public class JavaStaticDataAccessor
extends StaticDataAccessor {
    private static JavaStaticDataAccessor singleton = new JavaStaticDataAccessor();
    private JavaStaticDataBuilder builder = null;

    public static JavaStaticDataAccessor getInstance() {
        return singleton;
    }

    private JavaStaticDataAccessor() {
    }

    private Pair<String, String> separateNames(String fullClassName) {
        String packageName = null;
        String coiName = null;
        int index = fullClassName.lastIndexOf(46);
        if (index == -1) {
            index = fullClassName.lastIndexOf(47);
        }
        if (index == -1) {
            packageName = "";
            coiName = fullClassName;
        } else {
            packageName = fullClassName.substring(0, index);
            coiName = fullClassName.substring(index + 1);
        }
        return new Pair<String, String>(packageName, coiName);
    }

    public void buildStaticClassData(JavaClassOrInterface jcoi) {
        if (this.builder != null && jcoi != null) {
            this.builder.buildClassData(jcoi);
        }
    }

    public void buildStaticMethodData(JavaMethod method) {
        if (this.builder != null && method != null) {
            this.builder.buildMethodData(method);
        }
    }

    public void buildStaticFieldData(JavaField field) {
        if (this.builder != null && field != null) {
            this.builder.buildFieldData(field);
        }
    }

    public JavaPackage makePackage(String packageName) {
        return JavaPackage.makePackage(packageName);
    }

    public JavaPackage getPackage(String packageName) {
        return JavaPackage.getPackage(packageName);
    }

    public boolean hasPackage(String packageName) {
        return JavaPackage.getPackage(packageName) != null;
    }

    public boolean hasClass(String className) {
        return this.getClass(className) != null;
    }

    public boolean hasInterface(String interfaceName) {
        return this.getInterface(interfaceName) != null;
    }

    public boolean hasClassOrInterface(String name) {
        return this.hasClass(name) || this.hasInterface(name);
    }

    @Override
    public boolean hasClassData(String fullClassName) {
        return this.hasClassOrInterface(fullClassName);
    }

    public JavaClassOrInterface getClass(JavaPackage pack, String className) throws IllegalStaticDataConditionException {
        return JavaClassOrInterface.getClass(pack, className);
    }

    public JavaClassOrInterface getClass(String packageName, String className) throws IllegalStaticDataConditionException {
        JavaPackage pack = this.getPackage(packageName);
        if (pack == null) {
            return null;
        }
        return this.getClass(pack, className);
    }

    public JavaClassOrInterface getClass(String fullName) throws IllegalStaticDataConditionException {
        Pair<String, String> names = this.separateNames(fullName);
        return this.getClass(names.getFirst(), names.getSecond());
    }

    public JavaClassOrInterface getInterface(JavaPackage pack, String interfaceName) throws IllegalStaticDataConditionException {
        return JavaClassOrInterface.getInterface(pack, interfaceName);
    }

    public JavaClassOrInterface getInterface(String packageName, String interfaceName) throws IllegalStaticDataConditionException {
        JavaPackage pack = this.getPackage(packageName);
        if (pack == null) {
            return null;
        }
        return this.getInterface(pack, interfaceName);
    }

    public JavaClassOrInterface getInterface(String fullName) throws IllegalStaticDataConditionException {
        Pair<String, String> names = this.separateNames(fullName);
        return this.getInterface(names.getFirst(), names.getSecond());
    }

    public JavaClassOrInterface getClassOrInterface(JavaPackage pack, String name) {
        return JavaClassOrInterface.getClassOrInterface(pack, name);
    }

    public JavaClassOrInterface getClassOrInterface(String packageName, String name) {
        JavaPackage pack = this.getPackage(packageName);
        if (pack == null) {
            return null;
        }
        return this.getClassOrInterface(pack, name);
    }

    public JavaClassOrInterface getClassOrInterface(String fullName) {
        Pair<String, String> names = this.separateNames(fullName);
        return this.getClassOrInterface(names.getFirst(), names.getSecond());
    }

    @Override
    public ClassData getClassData(String fullName) {
        return this.getClassOrInterface(fullName);
    }

    public JavaClassOrInterface makeClass(JavaPackage pack, String className) throws IllegalStaticDataConditionException {
        JavaClassOrInterface newClass = JavaClassOrInterface.makeClass(pack, className);
        this.buildStaticClassData(newClass);
        return newClass;
    }

    public JavaClassOrInterface makeClass(String packageName, String className) throws IllegalStaticDataConditionException {
        return this.makeClass(this.makePackage(packageName), className);
    }

    public JavaClassOrInterface makeClass(String fullName) throws IllegalStaticDataConditionException {
        Pair<String, String> names = this.separateNames(fullName);
        return this.makeClass(names.getFirst(), names.getSecond());
    }

    public JavaClassOrInterface makeInterface(JavaPackage pack, String interfaceName) throws IllegalStaticDataConditionException {
        JavaClassOrInterface newClass = JavaClassOrInterface.makeInterface(pack, interfaceName);
        this.buildStaticClassData(newClass);
        return newClass;
    }

    public JavaClassOrInterface makeInterface(String packageName, String interfaceName) throws IllegalStaticDataConditionException {
        return this.makeInterface(this.makePackage(packageName), interfaceName);
    }

    public JavaClassOrInterface makeInterface(String fullName) throws IllegalStaticDataConditionException {
        Pair<String, String> names = this.separateNames(fullName);
        return this.makeInterface(names.getFirst(), names.getSecond());
    }

    public JavaClassOrInterface makeClassOrInterface(JavaPackage pack, String name) {
        JavaClassOrInterface newClass = JavaClassOrInterface.makeClassOrInterface(pack, name);
        this.buildStaticClassData(newClass);
        return newClass;
    }

    public JavaClassOrInterface makeClassOrInterface(String packageName, String name) {
        return this.makeClassOrInterface(this.makePackage(packageName), name);
    }

    public JavaClassOrInterface makeClassOrInterface(String fullName) {
        Pair<String, String> names = this.separateNames(fullName);
        return this.makeClassOrInterface(names.getFirst(), names.getSecond());
    }

    @Override
    public ClassData makeClassData(String fullClassName) {
        return this.makeClassOrInterface(fullClassName);
    }

    @Override
    public MethodData makeMethodData(ClassData cl, String name, Type returnType, Type[] argTypes, boolean isStatic, AccessModifier modifier) {
        if (cl instanceof JavaClassOrInterface && returnType instanceof JavaType && argTypes instanceof JavaType[] && modifier instanceof JavaAccessModifier) {
            JavaMethod newMethod = JavaMethod.makeMethod((JavaClassOrInterface)cl, (JavaType)returnType, name, (JavaType[])argTypes, isStatic, (JavaAccessModifier)modifier);
            this.buildStaticMethodData(newMethod);
            return newMethod;
        }
        return null;
    }

    public JavaMethod makeMethod(ClassData cl, String name, Type returnType, Type[] argTypes, boolean isStatic, AccessModifier modifier) {
        return (JavaMethod)this.makeMethodData(cl, name, returnType, argTypes, isStatic, modifier);
    }

    public JavaMethod makeMethod(String fullClassName, JavaType returnType, String methodName, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        return (JavaMethod)this.makeMethodData(this.makeClassOrInterface(fullClassName), methodName, returnType, args, isStatic, modifier);
    }

    public JavaMethod makeMethod(String packageName, String coiName, JavaType returnType, String methodName, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        JavaClassOrInterface coi = this.makeClassOrInterface(packageName, coiName);
        return (JavaMethod)this.makeMethodData(coi, methodName, returnType, args, isStatic, modifier);
    }

    public JavaMethod makeMethod(JavaPackage pack, String coiName, JavaType returnType, String methodName, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        return (JavaMethod)this.makeMethodData(this.makeClassOrInterface(pack, coiName), methodName, returnType, args, isStatic, modifier);
    }

    public JavaStaticDataBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(JavaStaticDataBuilder builder) {
        this.builder = builder;
    }

    @Override
    public Field makeField(ClassData cl, String name, Type type, boolean isStatic, AccessModifier modifier) {
        if (cl instanceof JavaClassOrInterface && type instanceof JavaType && modifier instanceof JavaAccessModifier) {
            JavaField field = JavaField.makeField((JavaClassOrInterface)cl, name, (JavaType)type, (JavaAccessModifier)modifier, isStatic);
            this.buildStaticFieldData(field);
            return field;
        }
        return null;
    }
}

