/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java;

import amida.staticdata.ClassData;
import amida.staticdata.Field;
import amida.staticdata.MethodData;
import amida.staticdata.StaticDataBuildFilter;
import amida.staticdata.StaticDataBuilder;
import amida.staticdata.java.JavaStaticAnalyzeModule;
import amida.staticdata.java.data.JavaClassOrInterface;
import amida.staticdata.java.data.JavaField;
import amida.staticdata.java.data.JavaMethod;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class JavaStaticDataBuilder
implements StaticDataBuilder {
    private final JavaStaticAnalyzeModule module;
    private final List<StaticDataBuildFilter> filters = new LinkedList<StaticDataBuildFilter>();
    private final Set<JavaClassOrInterface> buildedClasses = new HashSet<JavaClassOrInterface>();
    private final Set<JavaMethod> buildedMethods = new HashSet<JavaMethod>();
    private final Set<JavaField> buildedFields = new HashSet<JavaField>();

    public JavaStaticDataBuilder(JavaStaticAnalyzeModule module) {
        this.module = module;
    }

    @Override
    public boolean buildClassData(ClassData cl) {
        JavaField[] fields;
        JavaMethod[] methods;
        int n;
        JavaClassOrInterface[] interfaces;
        if (cl == null || this.buildedClasses.contains(cl) || this.isFilterOutClass(cl) || !(cl instanceof JavaClassOrInterface)) {
            return true;
        }
        JavaClassOrInterface jcoi = (JavaClassOrInterface)cl;
        if (!this.module.isAnalyableClassOrInterface(jcoi)) {
            return false;
        }
        this.buildedClasses.add(jcoi);
        JavaClassOrInterface superClass = this.module.getSuperClass(jcoi);
        if (superClass != null) {
            this.buildClassData(superClass);
            cl.addSuperClass(superClass);
        }
        if ((interfaces = this.module.getImplementInterfaces(jcoi)) != null && interfaces.length > 0) {
            JavaClassOrInterface[] javaClassOrInterfaceArray = interfaces;
            n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClassOrInterface javaInterface = javaClassOrInterfaceArray[n2];
                this.buildClassData(javaInterface);
                cl.addSuperClass(javaInterface);
                ++n2;
            }
        }
        if ((methods = this.module.getMethods(jcoi)) != null && methods.length > 0) {
            JavaMethod[] javaMethodArray = methods;
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                JavaMethod javaMethod = javaMethodArray[n];
                this.buildMethodData(javaMethod);
                ++n;
            }
        }
        if ((fields = this.module.getFields(jcoi)) != null && fields.length > 0) {
            JavaField[] javaFieldArray = fields;
            int n4 = fields.length;
            int n5 = 0;
            while (n5 < n4) {
                JavaField field = javaFieldArray[n5];
                this.buildFieldData(field);
                ++n5;
            }
        }
        return true;
    }

    @Override
    public boolean buildMethodData(MethodData method) {
        if (!(method instanceof JavaMethod) || this.isFilterOutMethod(method)) {
            return false;
        }
        if (this.buildedMethods.contains(method)) {
            return true;
        }
        JavaMethod javaMethod = (JavaMethod)method;
        JavaClassOrInterface coi = (JavaClassOrInterface)javaMethod.getBelongClass();
        this.buildedMethods.add(javaMethod);
        if (!this.buildedClasses.contains(coi)) {
            this.buildClassData(coi);
        }
        javaMethod.resolveOverWride();
        if (this.module != null) {
            javaMethod.setAccessModifier(this.module.getAccessModifier(javaMethod));
            javaMethod.setAbstractMethod(this.module.isAbstruct(javaMethod));
            return true;
        }
        return false;
    }

    public boolean buildFieldData(Field field) {
        if (!(field instanceof JavaField)) {
            return false;
        }
        if (this.buildedFields.contains(field)) {
            return true;
        }
        JavaField javaField = (JavaField)field;
        JavaClassOrInterface coi = (JavaClassOrInterface)field.getBelongClass();
        if (!this.buildedClasses.contains(coi)) {
            this.buildClassData(coi);
        }
        if (this.module != null) {
            javaField.setAccessModifier(this.module.getAccessModifier(javaField));
            javaField.setStatic(this.module.isStatic(javaField));
            return true;
        }
        return false;
    }

    public void addBuildFilter(StaticDataBuildFilter filter) {
        this.filters.add(filter);
    }

    public void removeBuildFilter(StaticDataBuildFilter filter) {
        this.filters.remove(filter);
    }

    private boolean isFilterOutClass(ClassData cl) {
        for (StaticDataBuildFilter filter : this.filters) {
            if (!filter.filterOutClass(cl)) continue;
            return true;
        }
        return false;
    }

    private boolean isFilterOutMethod(MethodData method) {
        for (StaticDataBuildFilter filter : this.filters) {
            if (!filter.filterOutMethod(method)) continue;
            return true;
        }
        return false;
    }
}

