/*
 * Decompiled with CFR 0.152.
 */
package amida.utility;

import java.io.IOException;
import java.io.Reader;

public class FileRangeReader
extends Reader {
    private Reader r;
    private long size;
    private long offset;

    public FileRangeReader(Reader reader, long pBegin, long pEnd) throws IOException {
        this.r = reader;
        this.r.skip(pBegin);
        this.size = pEnd - pBegin;
        this.offset = 0L;
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        if (this.size == this.offset) {
            return -1;
        }
        if (this.size < 0L) {
            return this.r.read(buf, off, len);
        }
        int bytes = this.r.read(buf, off, len);
        if (this.offset > this.size - (long)bytes) {
            bytes = (int)(this.size - this.offset);
        }
        this.offset += (long)bytes;
        return bytes;
    }
}

