/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.diagram.sequencediagram.Sequence;
import amida.viewer.filter.AbstractFilter;
import amida.viewer.filter.StringMatcher;
import amida.viewer.filter.TimestampMatcher;

public class MethodFilter
extends AbstractFilter {
    public static final int TYPE_SHOW = 0;
    public static final int TYPE_FOLD = 1;
    public static final int TYPE_HIDE = 2;
    public static final int TYPE_DELETE = 3;
    private int type;
    private String methodCondition;
    private String timestampCondition;
    private StringMatcher methodMatcher;
    private TimestampMatcher timestampMatcher;

    public MethodFilter() {
        this.setMethodCondition("");
        this.setTimestampCondition("");
    }

    public void setMethodCondition(String methodCondition) {
        this.methodCondition = methodCondition;
        this.methodMatcher = new StringMatcher(methodCondition);
    }

    public String getMethodCondition() {
        return this.methodCondition;
    }

    public void setTimestampCondition(String timestampCondition) {
        this.timestampCondition = timestampCondition.trim();
        this.timestampMatcher = new TimestampMatcher(timestampCondition);
    }

    public String getTimestampCondition() {
        return this.timestampCondition;
    }

    public boolean matchTimestamp(int timestamp) {
        return this.timestampMatcher.match(timestamp);
    }

    @Override
    public int getTypeIndex() {
        return this.getVisibleState();
    }

    @Override
    public void setTypeIndex(int value) {
        this.setVisibleState(value);
    }

    public int getVisibleState() {
        return this.type;
    }

    public void setVisibleState(int value) {
        this.type = value;
    }

    public boolean matchMethod(String methodName) {
        return this.methodMatcher.match(methodName);
    }

    public boolean match(Sequence seq) {
        return seq.getType() == 0 && this.matchTimestamp(seq.getNode().getCallIndex()) && this.matchPackage(seq.getNode().getMethod().getBelongClass().getNameSpace()) && this.matchClass(seq.getNode().getMethod().getBelongClass().getName()) && this.matchObject(seq.getEnd().getIds()) && this.matchMethod(seq.getNode().getMethod().getName());
    }

    public MethodFilter copy() {
        MethodFilter clone = new MethodFilter();
        this.copyAttributesTo(clone);
        clone.setMethodCondition(this.getMethodCondition());
        clone.setTimestampCondition(this.getTimestampCondition());
        return clone;
    }
}

