/*
 * Decompiled with CFR 0.152.
 */
package amida.library;

import amida.library.LineTextFieldPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckTextFieldPanel
extends JPanel {
    private final JCheckBox checkBox;
    private final LineTextFieldPanel textField;
    private final String defaultText;
    private String backupText;

    public CheckTextFieldPanel(String checkText, String defaultText) {
        this.defaultText = defaultText;
        this.checkBox = new JCheckBox(checkText);
        this.textField = new LineTextFieldPanel(defaultText);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        this.setLayout(gb);
        cons.fill = 2;
        cons.anchor = 18;
        cons.gridx = 0;
        cons.weightx = 1.0;
        gb.setConstraints(this.checkBox, cons);
        this.add(this.checkBox);
        cons.weighty = 1.0;
        gb.setConstraints(this.textField, cons);
        this.add(this.textField);
        this.unSelected();
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CheckTextFieldPanel.this.checkBox.isSelected()) {
                    CheckTextFieldPanel.this.selected();
                } else {
                    CheckTextFieldPanel.this.unSelected();
                }
            }
        });
    }

    public void selected() {
        if (this.backupText != null) {
            this.setText(this.backupText);
        }
        this.textField.setTextEnabled(true);
    }

    public void unSelected() {
        String temp = this.getText();
        if (!temp.equals("")) {
            this.backupText = temp;
        }
        this.setText(this.defaultText);
        this.textField.setTextEnabled(false);
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void clear() {
        this.checkBox.setSelected(false);
        this.unSelected();
        this.setText(this.defaultText);
        this.backupText = null;
    }

    public void check() {
        this.checkBox.setSelected(true);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setEnabled(boolean b) {
        this.checkBox.setEnabled(b);
        this.textField.setEnabled(b);
    }
}

