/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor;

import amida.library.ProgressListener;
import amida.logcompactor.foldrule.LoopFoldRule;
import amida.logcompactor.foldrule.RecursiveCallFoldRule;
import amida.node.CallNode;
import amida.node.CallTree;
import amida.node.LoopNode;
import amida.node.Node;
import amida.node.NodeIterator;
import amida.node.NodeList;
import amida.node.TopRecursiveBlockNode;
import amida.node.comparator.SameMethodNodeComparator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Compactor {
    private List listeners = new ArrayList();
    private int treeEndNum = 0;
    private int endCount = 0;

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    private void fireProgress(int value) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ProgressListener listener = (ProgressListener)it.next();
            listener.progress(value, this.treeEndNum);
        }
    }

    public void omitRecursiveCall(NodeList nodes) {
        this.endCount = 0;
        this.setTreeEndNum(this.treeEndCount(nodes));
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        NodeIterator it = nodes.nodeIterator();
        SameMethodNodeComparator comp = new SameMethodNodeComparator(1);
        HashSet<Node> alreadyCountEnd = new HashSet<Node>();
        Stack<Node> nodeStack = new Stack<Node>();
        Stack<NodeIterator> iteratorStack = new Stack<NodeIterator>();
        while (it.hasNext() || !iteratorStack.empty()) {
            Node node;
            if (!it.hasNext()) {
                it = (NodeIterator)iteratorStack.pop();
                node = (Node)nodeStack.pop();
                continue;
            }
            boolean hasRecursiveCallTopNode = false;
            Iterator stackIt = nodeStack.iterator();
            while (stackIt.hasNext()) {
                if (!(stackIt.next() instanceof TopRecursiveBlockNode)) continue;
                hasRecursiveCallTopNode = true;
            }
            node = (Node)it.next();
            while (node.hasChildren()) {
                if (node instanceof TopRecursiveBlockNode) {
                    hasRecursiveCallTopNode = true;
                }
                nodeStack.push(node);
                iteratorStack.push(it);
                it = node.nodeIterator();
                node = (Node)it.next();
            }
            nodeStack.push(node);
            iteratorStack.push(it);
            CallNode represent = RecursiveCallFoldRule.checkRecursiveCall(nodeStack, iteratorStack, comp);
            if (represent != null) {
                CallNode before = represent;
                Node parent = represent.getParent();
                if (parent == null || !(parent instanceof TopRecursiveBlockNode)) {
                    try {
                        if (!hasRecursiveCallTopNode) {
                            this.fireProgress(this.endCount);
                            this.endCount += this.treeEndCountNotRecursiveNode(represent, alreadyCountEnd);
                        }
                        before = (CallNode)represent.clone();
                        before.setParent(represent.getParent());
                    }
                    catch (CloneNotSupportedException e) {
                        System.err.println("can not clone at omitRecursive");
                    }
                }
                List lists = RecursiveCallFoldRule.makeRecursiveList(nodeStack, iteratorStack, comp, represent);
                List recList = (List)lists.get(0);
                List itList = (List)lists.get(1);
                List includes = RecursiveCallFoldRule.getIncludeList(recList, comp);
                nodeStack.pop();
                it = (NodeIterator)iteratorStack.pop();
                if (includes.size() <= 0) continue;
                NodeIterator it2 = it;
                int i = 0;
                while (i < includes.size()) {
                    int position = (Integer)includes.get(i);
                    node = (Node)recList.get(position);
                    if (i > 0) {
                        ((CallNode)node).setRecursive(true);
                    }
                    it2.set(node);
                    if (position != recList.size() - 1) {
                        it2 = (NodeIterator)itList.get(position + 1);
                    }
                    ++i;
                }
                if (parent == null || !(parent instanceof TopRecursiveBlockNode)) {
                    CallNode after = (CallNode)recList.get((Integer)includes.get(0));
                    TopRecursiveBlockNode recursive = new TopRecursiveBlockNode(after, before);
                    it.set(recursive);
                }
                it.previous();
                continue;
            }
            if (!hasRecursiveCallTopNode) {
                this.fireProgress(this.endCount);
                ++this.endCount;
                alreadyCountEnd.add(node);
            }
            nodeStack.pop();
            it = (NodeIterator)iteratorStack.pop();
        }
        this.fireProgress(this.treeEndNum);
        nodes.getCallTree().fireDataChange();
    }

    public void omitRecursiveCall(CallTree tree) {
        NodeList nodes = tree.getTopNodeList();
        this.omitRecursiveCall(nodes);
    }

    private int treeEndCount(CallTree tree) {
        return this.treeEndCount(tree.getTopNodeList());
    }

    private int treeEndCount(NodeList list) {
        NodeIterator it = list.nodeIterator();
        Stack<NodeIterator> stack = new Stack<NodeIterator>();
        int count = 0;
        while (it.hasNext() || !stack.isEmpty()) {
            if (it.hasNext()) {
                Node node = (Node)it.next();
                if (node.hasChildren()) {
                    stack.push(it);
                    it = it.nextIterator();
                    continue;
                }
                ++count;
                continue;
            }
            it = (NodeIterator)stack.pop();
        }
        return count;
    }

    private int treeEndCountNotRecursiveNode(Node top, Set notCount) {
        NodeIterator it = top.nodeIterator();
        Stack<NodeIterator> stack = new Stack<NodeIterator>();
        int count = 0;
        while (it.hasNext() || !stack.isEmpty()) {
            if (it.hasNext()) {
                Node node = (Node)it.next();
                if (node instanceof TopRecursiveBlockNode) continue;
                if (node.hasChildren()) {
                    stack.push(it);
                    it = it.nextIterator();
                    continue;
                }
                if (notCount.contains(node)) continue;
                ++count;
                continue;
            }
            it = (NodeIterator)stack.pop();
        }
        return count;
    }

    public void foldLoop(LoopFoldRule rule, CallTree callTree) {
        if (rule == null || callTree == null) {
            return;
        }
        this.setTreeEndNum(this.treeEndCount(callTree));
        this.endCount = 0;
        this.foldLoop_i(callTree.getTopNodeList(), rule);
        this.fireProgress(this.treeEndNum);
        callTree.fireDataChange();
    }

    public void foldLoop(NodeList list, LoopFoldRule rule) {
        this.setTreeEndNum(this.treeEndCount(list));
        this.endCount = 0;
        this.foldLoop_i(list, rule);
        this.fireProgress(this.treeEndNum);
        list.getCallTree().fireDataChange();
    }

    private void foldLoop_i(NodeList list, LoopFoldRule rule) {
        Node parent = list.getParent();
        NodeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.hasChildren()) {
                this.fireProgress(this.endCount++);
                continue;
            }
            this.foldLoop_i(node.getChildren(), rule);
        }
        it.reset();
        int callNodeNum = 1;
        ArrayList<Node> compareList = new ArrayList<Node>(it.size() / 2);
        while (callNodeNum * 2 <= it.countCallNode()) {
            NodeIterator.NodeIteratorView itView = it.getView();
            while (it.hasNext()) {
                List representList;
                ((NodeIterator)itView).reset();
                ArrayList<Node> firstList = new ArrayList<Node>(callNodeNum);
                int callNodeCount1 = 0;
                while (callNodeCount1 < callNodeNum && itView.hasNext()) {
                    Node node = itView.nextNode();
                    firstList.add(node);
                    callNodeCount1 += node.getCallNodeNum();
                }
                compareList.clear();
                int callNodeCount2 = 0;
                while (callNodeCount2 < callNodeNum && itView.hasNext()) {
                    Node node = itView.nextNode();
                    compareList.add(node);
                    callNodeCount2 += node.getCallNodeNum();
                }
                if (callNodeNum == callNodeCount1 && callNodeNum == callNodeCount2 && (representList = rule.makeRepresentList(firstList, compareList)) != null) {
                    int countLoopNum = 1;
                    int lastNodesCount = 0;
                    while (callNodeNum == callNodeCount1 && callNodeNum == callNodeCount2 && rule.checkLoop(representList, compareList)) {
                        ++countLoopNum;
                        compareList.clear();
                        callNodeCount2 = 0;
                        lastNodesCount = 0;
                        while (callNodeCount2 < callNodeNum && itView.hasNext()) {
                            Node node = itView.nextNode();
                            compareList.add(node);
                            callNodeCount2 += node.getCallNodeNum();
                            ++lastNodesCount;
                        }
                    }
                    LoopNode newLoopNode = rule.makeNewLoop(list.getCallTree());
                    int gap = itView.nextIndex() - lastNodesCount - it.nextIndex();
                    it.add(newLoopNode);
                    int i = 0;
                    while (i < gap) {
                        Node node = it.nextNode();
                        it.remove();
                        newLoopNode.addHiddenChild(node);
                        ++i;
                    }
                    newLoopNode.addLoopNum(countLoopNum);
                    if (newLoopNode.getLoopNum(0) == 0) {
                        System.out.println("test");
                    }
                    newLoopNode.setRule(rule);
                    Iterator repIt = representList.iterator();
                    while (repIt.hasNext()) {
                        newLoopNode.addCoreChild((Node)repIt.next());
                    }
                    continue;
                }
                it.next();
            }
            ++callNodeNum;
            it.reset();
        }
    }

    public int getTreeEndNum() {
        return this.treeEndNum;
    }

    public void setTreeEndNum(int treeEndNum) {
        this.treeEndNum = treeEndNum;
    }
}

