/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.gui;

import amida.library.DataChangeListener;
import amida.logcompactor.gui.LineNumPanel;
import amida.logcompactor.gui.LogTextArea;
import amida.logcompactor.gui.LoopCanvas;
import amida.logcompactor.gui.SearchDialog;
import amida.node.CallTreeManager;
import amida.node.NodeList;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class LogTextAreaFrame
extends JFrame
implements DataChangeListener {
    private static final Insets MARGIN = new Insets(0, 50, 0, 0);
    private final LogTextArea textArea;
    private final JScrollPane textScroll;
    private final JSplitPane split;
    private final LoopCanvas drawLoopCanvas;
    private final LineNumPanel linePanel;
    private final SearchDialog searchDialog;

    public LogTextAreaFrame() {
        super("Trace Log");
        Container cp = this.getContentPane();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        this.searchDialog = new SearchDialog(this);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem searchMenuItem = new JMenuItem("Search");
        editMenu.add(searchMenuItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
        searchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LogTextAreaFrame.this.searchDialog.setVisible(true);
            }
        });
        this.textArea = new LogTextArea(this, 500, 600);
        this.drawLoopCanvas = new LoopCanvas(this, this.textArea);
        this.split = new JSplitPane(1, true);
        this.split.setLeftComponent(this.textArea);
        this.split.setRightComponent(this.drawLoopCanvas);
        this.split.setDividerSize(2);
        this.textScroll = new JScrollPane();
        this.textScroll.getViewport().add(this.split);
        this.textScroll.setHorizontalScrollBarPolicy(31);
        this.textScroll.getVerticalScrollBar().setUnitIncrement(100);
        this.textArea.setScrollBar(this.textScroll.getVerticalScrollBar());
        this.linePanel = new LineNumPanel();
        this.linePanel.setLayout(new FlowLayout(0));
        cons.fill = 1;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        gb.setConstraints(this.textScroll, cons);
        cp.add(this.textScroll);
        cons.gridy = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        gb.setConstraints(this.linePanel, cons);
        cp.add(this.linePanel);
    }

    public void renew() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeList nodes = CallTreeManager.getInstance().getCallTree(0).getTopNodeList();
                LogTextAreaFrame.this.textArea.setNodeList(nodes);
                LogTextAreaFrame.this.textArea.load();
                LogTextAreaFrame.this.drawLoopCanvas.renew();
                LogTextAreaFrame.this.linePanel.setMaxLine(CallTreeManager.getInstance().getCallTree(0).getMethodCallNum());
                LogTextAreaFrame.this.linePanel.setNowLine(LogTextAreaFrame.this.textArea.getLineCount() / 2);
                LogTextAreaFrame.this.textScroll.revalidate();
                LogTextAreaFrame.this.textArea.repaint();
                LogTextAreaFrame.this.drawLoopCanvas.repaint();
            }
        });
    }

    public void setVisible(boolean b) {
        if (CallTreeManager.getInstance().getCallTreeNum() > 0) {
            if (!this.isVisible() && b) {
                CallTreeManager.getInstance().getCallTree(0).addDataChangeListener(this);
                this.renew();
                this.pack();
            } else if (this.isVisible() && !b) {
                CallTreeManager.getInstance().getCallTree(0).removeDataChangeListener(this);
            }
        }
        super.setVisible(b);
    }

    public void scroll(int position) {
        double max = this.getSize().getHeight();
        double rate = (double)position / max;
        BoundedRangeModel model = this.textScroll.getVerticalScrollBar().getModel();
        int value = (int)((double)model.getMaximum() * rate);
        model.setValue(value);
    }

    public void load(NodeList top) {
        this.textArea.setNodeList(top);
        this.textArea.load();
        this.textArea.repaint();
        int lineNum = this.textArea.getLineCount();
        this.linePanel.setNowLine(lineNum);
        this.linePanel.setMaxLine(lineNum);
        this.drawLoopCanvas.renew();
        this.drawLoopCanvas.repaint();
        System.gc();
        this.textScroll.revalidate();
    }

    public void load() {
        this.load(CallTreeManager.getInstance().getCallTree(0).getTopNodeList());
    }

    public void resetLineNum() {
        int line = this.textArea.getLineCount();
        this.linePanel.setMaxLine(line);
        this.linePanel.setNowLine(line);
    }

    protected LogTextArea getTextArea() {
        return this.textArea;
    }

    protected JScrollPane getScrollPane() {
        return this.textScroll;
    }

    public void dataChanged() {
        this.renew();
    }
}

