/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.gui;

import amida.logcompactor.gui.DrawLoopSet;
import amida.logcompactor.gui.LogTextArea;
import amida.logcompactor.gui.LogTextAreaFrame;
import amida.node.BlockNode;
import amida.node.CallNode;
import amida.node.CallTreeManager;
import amida.node.LoopNode;
import amida.node.MethodMissingLoopNode;
import amida.node.Node;
import amida.node.NodeList;
import amida.node.ObjectDifferenceLoopNode;
import amida.node.SimpleLoopNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

class LoopCanvas
extends JPanel {
    public static int MAX_LOOP_WIDTH = 100;
    private final LogTextArea text;
    private final LogTextAreaFrame frame;
    private List loopNodes = new ArrayList();
    private int maxDepth = 0;
    private int line;

    public LoopCanvas(final LogTextAreaFrame frame, LogTextArea area) {
        this.frame = frame;
        this.setPreferredSize(new Dimension(150, 50));
        this.setBackground(Color.white);
        this.text = area;
        this.text.setLoopCanvas(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int depth = x > MAX_LOOP_WIDTH ? 0 : (LoopCanvas.this.maxDepth == 0 ? 0 : (MAX_LOOP_WIDTH - x) / (MAX_LOOP_WIDTH / LoopCanvas.this.maxDepth) + 1);
                int line = e.getY() / LoopCanvas.this.text.getCharHeight();
                DrawLoopSet loop = null;
                if (depth > 0) {
                    ArrayList<DrawLoopSet> loopList = new ArrayList<DrawLoopSet>();
                    Iterator it = LoopCanvas.this.loopNodes.iterator();
                    while (it.hasNext()) {
                        DrawLoopSet temp = (DrawLoopSet)it.next();
                        if (line >= temp.getStart() && line <= temp.getEnd() && temp.getDepth() <= depth) {
                            loopList.add(temp);
                        }
                        if (line < temp.getStart()) break;
                    }
                    if (!loopList.isEmpty()) {
                        loop = (DrawLoopSet)loopList.get(loopList.size() - 1);
                    }
                }
                if (loop == null) {
                    LoopCanvas.this.text.setSelectedRange(-1, -1);
                } else if (e.getModifiers() == 16) {
                    LoopCanvas.this.text.setSelectedRange(loop.getStart(), loop.getEnd());
                } else if (e.getModifiers() == 4) {
                    loop.getNode().setFold(!loop.getNode().isFold());
                    LoopCanvas.this.text.load();
                    LoopCanvas.this.renew();
                    frame.getScrollPane().revalidate();
                    CallTreeManager.getInstance().getCallTree(0).fireDataChange();
                    LoopCanvas.this.text.setSelectedRange(loop.getStart(), loop.getEnd());
                }
                LoopCanvas.this.requestFocusInWindow();
                LoopCanvas.this.text.repaint();
                LoopCanvas.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void drawLoop(Graphics g, int start, int end, LoopNode node, int depth) {
        int maxNum;
        int minNum;
        if (node.isFold() && node.getLoopNums().size() != 0) {
            minNum = node.getLoopNum(0);
            maxNum = node.getLoopNum(node.getLoopNums().size() - 1);
        } else {
            minNum = 1;
            maxNum = 1;
        }
        int fontHeight = g.getFontMetrics().getHeight();
        int x = MAX_LOOP_WIDTH / this.maxDepth * (this.maxDepth - depth + 1);
        g.drawLine(0, (start - 1) * fontHeight + 3, x, (start - 1) * fontHeight + 3);
        g.drawLine(x, (start - 1) * fontHeight + 3, x, (int)(((double)(end + start) / 2.0 - 1.0) * (double)fontHeight + 3.0));
        String num = "" + minNum;
        if (minNum != maxNum) {
            num = String.valueOf(num) + "-" + maxNum;
        }
        int margin = g.getFontMetrics().stringWidth(num) / 2;
        g.drawString(num, x - margin, (int)((double)(end + start) / 2.0 * (double)fontHeight));
        g.drawLine(x, (int)((double)(end + start) / 2.0 * (double)fontHeight) + 5 - 3, x, end * fontHeight);
        g.drawLine(0, end * fontHeight, x, end * fontHeight);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        Iterator it = this.loopNodes.iterator();
        g.setColor(Color.black);
        while (it.hasNext()) {
            DrawLoopSet loop = (DrawLoopSet)it.next();
            LoopNode node = loop.getNode();
            if (node instanceof SimpleLoopNode) {
                g.setColor(Color.black);
                this.drawLoop(g, loop.getStart() + 1, loop.getEnd() + 1, node, loop.getDepth());
                continue;
            }
            if (node instanceof ObjectDifferenceLoopNode) {
                g.setColor(Color.blue);
                this.drawLoop(g, loop.getStart() + 1, loop.getEnd() + 1, node, loop.getDepth());
                continue;
            }
            if (!(node instanceof MethodMissingLoopNode)) continue;
            g.setColor(Color.red);
            this.drawLoop(g, loop.getStart() + 1, loop.getEnd() + 1, node, loop.getDepth());
        }
    }

    public void renew() {
        NodeList nodes = CallTreeManager.getInstance().getCallTree(0).getTopNodeList();
        this.maxDepth = 0;
        this.line = 0;
        this.loopNodes.clear();
        if (nodes != null) {
            this.loopListMaker(nodes.nodeIterator(), this.loopNodes, 1);
            this.setPreferredSize(new Dimension((int)this.getSize().getWidth(), (int)this.text.getPreferredSize().getHeight()));
        }
        this.revalidate();
    }

    private void loopListMaker(Iterator it, List loopList, int loopDepth) {
        if (loopDepth - 1 > this.maxDepth) {
            this.maxDepth = loopDepth - 1;
        }
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node instanceof CallNode) {
                ++this.line;
                this.loopListMaker(node.nodeIterator(), loopList, loopDepth);
                ++this.line;
                continue;
            }
            if (node instanceof LoopNode) {
                LoopNode loop = (LoopNode)node;
                DrawLoopSet loopSet = new DrawLoopSet(loop, this.line, this.line, loopDepth);
                loopList.add(loopSet);
                this.loopListMaker(node.nodeIterator(), loopList, loopDepth + 1);
                loopSet.setEnd(this.line - 1);
                continue;
            }
            if (!(node instanceof BlockNode)) continue;
            ++this.line;
            this.loopListMaker(node.nodeIterator(), loopList, loopDepth);
            ++this.line;
        }
    }
}

