/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.library.DataChangeListener;
import amida.library.LinkedListQueue;
import amida.node.CallNode;
import amida.node.CallTreeManager;
import amida.node.LoopNode;
import amida.node.Node;
import amida.node.NodeIterator;
import amida.node.NodeList;
import amida.node.TopRecursiveBlockNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.StringTokenizer;

public class CallTree {
    private static final int METHOD_EXIT = 1;
    private static final int METHOD_EXIT_EXCEPTION = 2;
    private static final int METHOD_ENTRY = 4;
    private static final int METHOD_ENTRY2 = 5;
    private static final String CLINIT = "<clinit>";
    private NodeList topNodeList = new NodeList(null, this);
    private List dataChangeListeners = new LinkedList();
    private Stack callStack = new Stack();
    private int methodCallNum = 0;
    private int inClinitCount = 0;

    protected CallTree() {
    }

    protected CallTree(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        this.makeNode(null, br);
        br.close();
    }

    public void makeNode(CallNode parent, BufferedReader br) throws IOException {
        String buffer;
        while ((buffer = br.readLine()) != null) {
            parent = this.makeNode(parent, buffer);
        }
        this.fireDataChange();
    }

    public void makeNode(CallNode parent, Queue queue) {
        String buffer;
        while ((buffer = (String)queue.poll()) != null) {
            parent = this.makeNode(parent, buffer);
        }
        this.fireDataChange();
    }

    public void makeNode(CallNode parent, LinkedListQueue queue) {
        String buffer;
        while ((buffer = (String)queue.poll()) != null) {
            parent = this.makeNode(parent, buffer);
        }
        this.fireDataChange();
    }

    public CallNode makeNode(CallNode parent, String text) {
        LinkedList tokens = new LinkedList();
        int judge = CallTree.lineParser(text, tokens);
        Iterator it = tokens.iterator();
        CallNode nextParent = parent;
        if (judge == 5 || judge == 4) {
            if (this.inClinitCount > 0) {
                ++this.inClinitCount;
            } else {
                String returnType = (String)it.next();
                String className = (String)it.next();
                Integer objectId = new Integer(Integer.parseInt((String)it.next()));
                int id = this.getProperId(objectId);
                String method = (String)it.next();
                method = method.substring(1, method.length());
                if (!CallTreeManager.noClinit || !method.equals(CLINIT)) {
                    String[] args = null;
                    if (judge == 5) {
                        StringTokenizer argSt = new StringTokenizer((String)it.next(), ",");
                        args = new String[argSt.countTokens()];
                        int i = 0;
                        while (argSt.hasMoreTokens()) {
                            args[i] = argSt.nextToken().intern();
                            ++i;
                        }
                    }
                    CallNode newNode = new CallNode(this, className, method, returnType, args, id, ++this.methodCallNum);
                    if (parent != null) {
                        parent.addChild(newNode);
                    } else {
                        this.topNodeList.add(newNode);
                    }
                    nextParent = newNode;
                    this.callStack.push(newNode);
                } else {
                    ++this.inClinitCount;
                }
            }
        } else if (judge == 1 || judge == 2) {
            if (this.inClinitCount > 0) {
                --this.inClinitCount;
            } else {
                if (!this.callStack.isEmpty()) {
                    this.callStack.pop();
                }
                nextParent = !this.callStack.isEmpty() ? (CallNode)this.callStack.peek() : null;
                if (parent != null) {
                    if (judge == 2) {
                        parent.setExitMode(2);
                        parent.setException((String)tokens.get(1));
                    } else {
                        parent.setExitMode(1);
                    }
                }
            }
        }
        return nextParent;
    }

    public static int lineParser(String line, List strings) {
        if (line.length() == 0) {
            return 0;
        }
        if (line.startsWith("//")) {
            return 0;
        }
        StringTokenizer st = new StringTokenizer(line, " (){\t");
        int tokenNum = st.countTokens();
        if (!st.hasMoreTokens()) {
            return 0;
        }
        String token = st.nextToken();
        strings.add(token);
        if (token.equals("}")) {
            if (st.hasMoreTokens()) {
                strings.add(st.nextToken());
            }
            return tokenNum;
        }
        if (tokenNum == 5 || tokenNum == 4) {
            while (st.hasMoreTokens()) {
                strings.add(st.nextToken());
            }
            return tokenNum;
        }
        return -1;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    public void fireDataChange() {
        Iterator it = this.dataChangeListeners.iterator();
        while (it.hasNext()) {
            DataChangeListener listener = (DataChangeListener)it.next();
            listener.dataChanged();
        }
    }

    public NodeList getTopNodeList() {
        return this.topNodeList;
    }

    public int getMethodCallNum() {
        return this.methodCallNum;
    }

    public CallNode getCurrentCallNode() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return (CallNode)this.callStack.peek();
    }

    public void clearCompressedInformations() {
        NodeList topNodeList = this.getTopNodeList();
        this.clearCompressedInformations_i(topNodeList);
        this.fireDataChange();
    }

    public void clearCompressedInfromations(NodeList nodes) {
        this.clearCompressedInformations_i(nodes);
        this.fireDataChange();
    }

    private void clearCompressedInformations_i(NodeList nodes) {
        NodeIterator it = nodes.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node instanceof TopRecursiveBlockNode) {
                CallNode resetNode = ((TopRecursiveBlockNode)node).getHiddenChild();
                it.set(resetNode);
                this.clearCompressedInformations_i(resetNode.getChildren());
                continue;
            }
            if (node instanceof LoopNode) {
                NodeList resetList = ((LoopNode)node).getHiddenChildren();
                Node parent = node.getParent();
                NodeIterator it2 = resetList.nodeIterator();
                if (it2.hasNext()) {
                    Node first = (Node)it2.next();
                    it.set(first);
                }
                while (it2.hasNext()) {
                    it.add(it2.next());
                }
                this.clearCompressedInformations_i(resetList);
                continue;
            }
            this.clearCompressedInformations_i(node.getChildren());
        }
    }

    private int getProperId(Integer objectId) {
        if (CallTreeManager.substituteId) {
            Integer minId = (Integer)CallTreeManager.getInstance().getIdMap().get(objectId);
            if (objectId == 0) {
                minId = objectId;
            } else if (minId == null) {
                minId = new Integer(CallTreeManager.getInstance().getIdMap().size() + 1);
                CallTreeManager.getInstance().getIdMap().put(objectId, minId);
            }
            return minId;
        }
        return objectId;
    }

    public Stack getCurrentCallStack() {
        return this.callStack;
    }
}

