/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.node.CallTree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CallTreeManager {
    public static boolean noClinit = false;
    public static boolean substituteId = true;
    private static CallTreeManager singleton = new CallTreeManager();
    private HashMap idMap = new HashMap();
    private HashMap treeIndexMap = new HashMap();
    private List callTreeList = new ArrayList();

    private CallTreeManager() {
    }

    public static CallTreeManager getInstance() {
        return singleton;
    }

    public Map getIdMap() {
        return this.idMap;
    }

    public void clearIdMap() {
        this.idMap.clear();
    }

    public CallTree makeCallTree() {
        CallTree tree = new CallTree();
        this.callTreeList.add(tree);
        return tree;
    }

    public CallTree makeCallTree(Object key) {
        Integer index = new Integer(this.callTreeList.size());
        this.treeIndexMap.put(key, index);
        CallTree tree = new CallTree();
        this.callTreeList.add(tree);
        return tree;
    }

    public CallTree makeCallTree(Object key, File file) {
        Integer index = new Integer(this.callTreeList.size());
        this.treeIndexMap.put(key, index);
        return this.makeCallTree(file);
    }

    public CallTree makeCallTree(File file) {
        CallTree newTree = null;
        try {
            newTree = new CallTree(file);
        }
        catch (IOException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
        this.callTreeList.add(newTree);
        return newTree;
    }

    public CallTree getCallTree(int index) {
        return (CallTree)this.callTreeList.get(index);
    }

    public CallTree getCallTree(Object o) {
        if (!this.treeIndexMap.containsKey(o)) {
            return null;
        }
        Integer index = (Integer)this.treeIndexMap.get(o);
        return this.getCallTree(index);
    }

    public int getCallTreeIndex(Object o) {
        if (!this.treeIndexMap.containsKey(o)) {
            return -1;
        }
        Integer index = (Integer)this.treeIndexMap.get(o);
        return index;
    }

    public int getCallTreeIndex(CallTree tree) {
        return this.callTreeList.indexOf(tree);
    }

    public void removeCallTree(int index) {
        this.callTreeList.remove(index);
        this.declementIndexMap(index);
    }

    public void removeCallTree(Object o) {
        if (this.treeIndexMap.containsKey(o)) {
            Integer index = (Integer)this.treeIndexMap.get(o);
            this.callTreeList.remove(index);
            this.treeIndexMap.remove(o);
            this.declementIndexMap(index);
        }
    }

    public void removeCallTree(CallTree tree) {
        int index = this.callTreeList.indexOf(tree);
        this.callTreeList.remove(tree);
        this.declementIndexMap(index);
    }

    private void declementIndexMap(int borderIndex) {
        Iterator it = this.treeIndexMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object o = entry.getKey();
            int ivalue = (Integer)entry.getValue();
            if (ivalue == borderIndex) {
                it.remove();
                continue;
            }
            if (ivalue <= borderIndex) continue;
            this.treeIndexMap.put(o, new Integer(ivalue - 1));
        }
    }

    public void setKey(Object key, int index) {
        this.treeIndexMap.put(key, new Integer(index));
    }

    public void setKey(Object key, CallTree tree) {
        int index = this.getCallTreeIndex(tree);
        if (index != -1) {
            this.treeIndexMap.put(key, new Integer(index));
        }
    }

    public int getCallTreeNum() {
        return this.callTreeList.size();
    }

    public void clearAllCallTree() {
        this.callTreeList.clear();
        this.treeIndexMap.clear();
    }
}

