/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.logcompactor.foldrule.LoopFoldRule;
import amida.node.CallNode;
import amida.node.CallTree;
import amida.node.Node;
import amida.node.NodeList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public abstract class LoopNode
extends Node {
    private NodeList coreChildren;
    private NodeList hiddenChildren;
    private Set loopNums = new TreeSet();
    private LoopFoldRule rule;
    private boolean isFold = true;

    public LoopNode(CallTree tree) {
        super(tree);
        this.coreChildren = new NodeList(this, tree);
        this.hiddenChildren = new NodeList(this, tree);
    }

    public NodeList getChildren() {
        if (this.isFold) {
            return this.coreChildren;
        }
        return this.hiddenChildren;
    }

    public NodeList getCoreChildren() {
        return this.coreChildren;
    }

    public NodeList getHiddenChildren() {
        return this.hiddenChildren;
    }

    public NodeList getAllChildren() {
        return this.hiddenChildren;
    }

    public boolean hasChildren() {
        if (this.isFold) {
            return !this.coreChildren.isEmpty();
        }
        return !this.hiddenChildren.isEmpty();
    }

    public boolean hasCoreChildren() {
        return !this.coreChildren.isEmpty();
    }

    public boolean hasHiddenChildren() {
        return !this.hiddenChildren.isEmpty();
    }

    public void addChild(Node child) {
        this.coreChildren.add(child);
        try {
            Node copy = (Node)child.clone();
            this.hiddenChildren.add(copy);
        }
        catch (CloneNotSupportedException e) {
            System.out.println("can not clone");
        }
        child.setParent(this);
    }

    public void addCoreChild(Node child) {
        this.coreChildren.add(child);
        child.setParent(this);
    }

    public void addHiddenChild(Node child) {
        this.hiddenChildren.add(child);
        child.setParent(this);
    }

    public void removeAllChildren() {
        this.coreChildren.clear();
        this.hiddenChildren.clear();
    }

    public void removeHiddenChildren() {
        this.hiddenChildren.clear();
    }

    public void removeCoreChildren() {
        this.coreChildren.clear();
    }

    public void addLoopNum(int loopNum) {
        this.addLoopNum(new Integer(loopNum));
    }

    public void addLoopNum(Integer loopNum) {
        this.loopNums.add(loopNum);
    }

    public int getLoopNum(int index) {
        if (index >= 0 && index < this.loopNums.size()) {
            Iterator it = this.loopNums.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i == index) {
                    return (Integer)it.next();
                }
                it.next();
                ++i;
            }
        }
        return 0;
    }

    public Set getLoopNums() {
        return this.loopNums;
    }

    public void setLoopNums(Set loopNums) {
        this.loopNums = loopNums;
    }

    public void setFold(boolean b) {
        this.isFold = b;
    }

    public boolean isFold() {
        return this.isFold;
    }

    public int getCallNodeNum() {
        int result = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            result += ((Node)it.next()).getCallNodeNum();
        }
        return result;
    }

    public CallNode getCallNode(int i) {
        int num = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (num + node.getCallNodeNum() > i) {
                return node.getCallNode(i - num);
            }
            num += node.getCallNodeNum();
        }
        throw new IndexOutOfBoundsException();
    }

    public Object clone() throws CloneNotSupportedException {
        LoopNode copy = (LoopNode)super.clone();
        NodeList newCoreChildren = new NodeList(copy, this.getCallTree());
        Iterator it1 = this.getCoreChildren().iterator();
        while (it1.hasNext()) {
            Node child = (Node)((Node)it1.next()).clone();
            child.setParent(copy);
            newCoreChildren.add(child);
        }
        copy.coreChildren = newCoreChildren;
        NodeList newHiddenChildren = new NodeList(copy, this.getCallTree());
        Iterator it2 = this.getHiddenChildren().iterator();
        while (it2.hasNext()) {
            Node child = (Node)((Node)it2.next()).clone();
            child.setParent(copy);
            newHiddenChildren.add(child);
        }
        copy.hiddenChildren = newHiddenChildren;
        TreeSet newLoopNums = new TreeSet();
        Iterator it = this.getLoopNums().iterator();
        while (it.hasNext()) {
            newLoopNums.add(it.next());
        }
        copy.setLoopNums(newLoopNums);
        return copy;
    }

    public int getDefaultSize() {
        return 0;
    }

    public void setRule(LoopFoldRule rule) {
        this.rule = rule;
    }

    public abstract void makeCoreChildren();

    public LoopFoldRule getRule() {
        return this.rule;
    }
}

