/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.node.CallNode;
import amida.node.CallTree;
import amida.node.NodeIterator;
import amida.node.NodeList;
import java.util.Iterator;

public abstract class Node
implements Cloneable {
    private NodeList children;
    private NodeList emptyList;
    private CallTree tree = null;
    private Node parent = null;
    private boolean isBehind = false;

    public Node(CallTree tree) {
        this.tree = tree;
        this.children = new NodeList(this, tree);
        this.emptyList = new NodeList(this, tree);
    }

    public CallTree getCallTree() {
        return this.tree;
    }

    public void setCallTree(CallTree tree) {
        this.tree = tree;
    }

    public void addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public NodeList getChildren() {
        if (!this.isBehind()) {
            return this.children;
        }
        return this.emptyList;
    }

    public NodeList getBehindChildren() {
        if (this.isBehind()) {
            return this.children;
        }
        return this.emptyList;
    }

    public NodeList getAllChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty() && !this.isBehind();
    }

    public void setBehind(boolean behind) {
        if (behind && !this.hasChildren()) {
            return;
        }
        this.isBehind = behind;
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
    }

    public boolean isBehind() {
        return this.isBehind;
    }

    public NodeIterator nodeIterator() {
        return this.getChildren().nodeIterator();
    }

    public Object clone() throws CloneNotSupportedException {
        Node copy = (Node)super.clone();
        NodeList newChildren = new NodeList(copy, this.getCallTree());
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Node child = (Node)((Node)it.next()).clone();
            child.setParent(copy);
            newChildren.add(child);
        }
        copy.children = newChildren;
        copy.parent = null;
        return copy;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (this.hasChildren()) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                buffer.append(((Node)it.next()).toString(depth));
                if (!it.hasNext()) continue;
                buffer.append(lineSeparator);
            }
        }
        return buffer.toString();
    }

    public abstract int getCallNodeNum();

    public abstract CallNode getCallNode(int var1);

    public abstract Node getNewInstance();
}

